/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.codeInsight.highlighting;

import com.intellij.java.frontback.psi.impl.ClassFileInformation;
import com.intellij.java.frontback.psi.impl.ClassFileInformationType;
import com.intellij.java.frontend.codeInsight.highlighting.FrontendJavaFileHighlighter;
import com.intellij.java.frontend.elements.FrontendJavaParserUtil;
import com.intellij.java.frontend.parser.JavaClassVirtualFileCustomDataConsumerKt;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrontendJavaSyntaxHighlighterFactory
extends SyntaxHighlighterFactory
implements SyntaxHighlighterProvider {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
        return new FrontendJavaFileHighlighter(project == null ? LanguageLevel.HIGHEST : FrontendJavaParserUtil.getLanguageLevel(file, project));
    }

    @Nullable
    public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file) {
        if (fileType == null) {
            FrontendJavaSyntaxHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (project == null || file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        Language language = psiFile.getLanguage();
        if (language != JavaLanguage.INSTANCE) {
            return null;
        }
        ClassFileInformation information = JavaClassVirtualFileCustomDataConsumerKt.classFileContext(file, project);
        if (information == null || information.getClassFileInformationType() == null) {
            return null;
        }
        if (information.getClassFileInformationType() == ClassFileInformationType.JAVA_CLASS_FILE_OUTSIDE) {
            return FrontendJavaSyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file);
        }
        return new FrontendJavaFileHighlighter(FrontendJavaParserUtil.getLanguageLevel(file, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/java/frontend/codeInsight/highlighting/FrontendJavaSyntaxHighlighterFactory", "create"));
    }
}

