/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenGeneralPanel;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenGeneralConfigurable
extends MavenGeneralPanel
implements SearchableConfigurable {
    private final Project myProject;

    public MavenGeneralConfigurable(Project project) {
        this.myProject = project;
    }

    private MavenGeneralSettings getState() {
        return MavenProjectsManager.getInstance(this.myProject).getGeneralSettings();
    }

    @Override
    public JComponent createComponent() {
        if (this.myProject.isDefault()) {
            this.showCheckBoxWithAdvancedSettings();
        }
        return super.createComponent();
    }

    public boolean isModified() {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(this.getState());
    }

    public void apply() {
        this.setData(this.getState());
    }

    public void reset() {
        this.initializeFormData(this.getState(), this.myProject);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.dialog.project.maven";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            MavenGeneralConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenGeneralConfigurable", "getId"));
    }
}

