/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import jakarta.persistence.LockModeType;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;

public final class LockModeConverter {
    private LockModeConverter() {
    }

    public static LockModeType convertToLockModeType(LockMode lockMode) {
        switch (lockMode) {
            case NONE: 
            case READ: {
                return LockModeType.NONE;
            }
            case OPTIMISTIC: {
                return LockModeType.OPTIMISTIC;
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
            }
            case PESSIMISTIC_READ: {
                return LockModeType.PESSIMISTIC_READ;
            }
            case PESSIMISTIC_WRITE: 
            case UPGRADE_NOWAIT: 
            case UPGRADE_SKIPLOCKED: {
                return LockModeType.PESSIMISTIC_WRITE;
            }
            case WRITE: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return LockModeType.PESSIMISTIC_FORCE_INCREMENT;
            }
        }
        throw new AssertionFailure("unhandled lock mode " + lockMode);
    }

    public static LockMode convertToLockMode(LockModeType lockMode) {
        switch (lockMode) {
            case NONE: {
                return LockMode.NONE;
            }
            case READ: 
            case OPTIMISTIC: {
                return LockMode.OPTIMISTIC;
            }
            case WRITE: 
            case OPTIMISTIC_FORCE_INCREMENT: {
                return LockMode.OPTIMISTIC_FORCE_INCREMENT;
            }
            case PESSIMISTIC_READ: {
                return LockMode.PESSIMISTIC_READ;
            }
            case PESSIMISTIC_WRITE: {
                return LockMode.PESSIMISTIC_WRITE;
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return LockMode.PESSIMISTIC_FORCE_INCREMENT;
            }
        }
        throw new AssertionFailure("Unknown LockModeType: " + lockMode);
    }
}

