/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4HC_CCtx_internal")
public class LZ4HCCCtxInternal
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASHTABLE;
    public static final int CHAINTABLE;
    public static final int END;
    public static final int BASE;
    public static final int DICTBASE;
    public static final int DICTLIMIT;
    public static final int LOWLIMIT;
    public static final int NEXTTOUPDATE;
    public static final int COMPRESSIONLEVEL;
    public static final int FAVORDECSPEED;
    public static final int DIRTY;
    public static final int DICTCTX;

    public LZ4HCCCtxInternal(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4HCCCtxInternal.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LZ4_u32[LZ4HC_HASHTABLESIZE]")
    public IntBuffer hashTable() {
        return LZ4HCCCtxInternal.nhashTable(this.address());
    }

    @NativeType(value="LZ4_u32")
    public int hashTable(int index) {
        return LZ4HCCCtxInternal.nhashTable(this.address(), index);
    }

    @NativeType(value="LZ4_u16[LZ4HC_MAXD]")
    public ShortBuffer chainTable() {
        return LZ4HCCCtxInternal.nchainTable(this.address());
    }

    @NativeType(value="LZ4_u16")
    public short chainTable(int index) {
        return LZ4HCCCtxInternal.nchainTable(this.address(), index);
    }

    @NativeType(value="LZ4_byte const *")
    public ByteBuffer end(int capacity) {
        return LZ4HCCCtxInternal.nend(this.address(), capacity);
    }

    @NativeType(value="LZ4_byte const *")
    public ByteBuffer base(int capacity) {
        return LZ4HCCCtxInternal.nbase(this.address(), capacity);
    }

    @NativeType(value="LZ4_byte const *")
    public ByteBuffer dictBase(int capacity) {
        return LZ4HCCCtxInternal.ndictBase(this.address(), capacity);
    }

    @NativeType(value="LZ4_u32")
    public int dictLimit() {
        return LZ4HCCCtxInternal.ndictLimit(this.address());
    }

    @NativeType(value="LZ4_u32")
    public int lowLimit() {
        return LZ4HCCCtxInternal.nlowLimit(this.address());
    }

    @NativeType(value="LZ4_u32")
    public int nextToUpdate() {
        return LZ4HCCCtxInternal.nnextToUpdate(this.address());
    }

    public short compressionLevel() {
        return LZ4HCCCtxInternal.ncompressionLevel(this.address());
    }

    @NativeType(value="LZ4_i8")
    public byte favorDecSpeed() {
        return LZ4HCCCtxInternal.nfavorDecSpeed(this.address());
    }

    @NativeType(value="LZ4_i8")
    public byte dirty() {
        return LZ4HCCCtxInternal.ndirty(this.address());
    }

    @NativeType(value="LZ4HC_CCtx_internal * const")
    public LZ4HCCCtxInternal dictCtx() {
        return LZ4HCCCtxInternal.ndictCtx(this.address());
    }

    public static LZ4HCCCtxInternal create(long address) {
        return (LZ4HCCCtxInternal)LZ4HCCCtxInternal.wrap(LZ4HCCCtxInternal.class, (long)address);
    }

    @Nullable
    public static LZ4HCCCtxInternal createSafe(long address) {
        return address == 0L ? null : (LZ4HCCCtxInternal)LZ4HCCCtxInternal.wrap(LZ4HCCCtxInternal.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LZ4HCCCtxInternal.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LZ4HCCCtxInternal.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static IntBuffer nhashTable(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)HASHTABLE), (int)32768);
    }

    public static int nhashTable(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)HASHTABLE + Checks.check((int)index, (int)32768) * 4L);
    }

    public static ShortBuffer nchainTable(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)CHAINTABLE), (int)65536);
    }

    public static short nchainTable(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)CHAINTABLE + Checks.check((int)index, (int)65536) * 2L);
    }

    public static ByteBuffer nend(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)END)), (int)capacity);
    }

    public static ByteBuffer nbase(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BASE)), (int)capacity);
    }

    public static ByteBuffer ndictBase(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DICTBASE)), (int)capacity);
    }

    public static int ndictLimit(long struct) {
        return UNSAFE.getInt(null, struct + (long)DICTLIMIT);
    }

    public static int nlowLimit(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOWLIMIT);
    }

    public static int nnextToUpdate(long struct) {
        return UNSAFE.getInt(null, struct + (long)NEXTTOUPDATE);
    }

    public static short ncompressionLevel(long struct) {
        return UNSAFE.getShort(null, struct + (long)COMPRESSIONLEVEL);
    }

    public static byte nfavorDecSpeed(long struct) {
        return UNSAFE.getByte(null, struct + (long)FAVORDECSPEED);
    }

    public static byte ndirty(long struct) {
        return UNSAFE.getByte(null, struct + (long)DIRTY);
    }

    public static LZ4HCCCtxInternal ndictCtx(long struct) {
        return LZ4HCCCtxInternal.create(MemoryUtil.memGetAddress((long)(struct + (long)DICTCTX)));
    }

    static {
        Struct.Layout layout = LZ4HCCCtxInternal.__struct((Struct.Member[])new Struct.Member[]{LZ4HCCCtxInternal.__array((int)4, (int)32768), LZ4HCCCtxInternal.__array((int)2, (int)65536), LZ4HCCCtxInternal.__member((int)POINTER_SIZE), LZ4HCCCtxInternal.__member((int)POINTER_SIZE), LZ4HCCCtxInternal.__member((int)POINTER_SIZE), LZ4HCCCtxInternal.__member((int)4), LZ4HCCCtxInternal.__member((int)4), LZ4HCCCtxInternal.__member((int)4), LZ4HCCCtxInternal.__member((int)2), LZ4HCCCtxInternal.__member((int)1), LZ4HCCCtxInternal.__member((int)1), LZ4HCCCtxInternal.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASHTABLE = layout.offsetof(0);
        CHAINTABLE = layout.offsetof(1);
        END = layout.offsetof(2);
        BASE = layout.offsetof(3);
        DICTBASE = layout.offsetof(4);
        DICTLIMIT = layout.offsetof(5);
        LOWLIMIT = layout.offsetof(6);
        NEXTTOUPDATE = layout.offsetof(7);
        COMPRESSIONLEVEL = layout.offsetof(8);
        FAVORDECSPEED = layout.offsetof(9);
        DIRTY = layout.offsetof(10);
        DICTCTX = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<LZ4HCCCtxInternal, Buffer> {
        private static final LZ4HCCCtxInternal ELEMENT_FACTORY = LZ4HCCCtxInternal.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4HCCCtxInternal getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LZ4_u32[LZ4HC_HASHTABLESIZE]")
        public IntBuffer hashTable() {
            return LZ4HCCCtxInternal.nhashTable(this.address());
        }

        @NativeType(value="LZ4_u32")
        public int hashTable(int index) {
            return LZ4HCCCtxInternal.nhashTable(this.address(), index);
        }

        @NativeType(value="LZ4_u16[LZ4HC_MAXD]")
        public ShortBuffer chainTable() {
            return LZ4HCCCtxInternal.nchainTable(this.address());
        }

        @NativeType(value="LZ4_u16")
        public short chainTable(int index) {
            return LZ4HCCCtxInternal.nchainTable(this.address(), index);
        }

        @NativeType(value="LZ4_byte const *")
        public ByteBuffer end(int capacity) {
            return LZ4HCCCtxInternal.nend(this.address(), capacity);
        }

        @NativeType(value="LZ4_byte const *")
        public ByteBuffer base(int capacity) {
            return LZ4HCCCtxInternal.nbase(this.address(), capacity);
        }

        @NativeType(value="LZ4_byte const *")
        public ByteBuffer dictBase(int capacity) {
            return LZ4HCCCtxInternal.ndictBase(this.address(), capacity);
        }

        @NativeType(value="LZ4_u32")
        public int dictLimit() {
            return LZ4HCCCtxInternal.ndictLimit(this.address());
        }

        @NativeType(value="LZ4_u32")
        public int lowLimit() {
            return LZ4HCCCtxInternal.nlowLimit(this.address());
        }

        @NativeType(value="LZ4_u32")
        public int nextToUpdate() {
            return LZ4HCCCtxInternal.nnextToUpdate(this.address());
        }

        public short compressionLevel() {
            return LZ4HCCCtxInternal.ncompressionLevel(this.address());
        }

        @NativeType(value="LZ4_i8")
        public byte favorDecSpeed() {
            return LZ4HCCCtxInternal.nfavorDecSpeed(this.address());
        }

        @NativeType(value="LZ4_i8")
        public byte dirty() {
            return LZ4HCCCtxInternal.ndirty(this.address());
        }

        @NativeType(value="LZ4HC_CCtx_internal * const")
        public LZ4HCCCtxInternal dictCtx() {
            return LZ4HCCCtxInternal.ndictCtx(this.address());
        }
    }
}

