/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import java.util.Arrays;
import javax.swing.event.EventListenerList;
import org.apache.ivy.core.event.FilteredIvyListener;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyEventFilter;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.util.filter.Filter;

public class EventManager
implements TransferListener {
    private EventListenerList listeners = new EventListenerList();

    public void addIvyListener(IvyListener listener) {
        this.listeners.add(IvyListener.class, listener);
    }

    public void addIvyListener(IvyListener listener, String eventName) {
        this.addIvyListener(listener, new IvyEventFilter(eventName, null, null));
    }

    public void addIvyListener(IvyListener listener, Filter<IvyEvent> filter) {
        this.listeners.add(IvyListener.class, new FilteredIvyListener(listener, filter));
    }

    public void removeIvyListener(IvyListener listener) {
        IvyListener[] listeners;
        this.listeners.remove(IvyListener.class, listener);
        for (IvyListener listen : listeners = (IvyListener[])this.listeners.getListeners(IvyListener.class)) {
            if (!(listen instanceof FilteredIvyListener) || !listener.equals(((FilteredIvyListener)listen).getIvyListener())) continue;
            this.listeners.remove(IvyListener.class, listen);
        }
    }

    public boolean hasIvyListener(IvyListener listener) {
        IvyListener[] listeners;
        for (IvyListener listen : listeners = (IvyListener[])this.listeners.getListeners(IvyListener.class)) {
            if (!(listen instanceof FilteredIvyListener) || !listener.equals(((FilteredIvyListener)listen).getIvyListener())) continue;
            return true;
        }
        return false;
    }

    public void fireIvyEvent(IvyEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IvyListener.class) continue;
            ((IvyListener)listeners[i + 1]).progress(evt);
        }
    }

    public void addTransferListener(TransferListener listener) {
        this.listeners.add(TransferListener.class, listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this.listeners.remove(TransferListener.class, listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return Arrays.asList((TransferListener[])this.listeners.getListeners(TransferListener.class)).contains(listener);
    }

    protected void fireTransferEvent(TransferEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransferListener.class) continue;
            ((TransferListener)listeners[i + 1]).transferProgress(evt);
        }
    }

    @Override
    public void transferProgress(TransferEvent evt) {
        this.fireTransferEvent(evt);
        this.fireIvyEvent(evt);
    }
}

