/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.pipenv;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0001\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/sdk/pipenv/PipEnvPipFileWatcher;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "changeListenerKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "notificationActive", "", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "notifyPipFileChanged", "module", "Lcom/intellij/openapi/module/Module;", "runPipEnvInBackground", "args", "", "", "description", "isPipFileEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.python.community.impl"})
public final class PipEnvPipFileWatcher
implements EditorFactoryListener {
    @NotNull
    private final Key<DocumentListener> changeListenerKey;
    @NotNull
    private final Key<Boolean> notificationActive;

    public PipEnvPipFileWatcher() {
        Key key = Key.create((String)"Pipfile.change.listener");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.changeListenerKey = key;
        Key key2 = Key.create((String)"Pipfile.notification.active");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        this.notificationActive = key2;
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Project project;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                project = event.getEditor().getProject();
                if (project == null) break block2;
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                if (this.isPipFileEditor(editor2)) break block3;
            }
            return;
        }
        DocumentListener listener2 = new DocumentListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ PipEnvPipFileWatcher this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                VirtualFile virtualFile = PipenvKt.access$getVirtualFile(document2);
                if (virtualFile == null || (virtualFile = PipenvKt.access$getModule(virtualFile, this.$project)) == null) {
                    return;
                }
                VirtualFile module = virtualFile;
                if (FileDocumentManager.getInstance().isDocumentUnsaved(document2)) {
                    PipEnvPipFileWatcher.access$notifyPipFileChanged(this.this$0, (Module)module);
                }
            }
        };
        Document $this$editorCreated_u24lambda_u240 = event.getEditor().getDocument();
        boolean bl = false;
        $this$editorCreated_u24lambda_u240.addDocumentListener(listener2);
        $this$editorCreated_u24lambda_u240.putUserData(this.changeListenerKey, (Object)listener2);
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DocumentListener documentListener2 = (DocumentListener)event.getEditor().getUserData(this.changeListenerKey);
        if (documentListener2 == null) {
            return;
        }
        DocumentListener listener2 = documentListener2;
        event.getEditor().getDocument().removeDocumentListener(listener2);
    }

    private final void notifyPipFileChanged(Module module) {
        if (Intrinsics.areEqual((Object)module.getUserData(this.notificationActive), (Object)true)) {
            return;
        }
        String string = PipenvKt.access$getPipFileLock(module) == null ? PyBundle.message("python.sdk.pipenv.pip.file.lock.not.found", new Object[0]) : PyBundle.message("python.sdk.pipenv.pip.file.lock.out.of.date", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String title = string;
        String string2 = PyBundle.message("python.sdk.pipenv.pip.file.notification.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String content = string2;
        Notification notification = PipenvKt.access$getLOCK_NOTIFICATION_GROUP$p().createNotification(title, content, NotificationType.INFORMATION).setListener((arg_0, arg_1) -> PipEnvPipFileWatcher.notifyPipFileChanged$lambda$1(module, this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setListener(...)");
        Notification notification2 = notification;
        module.putUserData(this.notificationActive, (Object)true);
        notification2.whenExpired(() -> PipEnvPipFileWatcher.notifyPipFileChanged$lambda$2(module, this));
        notification2.notify(module.getProject());
    }

    private final void runPipEnvInBackground(Module module, List<String> args, @NlsContexts.ProgressTitle String description) {
        Project project = module.getProject();
        Task.Backgroundable task2 = new Task.Backgroundable(description, module, args, project){
            final /* synthetic */ String $description;
            final /* synthetic */ Module $module;
            final /* synthetic */ List<String> $args;
            {
                this.$description = $description;
                this.$module = $module;
                this.$args = $args;
                super($super_call_param$1, $description, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Sdk sdk2 = PySdkExtKt.getPythonSdk(this.$module);
                if (sdk2 == null) {
                    return;
                }
                Sdk sdk3 = sdk2;
                indicator.setText(this.$description + "...");
                try {
                    Collection $this$toTypedArray$iv = this.$args;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    PipenvKt.runPipEnv(sdk3, Arrays.copyOf(stringArray, stringArray.length));
                }
                catch (RunCanceledByUserException $this$toTypedArray$iv) {
                }
                catch (ExecutionException e) {
                    String string = PyBundle.message("python.sdk.pipenv.execution.exception.error.running.pipenv.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    PySdkExtKt.showSdkExecutionException(sdk3, e, string);
                }
                finally {
                    VirtualFile virtualFile = PythonSdkUtil.getSitePackagesDirectory(sdk3);
                    if (virtualFile != null) {
                        virtualFile.refresh(true, true);
                    }
                    VirtualFile virtualFile2 = PySdkExtKt.getAssociatedModuleDir(sdk3);
                    if (virtualFile2 != null) {
                        virtualFile2.refresh(true, false);
                    }
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private final boolean isPipFileEditor(Editor editor2) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        VirtualFile virtualFile = PipenvKt.access$getVirtualFile(document);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (!Intrinsics.areEqual((Object)file.getName(), (Object)"Pipfile")) {
            return false;
        }
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Module module = PipenvKt.access$getModule(file, project2);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (!Intrinsics.areEqual((Object)PipenvKt.getPipFile(module2), (Object)file)) {
            return false;
        }
        Sdk sdk2 = PySdkExtKt.getPythonSdk(module2);
        return sdk2 != null ? PipenvKt.isPipEnv(sdk2) : false;
    }

    private static final void notifyPipFileChanged$lambda$1(Module $module, PipEnvPipFileWatcher this$0, Notification notification, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        notification.expire();
        $module.putUserData(this$0.notificationActive, null);
        FileDocumentManager.getInstance().saveAllDocuments();
        String string = event.getDescription();
        if (Intrinsics.areEqual((Object)string, (Object)"#lock")) {
            List list = CollectionsKt.listOf((Object)"lock");
            String string2 = PyBundle.message("python.sdk.pipenv.pip.file.notification.locking", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this$0.runPipEnvInBackground($module, list, string2);
        } else if (Intrinsics.areEqual((Object)string, (Object)"#update")) {
            Object[] objectArray = new String[]{"update", "--dev"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            String string3 = PyBundle.message("python.sdk.pipenv.pip.file.notification.updating", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this$0.runPipEnvInBackground($module, list, string3);
        }
    }

    private static final void notifyPipFileChanged$lambda$2(Module $module, PipEnvPipFileWatcher this$0) {
        $module.putUserData(this$0.notificationActive, null);
    }

    public static final /* synthetic */ void access$notifyPipFileChanged(PipEnvPipFileWatcher $this, Module module) {
        $this.notifyPipFileChanged(module);
    }
}

