/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JTabbedPane;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.description.Description;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.data.Index;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JTabbedPaneLocation;
import org.assertj.swing.driver.JTabbedPaneSelectTabQuery;
import org.assertj.swing.driver.JTabbedPaneSelectTabTask;
import org.assertj.swing.driver.JTabbedPaneTabTitlesQuery;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.PatternTextMatcher;
import org.assertj.swing.util.StringTextMatcher;
import org.assertj.swing.util.TextMatcher;

@InternalApi
public class JTabbedPaneDriver
extends JComponentDriver {
    private final JTabbedPaneLocation location;

    public JTabbedPaneDriver(@Nonnull Robot robot) {
        this(robot, new JTabbedPaneLocation());
    }

    @VisibleForTesting
    JTabbedPaneDriver(@Nonnull Robot robot, @Nonnull JTabbedPaneLocation location) {
        super(robot);
        this.location = location;
    }

    @Nonnull
    @RunsInEDT
    public String[] tabTitles(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneTabTitlesQuery.tabTitlesOf(tabbedPane);
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, @Nullable String title) {
        this.selectTab(tabbedPane, new StringTextMatcher(title));
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern) {
        this.selectTab(tabbedPane, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectTab(@Nonnull JTabbedPane tabbedPane, @Nonnull TextMatcher matcher2) {
        Pair<Integer, Point> tabToSelectInfo = JTabbedPaneDriver.tabToSelectInfo(this.location(), tabbedPane, matcher2);
        Point target = (Point)tabToSelectInfo.second;
        if (target != null) {
            try {
                JTabbedPaneDriver.checkInEdtEnabledAndShowing(tabbedPane);
                this.click((Component)tabbedPane, target);
            }
            catch (ActionFailedException e) {
                this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.first);
            }
            return;
        }
        this.setTabDirectly(tabbedPane, (Integer)tabToSelectInfo.first);
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Integer, Point> tabToSelectInfo(final @Nonnull JTabbedPaneLocation location, final @Nonnull JTabbedPane tabbedPane, final @Nonnull TextMatcher matcher2) {
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tabbedPane);
                int index = location.indexOf(tabbedPane, matcher2);
                location.checkIndexInBounds(tabbedPane, index);
                Point point = null;
                try {
                    point = location.pointAt(tabbedPane, index);
                }
                catch (LocationUnavailableException locationUnavailableException) {
                    // empty catch block
                }
                return Pair.of(index, point);
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @RunsInEDT
    public void selectTab(@Nonnull JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.pointAtTabWhenShowing(this.location(), tabbedPane, index);
            JTabbedPaneDriver.checkInEdtEnabledAndShowing(tabbedPane);
            this.click((Component)tabbedPane, p);
        }
        catch (ActionFailedException | LocationUnavailableException e) {
            this.setTabDirectly(tabbedPane, index);
        }
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtTabWhenShowing(@Nonnull JTabbedPaneLocation location, @Nonnull JTabbedPane tabbedPane, int index) {
        Point result = GuiActionRunner.execute(() -> {
            location.checkIndexInBounds(tabbedPane, index);
            ComponentPreconditions.checkEnabledAndShowing(tabbedPane);
            return location.pointAt(tabbedPane, index);
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    @VisibleForTesting
    void setTabDirectly(@Nonnull JTabbedPane tabbedPane, int index) {
        JTabbedPaneSelectTabTask.setSelectedTab(tabbedPane, index);
        this.robot.waitForIdle();
        this.moveMouseToTab(tabbedPane, index);
    }

    private void moveMouseToTab(@Nonnull JTabbedPane tabbedPane, int index) {
        try {
            Point p = JTabbedPaneDriver.pointAtTab(this.location(), tabbedPane, index);
            this.robot.moveMouse(tabbedPane, p);
            this.robot.waitForIdle();
        }
        catch (LocationUnavailableException locationUnavailableException) {
            // empty catch block
        }
    }

    @Nonnull
    @RunsInEDT
    private static Point pointAtTab(@Nonnull JTabbedPaneLocation location, @Nonnull JTabbedPane tabbedPane, int index) {
        Point result = GuiActionRunner.execute(() -> location.pointAt(tabbedPane, index));
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nullable
    @RunsInEDT
    public Component selectedComponentOf(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.selectedComponent(tabbedPane);
    }

    @Nullable
    @RunsInEDT
    private static Component selectedComponent(JTabbedPane tabbedPane) {
        return GuiActionRunner.execute(() -> tabbedPane.getSelectedComponent());
    }

    @RunsInEDT
    public void requireTabTitle(@Nonnull JTabbedPane tabbedPane, @Nullable String title, @Nonnull Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        ((TextAssert)((Object)TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)))).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTabTitle(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern, @Nonnull Index index) {
        String actualTitle = JTabbedPaneDriver.titleAt(tabbedPane, index);
        ((TextAssert)((Object)TextAssert.verifyThat(actualTitle).as(this.titleAtProperty(tabbedPane)))).matches(pattern);
    }

    @RunsInEDT
    public void requireSelectedTab(@Nonnull JTabbedPane tabbedPane, @Nonnull Index index) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)JTabbedPaneSelectTabQuery.selectedTabIndexOf((JTabbedPane)tabbedPane).value).as(JTabbedPaneDriver.propertyName(tabbedPane, "selectedIndex"))).isEqualTo(index.value);
    }

    @RunsInEDT
    public void requireTabToolTipText(@Nonnull JTabbedPane tabbedPane, @Nullable String toolTipText, @Nonnull Index index) {
        String actualToolTipText = JTabbedPaneDriver.toolTipTextAt(tabbedPane, index);
        ((TextAssert)((Object)TextAssert.verifyThat(actualToolTipText).as(this.toolTipTextAtProperty(tabbedPane)))).isEqualOrMatches(toolTipText);
    }

    @RunsInEDT
    public void requireTabToolTipText(@Nonnull JTabbedPane tabbedPane, @Nonnull Pattern pattern, @Nonnull Index index) {
        String actualToolTipText = JTabbedPaneDriver.toolTipTextAt(tabbedPane, index);
        ((TextAssert)((Object)TextAssert.verifyThat(actualToolTipText).as(this.toolTipTextAtProperty(tabbedPane)))).matches(pattern);
    }

    @RunsInEDT
    public void requireTabEnabled(@Nonnull JTabbedPane tabbedPane, @Nonnull Index index) {
        boolean actualEnabled = JTabbedPaneDriver.isEnabledAt(tabbedPane, index);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualEnabled).as(this.enabledAtProperty(tabbedPane))).isTrue();
    }

    @RunsInEDT
    public void requireTabDisabled(@Nonnull JTabbedPane tabbedPane, @Nonnull Index index) {
        boolean actualEnabled = JTabbedPaneDriver.isEnabledAt(tabbedPane, index);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualEnabled).as(this.enabledAtProperty(tabbedPane))).isFalse();
    }

    @RunsInEDT
    private Description titleAtProperty(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.propertyName(tabbedPane, "titleAt");
    }

    @RunsInEDT
    private Description toolTipTextAtProperty(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.propertyName(tabbedPane, "toolTipTextAt");
    }

    @RunsInEDT
    private Description enabledAtProperty(@Nonnull JTabbedPane tabbedPane) {
        return JTabbedPaneDriver.propertyName(tabbedPane, "enabledAt");
    }

    @Nullable
    @RunsInEDT
    private static String titleAt(@Nonnull JTabbedPane tabbedPane, @Nonnull Index index) {
        return GuiActionRunner.execute(() -> tabbedPane.getTitleAt(index.value));
    }

    @Nullable
    @RunsInEDT
    private static String toolTipTextAt(@Nonnull JTabbedPane tabbedPane, @Nonnull Index index) {
        return GuiActionRunner.execute(() -> tabbedPane.getToolTipTextAt(index.value));
    }

    @Nullable
    @RunsInEDT
    private static boolean isEnabledAt(@Nonnull JTabbedPane tabbedPane, @Nonnull Index index) {
        return GuiActionRunner.execute(() -> tabbedPane.isEnabledAt(index.value));
    }

    @RunsInEDT
    public void requireTabTitles(@Nonnull JTabbedPane tabbedPane, @Nonnull String[] titles) {
        Object[] actualTitles = JTabbedPaneDriver.allTabTitlesIn(tabbedPane);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])actualTitles).as(JTabbedPaneDriver.propertyName(tabbedPane, "tabTitles"))).isEqualTo((Object)titles);
    }

    @Nonnull
    @RunsInEDT
    private static String[] allTabTitlesIn(@Nonnull JTabbedPane tabbedPane) {
        String[] result = GuiActionRunner.execute(() -> {
            ArrayList allTitles = Lists.newArrayList();
            int tabCount = tabbedPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                allTitles.add(tabbedPane.getTitleAt(i));
            }
            return allTitles.toArray(new String[allTitles.size()]);
        });
        return (String[])Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private JTabbedPaneLocation location() {
        return this.location;
    }
}

