/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.toolwindow.ReviewTabsComponentFactory;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.collaboration.util.URIUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorComponentFactory;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabApiManager;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginUtil;
import org.jetbrains.plugins.gitlab.authentication.LoginResult;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountManager;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabAccountsDetailsProvider;
import org.jetbrains.plugins.gitlab.mergerequest.ui.create.GitLabMergeRequestCreateComponentFactory;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.GitLabMergeRequestDetailsComponentFactory;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsLoadingViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.list.GitLabMergeRequestsPanelFactory;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.GitLabReviewTabComponentFactory;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.GitLabSelectorErrorStatusPresenter;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabRepositoryAndAccountSelectorViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabReviewTabViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabToolWindowProjectViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabToolWindowViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;
import org.jetbrains.plugins.gitlab.util.GitLabProjectMapping;
import org.jetbrains.plugins.gitlab.util.GitLabStatistics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J#\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00172\u0006\u0010\u0004\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/GitLabReviewTabComponentFactory;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabsComponentFactory;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabToolWindowProjectViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "toolwindowViewModel", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabToolWindowViewModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabToolWindowViewModel;)V", "createReviewListComponent", "Ljavax/swing/JComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "projectVm", "createTabComponent", "tabVm", "createEmptyTabContent", "createReviewDetailsComponent", "reviewDetailsVm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsLoadingViewModel;", "createSelectorsComponent", "createLoginButtons", "", "Ljavax/swing/JButton;", "scope", "vm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabRepositoryAndAccountSelectorViewModel;", "createPopupLoginActions", "Ljavax/swing/Action;", "mapping", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectMapping;", "getProjectDisplayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "allProjects", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "needToShowServer", "", "projects", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabReviewTabComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabReviewTabComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/GitLabReviewTabComponentFactory\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n40#2,3:186\n1755#3,3:189\n1557#3:192\n1628#3,3:193\n*S KotlinDebug\n*F\n+ 1 GitLabReviewTabComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/GitLabReviewTabComponentFactory\n*L\n89#1:186,3\n182#1:189,3\n108#1:192\n108#1:193,3\n*E\n"})
public final class GitLabReviewTabComponentFactory
implements ReviewTabsComponentFactory<GitLabReviewTabViewModel, GitLabToolWindowProjectViewModel> {
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabToolWindowViewModel toolwindowViewModel;

    public GitLabReviewTabComponentFactory(@NotNull Project project, @NotNull GitLabToolWindowViewModel toolwindowViewModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolwindowViewModel, (String)"toolwindowViewModel");
        this.project = project;
        this.toolwindowViewModel = toolwindowViewModel;
    }

    @NotNull
    public JComponent createReviewListComponent(@NotNull CoroutineScope cs, @NotNull GitLabToolWindowProjectViewModel projectVm) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectVm, (String)"projectVm");
        GitLabStatistics.INSTANCE.logTwTabOpened(this.project, GitLabStatistics.ToolWindowTabType.LIST, GitLabStatistics.ToolWindowOpenTabActionPlace.TOOLWINDOW);
        return new GitLabMergeRequestsPanelFactory().create(cs, projectVm.getAccountVm(), projectVm.getListVm());
    }

    @NotNull
    public JComponent createTabComponent(@NotNull CoroutineScope cs, @NotNull GitLabToolWindowProjectViewModel projectVm, @NotNull GitLabReviewTabViewModel tabVm) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectVm, (String)"projectVm");
        Intrinsics.checkNotNullParameter((Object)tabVm, (String)"tabVm");
        GitLabReviewTabViewModel gitLabReviewTabViewModel = tabVm;
        if (gitLabReviewTabViewModel instanceof GitLabReviewTabViewModel.Details) {
            GitLabMergeRequestDetailsLoadingViewModel gitLabMergeRequestDetailsLoadingViewModel;
            JComponent jComponent2;
            JComponent it = jComponent2 = this.createReviewDetailsComponent(cs, projectVm, ((GitLabReviewTabViewModel.Details)tabVm).getDetailsVm());
            boolean bl = false;
            GitLabMergeRequestDetailsLoadingViewModel $this$createTabComponent_u24lambda_u241_u24lambda_u240 = gitLabMergeRequestDetailsLoadingViewModel = ((GitLabReviewTabViewModel.Details)tabVm).getDetailsVm();
            boolean bl2 = false;
            $this$createTabComponent_u24lambda_u241_u24lambda_u240.refreshData();
            jComponent = jComponent2;
        } else if (gitLabReviewTabViewModel instanceof GitLabReviewTabViewModel.CreateMergeRequest) {
            jComponent = GitLabMergeRequestCreateComponentFactory.INSTANCE.create(this.project, cs, ((GitLabReviewTabViewModel.CreateMergeRequest)tabVm).getCreateVm());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    @NotNull
    public JComponent createEmptyTabContent(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        GitLabStatistics.INSTANCE.logTwTabOpened(this.project, GitLabStatistics.ToolWindowTabType.SELECTOR, GitLabStatistics.ToolWindowOpenTabActionPlace.TOOLWINDOW);
        return this.createSelectorsComponent(cs);
    }

    private final JComponent createReviewDetailsComponent(CoroutineScope cs, GitLabToolWindowProjectViewModel projectVm, GitLabMergeRequestDetailsLoadingViewModel reviewDetailsVm) {
        IconsProvider<GitLabUserDTO> avatarIconsProvider = projectVm.getAvatarIconProvider();
        return GitLabMergeRequestDetailsComponentFactory.INSTANCE.createDetailsComponent(this.project, cs, reviewDetailsVm, projectVm.getAccountVm(), avatarIconsProvider);
    }

    private final JComponent createSelectorsComponent(CoroutineScope cs) {
        JPanel jPanel;
        boolean $i$f$service = false;
        Class<GitLabAccountManager> serviceClass$iv = GitLabAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GitLabAccountManager accountManager = (GitLabAccountManager)object;
        JPanel $this$createSelectorsComponent_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createSelectorsComponent_u24lambda_u242.setBackground(UIUtil.getListBackground());
        JPanel panel2 = jPanel;
        SwingBindingsKt.bindChildIn$default((JPanel)panel2, (CoroutineScope)cs, (Flow)((Flow)this.toolwindowViewModel.getSelectorVm()), (Object)"North", null, (arg_0, arg_1) -> GitLabReviewTabComponentFactory.createSelectorsComponent$lambda$7(accountManager, this, arg_0, arg_1), (int)8, null);
        return panel2;
    }

    private final List<JButton> createLoginButtons(CoroutineScope scope, GitLabRepositoryAndAccountSelectorViewModel vm2) {
        JButton jButton;
        JButton $this$createLoginButtons_u24lambda_u249 = jButton = new JButton(CollaborationToolsBundle.message((String)"login.button", (Object[])new Object[0]));
        boolean bl = false;
        CollaborationToolsUIUtil.INSTANCE.setDefault($this$createLoginButtons_u24lambda_u249, true);
        $this$createLoginButtons_u24lambda_u249.setOpaque(false);
        $this$createLoginButtons_u24lambda_u249.addActionListener(arg_0 -> GitLabReviewTabComponentFactory.createLoginButtons$lambda$9$lambda$8(vm2, arg_0));
        SwingBindingsKt.bindDisabledIn((JComponent)$this$createLoginButtons_u24lambda_u249, (CoroutineScope)scope, (Flow)((Flow)vm2.getBusyState()));
        SwingBindingsKt.bindVisibilityIn((JComponent)$this$createLoginButtons_u24lambda_u249, (CoroutineScope)scope, (Flow)((Flow)vm2.getTokenLoginAvailableState()));
        return CollectionsKt.listOf((Object)jButton);
    }

    private final List<Action> createPopupLoginActions(GitLabRepositoryAndAccountSelectorViewModel vm2, GitLabProjectMapping mapping2) {
        if (mapping2 == null) {
            return CollectionsKt.emptyList();
        }
        String string = CollaborationToolsBundle.message((String)"login.button", (Object[])new Object[0]);
        return CollectionsKt.listOf((Object)new AbstractAction(vm2, string){
            final /* synthetic */ GitLabRepositoryAndAccountSelectorViewModel $vm;
            {
                this.$vm = $vm;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                this.$vm.requestTokenLogin(true, false);
            }
        });
    }

    private final String getProjectDisplayName(List<GitLabProjectCoordinates> allProjects, GitLabProjectCoordinates project) {
        boolean showServer = this.needToShowServer(allProjects);
        StringBuilder builder = new StringBuilder();
        if (showServer) {
            builder.append(URIUtil.INSTANCE.toStringWithoutScheme(project.getServerPath().toURI())).append("/");
        }
        builder.append(project.getProjectPath().getOwner()).append("/");
        builder.append(project.getProjectPath().getName());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean needToShowServer(List<GitLabProjectCoordinates> projects) {
        boolean bl;
        block4: {
            if (projects.size() <= 1) {
                return false;
            }
            GitLabServerPath firstServer = ((GitLabProjectCoordinates)CollectionsKt.first(projects)).getServerPath();
            Iterable $this$any$iv = projects;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitLabProjectCoordinates it = (GitLabProjectCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getServerPath(), (Object)firstServer))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final String createSelectorsComponent$lambda$7$lambda$4(GitLabRepositoryAndAccountSelectorViewModel $selectorVm, GitLabReviewTabComponentFactory this$0, GitLabProjectMapping mapping2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mapping2, (String)"mapping");
        Iterable $this$map$iv = (Iterable)$selectorVm.getRepositoriesState().getValue();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitLabProjectMapping gitLabProjectMapping = (GitLabProjectMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRepository());
        }
        List allProjects = (List)destination$iv$iv;
        return this$0.getProjectDisplayName(allProjects, mapping2.getRepository());
    }

    private static final List createSelectorsComponent$lambda$7$lambda$5(GitLabReviewTabComponentFactory this$0, GitLabRepositoryAndAccountSelectorViewModel $selectorVm, GitLabProjectMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPopupLoginActions($selectorVm, it);
    }

    private static final Unit createSelectorsComponent$lambda$7$lambda$6(GitLabRepositoryAndAccountSelectorViewModel $selectorVm) {
        $selectorVm.submitSelection();
        return Unit.INSTANCE;
    }

    private static final JComponent createSelectorsComponent$lambda$7(GitLabAccountManager $accountManager, GitLabReviewTabComponentFactory this$0, CoroutineScope $this$bindChildIn, GitLabRepositoryAndAccountSelectorViewModel selectorVm2) {
        Intrinsics.checkNotNullParameter((Object)$this$bindChildIn, (String)"$this$bindChildIn");
        if (selectorVm2 == null) {
            return null;
        }
        CoroutineScope selectorCs = $this$bindChildIn;
        GitLabAccountsDetailsProvider accountsDetailsProvider2 = new GitLabAccountsDetailsProvider(selectorCs, $accountManager, (Function2<? super GitLabAccount, ? super Continuation<? super GitLabApi>, ? extends Object>)((Function2)new Function2<GitLabAccount, Continuation<? super GitLabApi>, Object>($accountManager, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ GitLabAccountManager $accountManager;
            {
                this.$accountManager = $accountManager;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        account = (GitLabAccount)this.L$0;
                        this.L$0 = account;
                        this.label = 1;
                        v0 = this.$accountManager.findCredentials((Account)account, (Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        account = (GitLabAccount)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        v1 = (String)v0;
                        if (v1 != null) {
                            token = v1;
                            $i$a$-let-GitLabReviewTabComponentFactory$createSelectorsComponent$1$accountsDetailsProvider$1$1 = false;
                            $i$f$service = false;
                            serviceClass$iv = GitLabApiManager.class;
                            v2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                            if (v2 == null) {
                                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                            }
                            v3 = ((GitLabApiManager)v2).getClient(account.getServer(), token);
                        } else {
                            v3 = null;
                        }
                        return v3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(GitLabAccount p1, Continuation<? super GitLabApi> p2) {
                return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        JComponent selectors = new RepositoryAndAccountSelectorComponentFactory((RepositoryAndAccountSelectorViewModel)selectorVm2).create(selectorCs, arg_0 -> GitLabReviewTabComponentFactory.createSelectorsComponent$lambda$7$lambda$4(selectorVm2, this$0, arg_0), (LoadingAccountsDetailsProvider)accountsDetailsProvider2, arg_0 -> GitLabReviewTabComponentFactory.createSelectorsComponent$lambda$7$lambda$5(this$0, selectorVm2, arg_0), GitLabBundle.message("view.merge.requests.button", new Object[0]), this$0.createLoginButtons(selectorCs, selectorVm2), (ErrorStatusPresenter)new GitLabSelectorErrorStatusPresenter(this$0.project, selectorCs, selectorVm2.getAccountManager(), (Function0<Unit>)((Function0)() -> GitLabReviewTabComponentFactory.createSelectorsComponent$lambda$7$lambda$6(selectorVm2))));
        BuildersKt.launch$default((CoroutineScope)$this$bindChildIn, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectorVm2, this$0, selectors, null){
            int label;
            final /* synthetic */ GitLabRepositoryAndAccountSelectorViewModel $selectorVm;
            final /* synthetic */ GitLabReviewTabComponentFactory this$0;
            final /* synthetic */ JComponent $selectors;
            {
                this.$selectorVm = $selectorVm;
                this.this$0 = $receiver;
                this.$selectors = $selectors;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$selectorVm.getLoginRequestsFlow().collect(new FlowCollector(this.this$0, this.$selectors){
                            final /* synthetic */ GitLabReviewTabComponentFactory this$0;
                            final /* synthetic */ JComponent $selectors;
                            {
                                this.this$0 = $receiver;
                                this.$selectors = $selectors;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(GitLabRepositoryAndAccountSelectorViewModel.TokenLoginRequest req, Continuation<? super Unit> $completion) {
                                GitLabAccount account = req.getAccount();
                                if (account == null) {
                                    void $this$asSafely$iv;
                                    LoginResult loginResult2 = GitLabLoginUtil.INSTANCE.logInViaToken$intellij_vcs_gitlab(GitLabReviewTabComponentFactory.access$getProject$p(this.this$0), this.$selectors, req.getRepo().getRepository().getServerPath(), (Function2<? super GitLabServerPath, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> createSelectorsComponent.1.1.emit$lambda$0(req, arg_0, arg_1)));
                                    boolean $i$f$asSafely = false;
                                    Object v0 = $this$asSafely$iv;
                                    if (!(v0 instanceof LoginResult.Success)) {
                                        v0 = null;
                                    }
                                    LoginResult.Success success = v0;
                                    if (success == null) {
                                        return Unit.INSTANCE;
                                    }
                                    LoginResult.Success success2 = success;
                                    GitLabAccount newAccount = success2.component1();
                                    String token = success2.component2();
                                    req.login(newAccount, token);
                                } else {
                                    void $this$asSafely$iv;
                                    LoginResult token = GitLabLoginUtil.INSTANCE.updateToken$intellij_vcs_gitlab(GitLabReviewTabComponentFactory.access$getProject$p(this.this$0), this.$selectors, account, (Function2<? super GitLabServerPath, ? super String, Boolean>)((Function2)(arg_0, arg_1) -> createSelectorsComponent.1.1.emit$lambda$1(req, arg_0, arg_1)));
                                    boolean $i$f$asSafely = false;
                                    Object v2 = $this$asSafely$iv;
                                    if (!(v2 instanceof LoginResult.Success)) {
                                        v2 = null;
                                    }
                                    LoginResult.Success success = v2;
                                    if (success == null) {
                                        return Unit.INSTANCE;
                                    }
                                    LoginResult.Success loginResult3 = success;
                                    req.login(account, loginResult3.getToken());
                                }
                                return Unit.INSTANCE;
                            }

                            private static final boolean emit$lambda$0(GitLabRepositoryAndAccountSelectorViewModel.TokenLoginRequest $req, GitLabServerPath server, String name) {
                                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                                return GitLabLoginUtil.INSTANCE.isAccountUnique((Collection<GitLabAccount>)$req.getAccounts(), server, name);
                            }

                            private static final boolean emit$lambda$1(GitLabRepositoryAndAccountSelectorViewModel.TokenLoginRequest $req, GitLabServerPath server, String name) {
                                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                                return GitLabLoginUtil.INSTANCE.isAccountUnique((Collection<GitLabAccount>)$req.getAccounts(), server, name);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return selectors;
    }

    private static final void createLoginButtons$lambda$9$lambda$8(GitLabRepositoryAndAccountSelectorViewModel $vm, ActionEvent it) {
        $vm.requestTokenLogin(false, true);
    }

    public static final /* synthetic */ Project access$getProject$p(GitLabReviewTabComponentFactory $this) {
        return $this.project;
    }
}

