/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.XmlSettings;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.analysis.ImportNSAction;
import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNSDeclarationIntentionFix
implements HintAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CreateNSDeclarationIntentionFix.class);
    private final String myNamespacePrefix;
    private final PsiAnchor myElement;
    private final PsiAnchor myToken;

    @NotNull
    private XmlFile getFile() {
        XmlFile xmlFile = (XmlFile)this.myElement.getFile();
        if (xmlFile == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(0);
        }
        return xmlFile;
    }

    protected CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        if (element == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(1);
        }
        if (namespacePrefix == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(2);
        }
        this(element, namespacePrefix, null);
    }

    public CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix, @Nullable XmlToken token) {
        if (element == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(3);
        }
        if (namespacePrefix == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(4);
        }
        this.myNamespacePrefix = namespacePrefix;
        this.myElement = PsiAnchor.create((PsiElement)element);
        this.myToken = token == null ? null : PsiAnchor.create((PsiElement)token);
    }

    @NotNull
    public String getText() {
        String alias = this.getXmlNamespaceHelper().getNamespaceAlias(this.getFile());
        String string = XmlPsiBundle.message((String)"xml.quickfix.create.namespace.declaration.text", (Object[])new Object[]{alias});
        if (string == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private XmlNamespaceHelper getXmlNamespaceHelper() {
        return XmlNamespaceHelper.getHelper((PsiFile)this.getFile());
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlPsiBundle.message((String)"xml.quickfix.create.namespace.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiFile file;
        if (project2 == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(8);
        }
        PsiFile containingFile = descriptor.getPsiElement().getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        PsiFile psiFile = file = editor != null ? PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument()) : null;
        if (file == null || !Comparing.equal((Object)file.getVirtualFile(), (Object)containingFile.getVirtualFile())) {
            return;
        }
        try {
            this.invoke(project2, editor, containingFile);
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull ProblemDescriptor previewDescriptor) {
        if (project2 == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(9);
        }
        if (previewDescriptor == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(10);
        }
        return this.doPreview(project2, previewDescriptor.getPsiElement(), null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        if (project2 == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(12);
        }
        if (file == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(13);
        }
        if ((element = this.myElement.retrieve()) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateNSDeclarationIntentionFix.$$$reportNull$$$0(14);
            }
            return intentionPreviewInfo;
        }
        return this.doPreview(project2, PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)file), editor);
    }

    @NotNull
    private IntentionPreviewInfo doPreview(@NotNull Project project2, PsiElement element, @Nullable Editor editor) {
        PsiFile file;
        if (project2 == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(15);
        }
        if (!((file = element.getContainingFile()) instanceof XmlFile)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateNSDeclarationIntentionFix.$$$reportNull$$$0(16);
            }
            return intentionPreviewInfo;
        }
        XmlFile xmlFile = (XmlFile)file;
        List<String> namespaces = this.getNamespaces(element, xmlFile);
        String namespace = namespaces.isEmpty() ? "" : namespaces.get(0);
        new MyStringToAttributeProcessor(element, project2, editor, xmlFile).doSomethingWithGivenStringToProduceXmlAttributeNowPlease(namespace);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(17);
        }
        return intentionPreviewInfo;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(18);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        PsiElement element = this.myElement.retrieve();
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        return element != null && rootTag != null && !PsiUtilCore.hasErrorElementChild((PsiElement)rootTag);
    }

    @NotNull
    private List<String> getNamespaces(PsiElement element, XmlFile xmlFile) {
        Set<String> set;
        String match2;
        if (element instanceof XmlAttribute) {
            element = element.getParent();
        }
        if ((match2 = CreateNSDeclarationIntentionFix.getUnboundNamespaceForPrefix(this.myNamespacePrefix, xmlFile, set = this.getXmlNamespaceHelper().guessUnboundNamespaces(element, xmlFile))) != null) {
            List<String> list2 = Collections.singletonList(match2);
            if (list2 == null) {
                CreateNSDeclarationIntentionFix.$$$reportNull$$$0(19);
            }
            return list2;
        }
        ArrayList<String> namespaces = new ArrayList<String>(set);
        Collections.sort(namespaces);
        ArrayList<String> arrayList = namespaces;
        if (arrayList == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        if (project2 == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(21);
        }
        if (file == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(22);
        }
        if ((element = this.myElement.retrieve()) == null) {
            return;
        }
        XmlFile xmlFile = this.getFile();
        String[] namespaces = ArrayUtilRt.toStringArray(this.getNamespaces(element, xmlFile));
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(namespaces, project2, new MyStringToAttributeProcessor(element, project2, editor, xmlFile), this.getSelectNSActionTitle(), (IntentionAction)this, editor);
    }

    @Nullable
    public static String getUnboundNamespaceForPrefix(String prefix, XmlFile xmlFile, Set<String> namespaces) {
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)xmlFile);
        for (XmlSchemaProvider provider : providers) {
            for (String namespace : namespaces) {
                if (!prefix.equals(provider.getDefaultPrefix(namespace, xmlFile))) continue;
                return namespace;
            }
        }
        return null;
    }

    @NlsContexts.PopupTitle
    private String getSelectNSActionTitle() {
        return XmlPsiBundle.message((String)"xml.action.select.namespace.title", (Object[])new Object[]{StringUtil.capitalize((String)this.getXmlNamespaceHelper().getNamespaceAlias(this.getFile()))});
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(23);
        }
        XmlToken token = null;
        if (this.myToken != null && (token = (XmlToken)this.myToken.retrieve()) == null) {
            return false;
        }
        if (!XmlSettings.getInstance().SHOW_XML_ADD_IMPORT_HINTS || this.myNamespacePrefix.isEmpty()) {
            return false;
        }
        PsiElement element = this.myElement.retrieve();
        if (element == null) {
            return false;
        }
        List<String> namespaces = this.getNamespaces(element, this.getFile());
        if (!namespaces.isEmpty()) {
            String message = ShowAutoImportPass.getMessage((namespaces.size() > 1 ? 1 : 0) != 0, (String)XmlPsiBundle.message((String)"xml.terms.namespace.alias", (Object[])new Object[0]), (String)namespaces.iterator().next());
            String title = this.getSelectNSActionTitle();
            ImportNSAction action = new ImportNSAction(namespaces, this.getFile(), element, editor, title);
            if (element instanceof XmlTag && token != null) {
                if (editor.calculateVisibleRange().contains(token.getTextRange())) {
                    HintManager.getInstance().showQuestionHint(editor, message, token.getTextOffset(), token.getTextOffset() + this.myNamespacePrefix.length(), (QuestionAction)action);
                    return true;
                }
            } else {
                HintManager.getInstance().showQuestionHint(editor, message, element.getTextOffset(), element.getTextRange().getEndOffset(), (QuestionAction)action);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfGivenXmlHasTheseWords(String name, XmlFile tldFileByUri) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        List list2 = StringUtil.getWordsIn((String)name);
        final String[] words = ArrayUtilRt.toStringArray((Collection)list2);
        final boolean[] wordsFound = new boolean[words.length];
        final int[] wordsFoundCount = new int[1];
        IdTableBuilding.ScanWordProcessor wordProcessor = new IdTableBuilding.ScanWordProcessor(){

            public void run(CharSequence chars, char @Nullable [] charsArray, int start2, int end) {
                if (wordsFoundCount[0] == words.length) {
                    return;
                }
                int foundWordLen = end - start2;
                block0: for (int i = 0; i < words.length; ++i) {
                    String localName = words[i];
                    if (wordsFound[i] || localName.length() != foundWordLen) continue;
                    for (int j = 0; j < localName.length(); ++j) {
                        if (chars.charAt(start2 + j) != localName.charAt(j)) continue block0;
                    }
                    wordsFound[i] = true;
                    wordsFoundCount[0] = wordsFoundCount[0] + 1;
                    break;
                }
            }
        };
        CharSequence contents = tldFileByUri.getViewProvider().getContents();
        IdTableBuilding.scanWords((IdTableBuilding.ScanWordProcessor)wordProcessor, (CharSequence)contents, (int)0, (int)contents.length());
        return wordsFoundCount[0] == words.length;
    }

    public static void runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(String @NotNull [] namespacesToChooseFrom, Project project2, StringToAttributeProcessor onSelection, @NlsContexts.PopupTitle String title, IntentionAction requestor, Editor editor) throws IncorrectOperationException {
        if (namespacesToChooseFrom == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(24);
        }
        if (namespacesToChooseFrom.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            JBPopupFactory.getInstance().createPopupChooserBuilder(List.of(namespacesToChooseFrom)).setRenderer((ListCellRenderer)((Object)new XmlNSRenderer())).setTitle(title).setItemChosenCallback(selectedValue -> {
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease((String)selectedValue);
                    }
                    catch (IncorrectOperationException ex) {
                        throw new RuntimeException(ex);
                    }
                }), requestor.getText(), (Object)requestor.getFamilyName());
            }).createPopup().showInBestPositionFor(editor);
        } else {
            WriteAction.run(() -> {
                String attrName = namespacesToChooseFrom.length == 0 ? "" : namespacesToChooseFrom[0];
                onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(attrName);
            });
        }
    }

    public static void processExternalUris(MetaHandler metaHandler, PsiFile file, ExternalUriProcessor processor) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file, processor)), XmlPsiBundle.message((String)"xml.progress.finding.acceptable.uri", (Object[])new Object[0]), false, file.getProject());
    }

    private static void processExternalUrisImpl(MetaHandler metaHandler, PsiFile file, ExternalUriProcessor processor) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        String searchFor = metaHandler.searchFor();
        if (pi != null) {
            pi.setText(XmlPsiBundle.message((String)"xml.progress.looking.in.schemas", (Object[])new Object[0]));
            pi.setIndeterminate(false);
        }
        ExternalResourceManager instanceEx = ExternalResourceManager.getInstance();
        String[] availableUrls = instanceEx.getResourceUrls(null, true);
        int i = 0;
        for (String url : availableUrls) {
            String defaultNamespace;
            boolean wordFound;
            XmlFile xmlFile;
            if (pi != null) {
                pi.setFraction((double)i / (double)availableUrls.length);
                pi.setText2(url);
                ++i;
            }
            if ((xmlFile = XmlUtil.findNamespace(file, url)) == null || !(wordFound = CreateNSDeclarationIntentionFix.checkIfGivenXmlHasTheseWords(searchFor, xmlFile))) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            PsiMetaData metaData = document.getMetaData();
            if (!metaHandler.isAcceptableMetaData(metaData, url)) continue;
            XmlNSDescriptorImpl descriptor = metaData instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)metaData : null;
            String string = defaultNamespace = descriptor != null ? descriptor.getDefaultNamespace() : url;
            if ("http://www.w3.org/1999/XMLSchema".equals(defaultNamespace) || "http://www.w3.org/2000/10/XMLSchema".equals(defaultNamespace)) continue;
            processor.process(defaultNamespace, url);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 15, 18, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacesToChooseFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doPreview";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doPreview";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 15, 18, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }

    private class MyStringToAttributeProcessor
    implements StringToAttributeProcessor {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final Project myProject;
        @Nullable
        private final Editor myEditor;
        @NotNull
        private final XmlFile myXmlFile;

        private MyStringToAttributeProcessor(@NotNull PsiElement element, @Nullable Project project2, @NotNull Editor editor, XmlFile xmlFile) {
            if (element == null) {
                MyStringToAttributeProcessor.$$$reportNull$$$0(0);
            }
            if (project2 == null) {
                MyStringToAttributeProcessor.$$$reportNull$$$0(1);
            }
            if (xmlFile == null) {
                MyStringToAttributeProcessor.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myProject = project2;
            this.myEditor = editor;
            this.myXmlFile = xmlFile;
        }

        @Override
        public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NotNull String namespace) throws IncorrectOperationException {
            RangeMarker marker;
            String prefix;
            if (namespace == null) {
                MyStringToAttributeProcessor.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmpty((String)(prefix = CreateNSDeclarationIntentionFix.this.myNamespacePrefix))) {
                XmlFile xmlFile = XmlExtension.getExtension((PsiFile)this.myXmlFile).getContainingFile(this.myElement);
                prefix = ExtendedTagInsertHandler.getPrefixByNamespace(xmlFile, namespace);
                if (StringUtil.isNotEmpty((String)prefix)) {
                    ExtendedTagInsertHandler.qualifyWithPrefix(prefix, this.myElement);
                    return;
                }
                prefix = ExtendedTagInsertHandler.suggestPrefix(xmlFile, namespace);
                if (!StringUtil.isEmpty((String)prefix)) {
                    ExtendedTagInsertHandler.qualifyWithPrefix(prefix, this.myElement);
                    if (this.myEditor != null) {
                        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
                    }
                }
            }
            if (this.myEditor != null) {
                int offset = this.myEditor.getCaretModel().getOffset();
                marker = this.myEditor.getDocument().createRangeMarker(offset, offset);
            } else {
                marker = null;
            }
            XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper((PsiFile)this.myXmlFile);
            helper.insertNamespaceDeclaration(this.myXmlFile, this.myEditor, Collections.singleton(namespace), prefix, __ -> {
                if (this.myEditor != null && !namespace.isEmpty()) {
                    this.myEditor.getCaretModel().moveToOffset(marker.getStartOffset());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix$MyStringToAttributeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doSomethingWithGivenStringToProduceXmlAttributeNowPlease";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface StringToAttributeProcessor {
        public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NonNls @NotNull String var1) throws IncorrectOperationException;
    }

    public static interface MetaHandler {
        public boolean isAcceptableMetaData(PsiMetaData var1, String var2);

        public String searchFor();
    }

    public static interface ExternalUriProcessor {
        public void process(@NotNull String var1, @Nullable String var2);
    }

    public static class TagMetaHandler
    implements MetaHandler {
        private final String myName;

        public TagMetaHandler(String name) {
            this.myName = name;
        }

        @Override
        public boolean isAcceptableMetaData(PsiMetaData metaData, String url) {
            if (metaData instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
                XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(this.searchFor(), url);
                return descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor);
            }
            return false;
        }

        @Override
        public String searchFor() {
            return this.myName;
        }
    }
}

