/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitVcs;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/actions/GitUnshallowRepositoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.vcs.git"})
public final class GitUnshallowRepositoryAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACTION_ID = "Git.Unshallow";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        GitRepository gitRepository;
        Project project;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = project = e.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            gitRepository = (GitRepository)DvcsUtil.guessRepositoryForOperation((Project)it, (AbstractRepositoryManager)GitRepositoryManager.getInstance(it), (DataContext)e.getDataContext());
        } else {
            gitRepository = null;
        }
        GitRepository guessedRepo = gitRepository;
        e.getPresentation().setEnabledAndVisible(guessedRepo != null && guessedRepo.getInfo().isShallow());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        GitRepository gitRepository = (GitRepository)DvcsUtil.guessRepositoryForOperation((Project)project2, (AbstractRepositoryManager)GitRepositoryManager.getInstance(project2), (DataContext)e.getDataContext());
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"fetchSupport(...)");
        GitFetchSupport fetcher = gitFetchSupport;
        GitRemote gitRemote = fetcher.getDefaultRemoteToFetch(repository);
        if (gitRemote == null) {
            return;
        }
        GitRemote remote = gitRemote;
        String string = GitBundle.message("action.Git.Unshallow.progress.title", new Object[0]);
        GitVcs.runInBackground(new Task.Backgroundable(project2, fetcher, repository, remote, string){
            final /* synthetic */ GitFetchSupport $fetcher;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;
            {
                this.$fetcher = $fetcher;
                this.$repository = $repository;
                this.$remote = $remote;
                super($project, $super_call_param$1);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$fetcher.fetchUnshallow(this.$repository, this.$remote).showNotificationIfFailed(GitBundle.message("action.Git.Unshallow.failure.title", new Object[0]));
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/actions/GitUnshallowRepositoryAction$Companion;", "", "<init>", "()V", "ACTION_ID", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

