/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitChangeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitChangesParser {
    private static final Logger LOG = Logger.getInstance(GitChangesParser.class);

    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<VcsFileStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @Nullable String parentsHash) {
        if (project == null) {
            GitChangesParser.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitChangesParser.$$$reportNull$$$0(1);
        }
        if (statusInfos == null) {
            GitChangesParser.$$$reportNull$$$0(2);
        }
        if (hash == null) {
            GitChangesParser.$$$reportNull$$$0(3);
        }
        if (date == null) {
            GitChangesParser.$$$reportNull$$$0(4);
        }
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        GitRevisionNumber parentRevision = parentsHash == null ? null : new GitRevisionNumber(parentsHash);
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (VcsFileStatusInfo statusInfo : statusInfos) {
            result2.add(GitChangesParser.parseChange(project, root, (VcsRevisionNumber)thisRevision, (VcsRevisionNumber)parentRevision, statusInfo));
        }
        ArrayList<Change> arrayList = result2;
        if (arrayList == null) {
            GitChangesParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static Change parseChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VcsRevisionNumber thisRevision, @Nullable VcsRevisionNumber parentRevision, @NotNull VcsFileStatusInfo statusInfo) {
        FileStatus status;
        ContentRevision before;
        if (project == null) {
            GitChangesParser.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitChangesParser.$$$reportNull$$$0(7);
        }
        if (thisRevision == null) {
            GitChangesParser.$$$reportNull$$$0(8);
        }
        if (statusInfo == null) {
            GitChangesParser.$$$reportNull$$$0(9);
        }
        String path = statusInfo.getFirstPath();
        FilePath filePath = GitContentRevision.createPath(vcsRoot, path);
        return new Change(before, switch (statusInfo.getType()) {
            case Change.Type.NEW -> {
                before = null;
                status = FileStatus.ADDED;
                yield GitContentRevision.createRevision(filePath, thisRevision, project);
            }
            case Change.Type.MODIFICATION -> {
                status = FileStatus.MODIFIED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                yield GitContentRevision.createRevision(filePath, thisRevision, project);
            }
            case Change.Type.DELETED -> {
                status = FileStatus.DELETED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                yield null;
            }
            case Change.Type.MOVED -> {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = secondPath == null ? filePath : GitContentRevision.createPath(vcsRoot, secondPath);
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                yield GitContentRevision.createRevision(filePathAfterRename, thisRevision, project);
            }
            default -> throw new AssertionError((Object)("Unknown file status: " + statusInfo));
        }, status);
    }

    @NotNull
    static Change.Type getChangeType(@NotNull GitChangeType type) {
        if (type == null) {
            GitChangesParser.$$$reportNull$$$0(10);
        }
        Change.Type type2 = switch (type) {
            case GitChangeType.ADDED -> Change.Type.NEW;
            case GitChangeType.TYPE_CHANGED, GitChangeType.MODIFIED -> Change.Type.MODIFICATION;
            case GitChangeType.DELETED -> Change.Type.DELETED;
            case GitChangeType.COPIED, GitChangeType.RENAMED -> Change.Type.MOVED;
            default -> {
                LOG.error("Unknown git change type: " + type);
                yield Change.Type.MODIFICATION;
            }
        };
        if (type2 == null) {
            GitChangesParser.$$$reportNull$$$0(11);
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitChangesParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisRevision";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitChangesParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseChange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11 -> new IllegalStateException(string);
        };
    }
}

