/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a7\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\t"}, d2={"handleHttpDownloadExceptions", "T", "request", "", "url", "", "action", "Lkotlin/Function0;", "(Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.indexing.shared"})
public final class SharedIndexesNetworkKt {
    @Nullable
    public static final <T> T handleHttpDownloadExceptions(@NotNull Object request, @NotNull String url, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$handleHttpDownloadExceptions = false;
        try {
            return (T)action.invoke();
        }
        catch (ConnectException e) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot connect to the host for " + url + " for " + request + ". " + e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot resolve host for " + url + " for " + request + ". " + e.getMessage(), (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url + " for " + request + ". Error: " + e.getMessage() + ".", (Throwable)e);
            } else {
                SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url + " for " + request + ". Error: " + e.getMessage() + ".");
            }
        }
        catch (HttpRequests.HttpStatusException e) {
            if (e.getStatusCode() < 500) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No data available for " + url + " for " + request + ". " + e.getStatusCode(), (Throwable)e);
            } else {
                SharedIndexDownloadLoggerKt.getDownloadLogger().info("No data available for " + url + " for " + request + ". " + e.getStatusCode(), (Throwable)e);
            }
        }
        catch (IOException e) {
            if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                Serializable serializable;
                Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                String string = e.getMessage();
                if (string != null) {
                    serializable = (Serializable)((Object)string);
                } else {
                    Throwable throwable = e.getCause();
                    String string2 = throwable != null ? throwable.getMessage() : null;
                    serializable = string2 != null ? (Serializable)((Object)string2) : (Serializable)e.getClass();
                }
                logger.warn("Failed to download " + url + " for " + request + ". Error: " + serializable, (Throwable)e);
            } else {
                Serializable serializable;
                Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                String string = e.getMessage();
                if (string != null) {
                    serializable = (Serializable)((Object)string);
                } else {
                    Throwable throwable = e.getCause();
                    String string3 = throwable != null ? throwable.getMessage() : null;
                    serializable = string3 != null ? (Serializable)((Object)string3) : (Serializable)e.getClass();
                }
                logger.warn("Failed to download " + url + " for " + request + ". Error: " + serializable);
            }
        }
        catch (Throwable t) {
            Serializable serializable;
            if (t instanceof ControlFlowException) {
                throw t;
            }
            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
            Class<?> clazz = t.getClass();
            String string = t.getMessage();
            if (string != null) {
                serializable = (Serializable)((Object)string);
            } else {
                Throwable throwable = t.getCause();
                String string4 = throwable != null ? throwable.getMessage() : null;
                serializable = string4 != null ? (Serializable)((Object)string4) : (Serializable)t.getClass();
            }
            logger.warn("Failed to download " + url + " due " + clazz + " for " + request + ". Error: " + serializable);
        }
        return null;
    }
}

