/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.MissingResourceException;
import org.jetbrains.compose.resources.ResourceReader;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"getPlatformResourceReader", "Lorg/jetbrains/compose/resources/ResourceReader;", "library"})
public final class ResourceReader_desktopKt {
    @NotNull
    public static final ResourceReader getPlatformResourceReader() {
        return new ResourceReader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Object read(@NotNull String path, @NotNull Continuation<? super byte[]> $completion) {
                byte[] byArray;
                InputStream resource2 = this.getResourceAsStream(path);
                Closeable closeable = resource2;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes((InputStream)input);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return byArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Object readPart(@NotNull String path, long offset2, long size2, @NotNull Continuation<? super byte[]> $completion) {
                InputStream resource2 = this.getResourceAsStream(path);
                byte[] result2 = new byte[(int)size2];
                Closeable closeable = resource2;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    this.skipBytes(input, offset2);
                    int n = input.readNBytes(result2, 0, (int)size2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return result2;
            }

            private final void skipBytes(InputStream $this$skipBytes, long offset2) {
                long count;
                for (long skippedBytes = 0L; skippedBytes < offset2 && (count = $this$skipBytes.skip(offset2 - skippedBytes)) != 0L; skippedBytes += count) {
                }
            }

            @NotNull
            public String getUri(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                ClassLoader classLoader = this.getClassLoader();
                URL uRL = classLoader.getResource(path);
                if (uRL == null) {
                    throw new MissingResourceException(path);
                }
                URL resource2 = uRL;
                String string2 = resource2.toURI().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return string2;
            }

            private final InputStream getResourceAsStream(String path) {
                ClassLoader classLoader = this.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(path);
                if (inputStream == null) {
                    throw new MissingResourceException(path);
                }
                return inputStream;
            }

            private final ClassLoader getClassLoader() {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    throw new IllegalStateException("Cannot find class loader".toString());
                }
                return classLoader;
            }
        };
    }
}

