/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCellState;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import com.intellij.vcs.log.ui.render.TooltipReferencesPanel;
import com.intellij.vcs.log.ui.render.TypeSafeTableCellRenderer;
import com.intellij.vcs.log.ui.render.VcsLogLabelPainter;
import com.intellij.vcs.log.ui.table.GraphCommitCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.ui.table.links.VcsLinksRenderer;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterWithMatches;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GraphCommitCellRenderer
extends TypeSafeTableCellRenderer<GraphCommitCell>
implements VcsLogCellRenderer {
    private static final int MAX_GRAPH_WIDTH = 6;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final MyComponent myComponent;
    @NotNull
    private final MyComponent myTemplateComponent;

    public GraphCommitCellRenderer(@NotNull VcsLogData logData, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table) {
        if (logData == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(0);
        }
        if (painter == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(1);
        }
        if (table == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(2);
        }
        this.myLogData = logData;
        this.myGraphTable = table;
        LabelIconCache iconCache = new LabelIconCache();
        this.myComponent = new MyComponent(logData, painter, table, iconCache);
        this.myTemplateComponent = new MyComponent(logData, painter, table, iconCache);
    }

    protected SimpleColoredComponent getTableCellRendererComponentImpl(@NotNull JTable table, @NotNull GraphCommitCell value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(3);
        }
        if (value == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(4);
        }
        this.myComponent.customize(value, isSelected, hasFocus, row, column);
        return this.myComponent;
    }

    @Nullable
    private JComponent getTooltip(@NotNull Object value, @NotNull Point point, int row) {
        double distance;
        if (value == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(5);
        }
        if (point == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(6);
        }
        GraphCommitCell cell = (GraphCommitCell)this.getValue(value);
        Collection<VcsRef> refs = cell.getRefsToThisCommit();
        Collection<VcsBookmarkRef> bookmarks = cell.getBookmarksToThisCommit();
        if (refs.isEmpty() && bookmarks.isEmpty()) {
            return null;
        }
        this.prepareTemplateComponent(row, cell);
        if (this.myTemplateComponent.getReferencePainter().isLeftAligned() ? (distance = point.getX() - (double)this.myTemplateComponent.getGraphWidth()) > 0.0 && distance <= (double)this.myTemplateComponent.getReferencesWidth() : (double)this.getColumnWidth() - point.getX() <= (double)this.myTemplateComponent.getReferencesWidth()) {
            return new TooltipReferencesPanel(this.myLogData, refs, bookmarks);
        }
        return null;
    }

    private int getTooltipXCoordinate(int row) {
        GraphCommitCell cell = (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row, Commit.INSTANCE));
        if (cell.getRefsToThisCommit().isEmpty() && cell.getBookmarksToThisCommit().isEmpty()) {
            return this.getColumnWidth() / 2;
        }
        this.prepareTemplateComponent(row, cell);
        int referencesWidth = this.myTemplateComponent.getReferencesWidth();
        if (this.myTemplateComponent.getReferencePainter().isLeftAligned()) {
            return this.myTemplateComponent.getGraphWidth() + referencesWidth / 2;
        }
        return this.getColumnWidth() - referencesWidth / 2;
    }

    private void prepareTemplateComponent(int row, @NotNull GraphCommitCell cell) {
        if (cell == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(7);
        }
        this.myTemplateComponent.customize(cell, this.myGraphTable.isRowSelected(row), this.myGraphTable.hasFocus(), row, VcsLogColumnManager.getInstance().getModelIndex(Commit.INSTANCE));
    }

    private int getColumnWidth() {
        return this.myGraphTable.getCommitColumn().getWidth();
    }

    public int getPreferredHeight() {
        return this.myComponent.getPreferredHeight();
    }

    public void setCompactReferencesView(boolean compact) {
        this.myComponent.getReferencePainter().setCompact(compact);
        this.myTemplateComponent.getReferencePainter().setCompact(compact);
    }

    public void setShowTagsNames(boolean showTagNames) {
        this.myComponent.getReferencePainter().setShowTagNames(showTagNames);
        this.myTemplateComponent.getReferencePainter().setShowTagNames(showTagNames);
    }

    public void setLeftAligned(boolean leftAligned) {
        this.myComponent.getReferencePainter().setLeftAligned(leftAligned);
        this.myTemplateComponent.getReferencePainter().setLeftAligned(leftAligned);
    }

    @Override
    @NotNull
    public VcsLogCellController getCellController() {
        return new GraphCommitCellController(this.myLogData, this.myGraphTable, this.myComponent.myPainter){

            @Override
            protected int getTooltipXCoordinate(int row) {
                return GraphCommitCellRenderer.this.getTooltipXCoordinate(row);
            }

            @Override
            @Nullable
            protected JComponent getTooltip(@NotNull Object value, @NotNull Point point, int row) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (point == null) {
                    1.$$$reportNull$$$0(1);
                }
                return GraphCommitCellRenderer.this.getTooltip(value, point, row);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "point";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$1";
                objectArray[2] = "getTooltip";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static Font getLabelFont() {
        return StartupUiUtil.getLabelFont();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableCellRendererComponentImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTemplateComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyComponent
    extends SimpleColoredRenderer {
        private static final int DISPLAYED_MESSAGE_PART = 80;
        @NotNull
        private final VcsLogGraphTable myGraphTable;
        @NotNull
        private final GraphCellPainter myPainter;
        @NotNull
        private final IssueLinkRenderer myIssueLinkRenderer;
        @NotNull
        private final VcsLinksRenderer myVcsLinksRenderer;
        @NotNull
        private final VcsLogLabelPainter myReferencePainter;
        @NotNull
        private Collection<? extends PrintElement> myPrintElements;
        @NotNull
        private Font myFont;
        private int myHeight;
        private int myGraphWidth;
        private AffineTransform myAffineTransform;

        MyComponent(@NotNull VcsLogData data, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, @NotNull LabelIconCache iconCache) {
            if (data == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            if (painter == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            if (table == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            if (iconCache == null) {
                MyComponent.$$$reportNull$$$0(3);
            }
            this.myPrintElements = Collections.emptyList();
            this.myGraphWidth = 0;
            this.myPainter = painter;
            this.myGraphTable = table;
            this.myReferencePainter = new VcsLogLabelPainter(data, (JComponent)((Object)table), iconCache);
            this.myVcsLinksRenderer = new VcsLinksRenderer(data.getProject(), (SimpleColoredComponent)this);
            this.myIssueLinkRenderer = new IssueLinkRenderer(data.getProject(), (SimpleColoredComponent)this);
            this.setCellState(new VcsLogTableCellState());
            this.myFont = GraphCommitCellRenderer.getLabelFont();
            GraphicsConfiguration configuration = this.myGraphTable.getGraphicsConfiguration();
            this.myAffineTransform = configuration != null ? configuration.getDefaultTransform() : null;
            this.myHeight = this.calculateHeight();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int referencesSize = this.myReferencePainter.isLeftAligned() ? 0 : this.myReferencePainter.getSize().width;
            return new Dimension(preferredSize.width + referencesSize, this.getPreferredHeight());
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (!this.myReferencePainter.isLeftAligned()) {
                int start2 = Math.max(this.myGraphWidth, this.getWidth() - this.myReferencePainter.getSize().width);
                this.myReferencePainter.paint(g2d, start2, 0, this.getHeight());
            } else {
                this.myReferencePainter.paint(g2d, this.myGraphWidth, 0, this.getHeight());
            }
            this.myPainter.paint(g2d, this.myPrintElements);
        }

        public void customize(@NotNull GraphCommitCell cell, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean renderLinks;
            if (cell == null) {
                MyComponent.$$$reportNull$$$0(4);
            }
            this.clear();
            this.setPaintFocusBorder(false);
            this.acquireState((JTable)((Object)this.myGraphTable), isSelected, hasFocus, row, column);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.myPrintElements = cell.getPrintElements();
            this.myGraphWidth = MyComponent.getGraphWidth(this.myGraphTable, this.myPrintElements);
            SimpleTextAttributes style = this.myGraphTable.applyHighlighters((Component)((Object)this), row, column, hasFocus, isSelected);
            Collection<VcsRef> refs = cell.getRefsToThisCommit();
            Collection<VcsBookmarkRef> bookmarks = cell.getBookmarksToThisCommit();
            Object labelForeground = ExperimentalUI.isNewUI() ? JBColor.namedColor((String)"VersionControl.Log.Commit.Reference.foreground", (Color)CurrentBranchComponent.TEXT_COLOR) : (isSelected ? Objects.requireNonNull(this.myGraphTable.getBaseStyle(row, column, hasFocus, isSelected).getForeground()) : CurrentBranchComponent.TEXT_COLOR);
            this.append("");
            boolean bl = renderLinks = !cell.isLoading();
            if (this.myReferencePainter.isLeftAligned()) {
                this.myReferencePainter.customizePainter(refs, bookmarks, this.getBackground(), (Color)labelForeground, isSelected, this.getAvailableWidth(column, this.myGraphWidth));
                int referencesWidth = this.myReferencePainter.getSize().width;
                if (referencesWidth > 0) {
                    referencesWidth += LabelPainter.RIGHT_PADDING.get();
                }
                this.appendTextPadding(this.myGraphWidth + referencesWidth);
                this.appendText(cell, style, isSelected, renderLinks);
            } else {
                this.appendTextPadding(this.myGraphWidth);
                this.appendText(cell, style, isSelected, renderLinks);
                this.myReferencePainter.customizePainter(refs, bookmarks, this.getBackground(), (Color)labelForeground, isSelected, this.getAvailableWidth(column, this.myGraphWidth));
            }
        }

        private void appendText(@NotNull GraphCommitCell cell, @NotNull SimpleTextAttributes style, boolean isSelected, boolean renderLinks) {
            VcsLogTextFilter textFilter;
            if (cell == null) {
                MyComponent.$$$reportNull$$$0(5);
            }
            if (style == null) {
                MyComponent.$$$reportNull$$$0(6);
            }
            String cellText = StringUtil.replace((String)cell.getText(), (String)"\t", (String)" ").trim();
            CommitId commitId = cell.getCommitId();
            if (renderLinks) {
                if (VcsLinksRenderer.isEnabled()) {
                    this.myVcsLinksRenderer.appendTextWithLinks(cellText, style, commitId);
                } else {
                    this.myIssueLinkRenderer.appendTextWithLinks(cellText, style);
                }
            } else {
                this.append(cellText, style);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)this.myGraphTable), (SimpleColoredComponent)this, (boolean)false, (boolean)isSelected);
            if (Registry.is((String)"vcs.log.filter.text.highlight.matches") && (textFilter = (VcsLogTextFilter)this.myGraphTable.getModel().getVisiblePack().getFilters().get(VcsLogFilterCollection.TEXT_FILTER)) instanceof VcsLogTextFilterWithMatches) {
                VcsLogTextFilterWithMatches textFilterWithMatches = (VcsLogTextFilterWithMatches)textFilter;
                String text = this.getCharSequence(false).toString();
                SpeedSearchUtil.applySpeedSearchHighlighting((SimpleColoredComponent)this, textFilterWithMatches.matchingRanges(text), (boolean)isSelected);
            }
        }

        private int getAvailableWidth(int column, int graphWidth) {
            int textAndLabelsWidth = this.myGraphTable.getColumnModel().getColumn(column).getWidth() - graphWidth;
            int freeSpace = textAndLabelsWidth - super.getPreferredSize().width;
            int allowedSpace = this.myReferencePainter.isCompact() ? Math.min(freeSpace, textAndLabelsWidth / 3) : Math.max(freeSpace, Math.max(textAndLabelsWidth / 2, textAndLabelsWidth - JBUIScale.scale((int)80)));
            return Math.max(0, allowedSpace);
        }

        private int calculateHeight() {
            int rowContentHeight = this.calculateRowContentHeight();
            return ExperimentalUI.isNewUI() ? Math.max(rowContentHeight, JBUI.CurrentTheme.VersionControl.Log.rowHeight()) : rowContentHeight;
        }

        private int calculateRowContentHeight() {
            return Math.max(this.myReferencePainter.getSize().height, this.getFontMetrics(this.myFont).getHeight() + JBUI.scale((int)JBUI.CurrentTheme.VersionControl.Log.verticalPadding()));
        }

        public int getPreferredHeight() {
            Font font = GraphCommitCellRenderer.getLabelFont();
            GraphicsConfiguration configuration = this.myGraphTable.getGraphicsConfiguration();
            if (this.myFont != font || configuration != null && !Objects.equals(this.myAffineTransform, configuration.getDefaultTransform())) {
                this.myFont = font;
                this.myAffineTransform = configuration != null ? configuration.getDefaultTransform() : null;
                this.myHeight = this.calculateHeight();
            }
            return this.myHeight;
        }

        @NotNull
        public VcsLogLabelPainter getReferencePainter() {
            VcsLogLabelPainter vcsLogLabelPainter = this.myReferencePainter;
            if (vcsLogLabelPainter == null) {
                MyComponent.$$$reportNull$$$0(7);
            }
            return vcsLogLabelPainter;
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.myGraphTable.getFontMetrics(font);
        }

        private int getGraphWidth() {
            return this.myGraphWidth;
        }

        private int getReferencesWidth() {
            return this.myReferencePainter.getSize().width;
        }

        private static int getGraphWidth(@NotNull VcsLogGraphTable table, @NotNull Collection<? extends PrintElement> printElements) {
            if (table == null) {
                MyComponent.$$$reportNull$$$0(8);
            }
            if (printElements == null) {
                MyComponent.$$$reportNull$$$0(9);
            }
            if (printElements.isEmpty()) {
                return 0;
            }
            double maxIndex = 0.0;
            for (PrintElement printElement : printElements) {
                maxIndex = Math.max(maxIndex, (double)printElement.getPositionInCurrentRow());
                if (!(printElement instanceof EdgePrintElement)) continue;
                maxIndex = Math.max(maxIndex, (double)(printElement.getPositionInCurrentRow() + ((EdgePrintElement)printElement).getPositionInOtherRow()) / 2.0);
            }
            maxIndex += 1.0;
            maxIndex = Math.max(maxIndex, (double)Math.min(6, table.getVisibleGraph().getRecommendedWidth()));
            return (int)(maxIndex * PaintParameters.getElementWidth(table.getRowHeight()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "painter";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconCache";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cell";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencePainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "customize";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getGraphWidth";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }

    public static class VcsLogTableCellState
    extends TableCellState {
        @Nullable
        protected Border getBorder(boolean isSelected, boolean hasFocus) {
            return null;
        }

        @NotNull
        protected Color getSelectionForeground(JTable table, boolean isSelected) {
            if (!isSelected) {
                Color color = super.getSelectionForeground(table, isSelected);
                if (color == null) {
                    VcsLogTableCellState.$$$reportNull$$$0(0);
                }
                return color;
            }
            Color color = VcsLogGraphTable.getSelectionForeground(RenderingUtil.isFocused((JComponent)table));
            if (color == null) {
                VcsLogTableCellState.$$$reportNull$$$0(1);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$VcsLogTableCellState", "getSelectionForeground"));
        }
    }
}

