/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.ScrollPanel;

public class PrintDNAImage
extends ScrollPanel {
    private PageFormat format = null;
    private int pageIndex = 0;
    private DNADraw dna;
    private JTextField statusField = new JTextField("");
    private int nResPerLine = 0;
    private Hashtable lineAttr;
    private String type;

    public PrintDNAImage(DNADraw dNADraw) {
        this.dna = dNADraw;
        this.lineAttr = dNADraw.getLineAttributes();
        this.setBackground(Color.white);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.dna.drawAll(graphics2D, true);
    }

    public void print() {
        if (this.format == null) {
            this.getFormatDialog();
        }
        try {
            File file = this.showOptions();
            if (file == null) {
                return;
            }
            RenderedImage renderedImage = this.createDNAImage(0);
            this.writeImageToFile(renderedImage, file, this.type);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This option requires Java 1.4 or higher.");
        }
    }

    protected PageFormat getFormatDialog() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.format = new PageFormat();
        this.format = printerJob.pageDialog(this.format);
        return this.format;
    }

    private RenderedImage createDNAImage(int n) {
        int n2 = (int)this.format.getWidth();
        int n3 = (int)this.format.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n2, n3);
        this.dna.drawAll(graphics2D, true);
        return bufferedImage;
    }

    protected void printPreview() {
        Border border = BorderFactory.createLoweredBevelBorder();
        Border border2 = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.statusField.setBorder(compoundBorder);
        this.statusField.setEditable(false);
        if (this.format == null) {
            this.format = this.getFormatDialog();
        }
        this.statusField.setText("DNA map");
        final JFrame jFrame = new JFrame("Print Preview");
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.statusField, "South");
        Dimension dimension = new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
        this.setPreferredSize(dimension);
        jFrame.setSize(dimension);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Print");
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("Print Postscript...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintDNAImage.this.dna.doPrintActions();
            }
        });
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Print png/jpeg Image...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintDNAImage.this.print();
            }
        });
        jMenu2.add(jMenuItem2);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem3 = new JMenuItem("Close");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu.add(jMenuItem3);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setVisible(true);
    }

    private File showOptions() {
        String string = System.getProperty("user.dir");
        JFileChooser jFileChooser = new JFileChooser(string);
        File file = new File(string + System.getProperty("file.separator") + "dna_image.jpeg");
        jFileChooser.setSelectedFile(file);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        JLabel jLabel = new JLabel("Select Format:");
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(1));
        box.add(jLabel);
        Box box2 = Box.createHorizontalBox();
        JComboBox<String> jComboBox = new JComboBox<String>(ImageIO.getWriterFormatNames());
        Dimension dimension = jComboBox.getPreferredSize();
        jComboBox.setMaximumSize(dimension);
        box2.add(Box.createHorizontalGlue());
        box2.add(jComboBox);
        box.add(box2);
        jFileChooser.setAccessory(box);
        int n = jFileChooser.showSaveDialog(null);
        if (n == 1) {
            return null;
        }
        this.type = (String)jComboBox.getSelectedItem();
        return jFileChooser.getSelectedFile();
    }

    private void writeImageToFile(RenderedImage renderedImage, File file, String string) {
        try {
            ImageIO.write(renderedImage, string, file);
        }
        catch (IOException iOException) {
            System.out.println("Java 1.4+ is required");
        }
    }
}

