/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.detachable.ArrayReference;
import org.eclipse.xtext.nodemodel.detachable.DetachableParseResult;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.NodeModelData;
import org.eclipse.xtext.nodemodel.detachable.StandardNodeModelReference;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.NodeModelInput;
import org.eclipse.xtext.nodemodel.impl.RootNode;

public class DetachedNodeModelReader
extends BinaryResourceImpl.EObjectInputStream
implements NodeModelInput {
    private final List<ArrayReference> grammarElementArrays;
    private final List<EObject> semanticObjects;
    private final List<SyntaxErrorMessage> syntaxErrorMessages;
    private GrammarElementLookup grammarElements;
    private int offset;
    private Tabulated<INode> externalReferences;
    private Map<EObject, CompositeNodeWithSemanticElement> associations;

    public DetachedNodeModelReader(NodeModelData nodeModelData) throws IOException {
        super((InputStream)new GZIPInputStream(new ByteArrayInputStream(nodeModelData.getBytes())), Collections.singletonMap("INTERNAL_BUFFER_CAPACITY", 8192));
        this.syntaxErrorMessages = nodeModelData.getSyntaxErrors();
        this.grammarElementArrays = nodeModelData.getGrammarElementArrays();
        this.semanticObjects = nodeModelData.getSemanticObjects();
    }

    public StandardNodeModelReference deserialize(DetachableParseResult target) throws IOException {
        this.externalReferences = new Tabulated(this.readCompressedInt());
        this.associations = new HashMap<EObject, CompositeNodeWithSemanticElement>();
        this.grammarElements = target.getGrammarElementLookup();
        RootNode rootNode = (RootNode)this.readNode();
        return new StandardNodeModelReference(target, rootNode, this.associations, this.externalReferences);
    }

    @Override
    public AbstractNode readNode(int type) throws IOException {
        if (type == -1) {
            return null;
        }
        boolean hasExternalId = (type & 1) == 1;
        AbstractNode result = NodeModelInput.super.readNode(type >>> 1);
        if (hasExternalId) {
            this.externalReferences.set(result, this.readCompressedInt());
        }
        if (result instanceof CompositeNodeWithSemanticElement && result.hasDirectSemanticElement()) {
            this.associations.put(result.getSemanticElement(), (CompositeNodeWithSemanticElement)result);
        }
        return result;
    }

    protected void readSignature() throws IOException {
    }

    @Override
    public int readLength() throws IOException {
        int result = this.readCompressedInt();
        this.offset += result;
        return result;
    }

    @Override
    public int currentOffset() {
        return this.offset;
    }

    @Override
    public Object readGrammarElement() throws IOException {
        int id = this.readCompressedInt();
        if (id == -1) {
            return null;
        }
        if (id >= this.grammarElements.size()) {
            return this.grammarElementArrays.get(id - this.grammarElements.size()).getArray();
        }
        return this.grammarElements.getGrammarElement(id);
    }

    @Override
    public EObject readSemanticObject() throws IOException {
        int id = this.readCompressedInt();
        if (id == -1) {
            return null;
        }
        return this.semanticObjects.get(id);
    }

    @Override
    public SyntaxErrorMessage readSyntaxErrorMessage() throws IOException {
        int id = this.readCompressedInt();
        if (id == -1) {
            return null;
        }
        return this.syntaxErrorMessages.get(id);
    }

    @Override
    public String readContent() throws IOException {
        return this.readSegmentedString();
    }
}

