/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.util.Message;

public class ResolveData {
    private ResolveEngine engine;
    private Map visitData;
    private ConfigurationResolveReport report;
    private ResolveOptions options;
    private VisitNode currentVisitNode = null;
    private ResolvedModuleRevision currentResolvedModuleRevision;

    public ResolveData(ResolveData resolveData, boolean bl) {
        this(resolveData.engine, new ResolveOptions(resolveData.options).setValidate(bl), resolveData.report, resolveData.visitData);
        this.setCurrentVisitNode(resolveData.currentVisitNode);
        this.setCurrentResolvedModuleRevision(resolveData.currentResolvedModuleRevision);
    }

    public ResolveData(ResolveEngine resolveEngine, ResolveOptions resolveOptions) {
        this(resolveEngine, resolveOptions, null, new LinkedHashMap());
    }

    public ResolveData(ResolveEngine resolveEngine, ResolveOptions resolveOptions, ConfigurationResolveReport configurationResolveReport, Map map) {
        this.engine = resolveEngine;
        this.report = configurationResolveReport;
        this.visitData = map;
        this.options = resolveOptions;
    }

    public ConfigurationResolveReport getReport() {
        return this.report;
    }

    public IvyNode getNode(ModuleRevisionId object) {
        if ((object = this.getVisitData((ModuleRevisionId)object)) == null) {
            return null;
        }
        return ((VisitData)object).getNode();
    }

    public Collection getNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (VisitData visitData : this.visitData.values()) {
            arrayList.add(visitData.getNode());
        }
        return arrayList;
    }

    public Collection getNodeIds() {
        return this.visitData.keySet();
    }

    public VisitData getVisitData(ModuleRevisionId moduleRevisionId) {
        VisitData visitData = (VisitData)this.visitData.get(moduleRevisionId);
        if (visitData == null) {
            for (Map.Entry entry : this.visitData.entrySet()) {
                ModuleRevisionId moduleRevisionId2 = (ModuleRevisionId)entry.getKey();
                if (!ResolveData.isSubMap(moduleRevisionId.getAttributes(), moduleRevisionId2.getAttributes())) continue;
                visitData = (VisitData)entry.getValue();
                break;
            }
        }
        return visitData;
    }

    private static boolean isSubMap(Map map, Map object) {
        int v;
        int n2 = map.size();
        if (n2 == (v = object.size())) {
            return map.equals(object);
        }
        Object object2 = n2 < v ? map : object;
        map = n2 < v ? object : map;
        for (Map.Entry entry : object2.entrySet()) {
            Object v2;
            if (!map.containsKey(entry.getKey())) {
                return false;
            }
            Object v3 = object2.get(entry.getKey());
            if (ResolveData.isEqual(v3, v2 = map.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return object == null;
        }
        return object.equals(object2);
    }

    public VisitNode getCurrentVisitNode() {
        return this.currentVisitNode;
    }

    void setCurrentVisitNode(VisitNode visitNode) {
        this.currentVisitNode = visitNode;
    }

    public void register(VisitNode visitNode) {
        this.register(visitNode.getId(), visitNode);
    }

    public void register(ModuleRevisionId moduleRevisionId, VisitNode visitNode) {
        VisitData visitData = this.getVisitData(moduleRevisionId);
        if (visitData == null) {
            visitData = new VisitData(visitNode.getNode());
            visitData.addVisitNode(visitNode);
            this.visitData.put(moduleRevisionId, visitData);
            return;
        }
        visitData.setNode(visitNode.getNode());
        visitData.addVisitNode(visitNode);
    }

    void replaceNode(ModuleRevisionId moduleRevisionId, IvyNode ivyNode, String string) {
        VisitData visitData = this.getVisitData(moduleRevisionId);
        if (visitData == null) {
            throw new IllegalArgumentException("impossible to replace node for id " + moduleRevisionId + ". No registered node found.");
        }
        VisitData visitData2 = this.getVisitData(ivyNode.getId());
        if (visitData2 == null) {
            throw new IllegalArgumentException("impossible to replace node with " + ivyNode + ". No registered node found for " + ivyNode.getId() + ".");
        }
        this.visitData.put(moduleRevisionId, visitData2);
        visitData2.addVisitNodes(string, visitData.getVisitNodes(string));
        this.report.updateDependency(moduleRevisionId, ivyNode);
    }

    public void setReport(ConfigurationResolveReport configurationResolveReport) {
        this.report = configurationResolveReport;
    }

    public Date getDate() {
        return this.options.getDate();
    }

    public boolean isValidate() {
        return this.options.isValidate();
    }

    public boolean isTransitive() {
        return this.options.isTransitive();
    }

    public ResolveOptions getOptions() {
        return this.options;
    }

    public ResolveEngineSettings getSettings() {
        return this.engine.getSettings();
    }

    public EventManager getEventManager() {
        return this.engine.getEventManager();
    }

    public ResolveEngine getEngine() {
        return this.engine;
    }

    void blacklist(IvyNode ivyNode) {
        Iterator iterator = this.visitData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            VisitData visitData = (VisitData)entry.getValue();
            if (visitData.getNode() != ivyNode || ivyNode.getResolvedId().equals(entry.getKey())) continue;
            iterator.remove();
        }
    }

    public boolean isBlacklisted(String string, ModuleRevisionId object) {
        return (object = this.getNode((ModuleRevisionId)object)) != null && ((IvyNode)object).isBlacklisted(string);
    }

    public DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor) {
        DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
        dependencyDescriptor = this.getEngine().mediate(dependencyDescriptor, this.getOptions());
        Object object = this.getCurrentVisitNode();
        if (object != null) {
            object = new ArrayList(((VisitNode)object).getPath());
            object.remove(object.size() - 1);
            Collections.reverse(object);
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (VisitNode)object.next();
                if ((object2 = ((VisitNode)object2).getDescriptor()) == null) continue;
                dependencyDescriptor = object2.mediate(dependencyDescriptor);
            }
        }
        if (dependencyDescriptor2 != dependencyDescriptor) {
            Message.verbose("dependency descriptor has been mediated: " + dependencyDescriptor2 + " => " + dependencyDescriptor);
        }
        return dependencyDescriptor;
    }

    public void setCurrentResolvedModuleRevision(ResolvedModuleRevision resolvedModuleRevision) {
        this.currentResolvedModuleRevision = resolvedModuleRevision;
    }

    public ResolvedModuleRevision getCurrentResolvedModuleRevision() {
        return this.currentResolvedModuleRevision;
    }
}

