/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.firebase.auth.UserIdentifier;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.GetAccountInfoRequest;
import com.google.firebase.internal.NonNull;

public final class UidIdentifier
extends UserIdentifier {
    private final String uid;

    public UidIdentifier(@NonNull String uid) {
        UserRecord.checkUid(uid);
        this.uid = uid;
    }

    @Override
    public String toString() {
        return "UidIdentifier(" + this.uid + ")";
    }

    @Override
    void populate(@NonNull GetAccountInfoRequest payload) {
        payload.addUid(this.uid);
    }

    @Override
    boolean matches(@NonNull UserRecord userRecord) {
        return this.uid.equals(userRecord.getUid());
    }
}

