/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class MobilogixProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("[").number("(dddd)-(dd)-(dd) ").number("(dd):(dd):(dd),").number("Td+,").number("(d),").expression("[^,]+,").expression("([^,]+),").number("(xx),").number("(d+.d+)").groupBegin().text(",").number("(d)").number("(d)").number("(d),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+.?d*)").groupEnd("?").any().compile();

    public MobilogixProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String type) {
        return switch (type) {
            case "T8" -> "lowBattery";
            case "T9" -> "vibration";
            case "T10" -> "powerCut";
            case "T11" -> "lowPower";
            case "T12" -> "geofenceExit";
            case "T13" -> "overspeed";
            case "T15" -> "tow";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        Parser parser;
        String sentence = ((String)msg).trim();
        String type = sentence.substring(21, sentence.indexOf(44, 21));
        if (channel != null) {
            String time = sentence.substring(1, 20);
            String response = type.equals("T1") ? String.format("[%s,S1,1]", time) : String.format("[%s,S%s]", time, type.substring(1));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, sentence)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceTime(parser.nextDateTime());
        if (parser.nextInt() == 0) {
            position.set("archive", true);
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next())) == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", type);
        position.addAlarm(this.decodeAlarm(type));
        int status = parser.nextHexInt();
        position.set("ignition", BitUtil.check(status, 2));
        position.set("motion", BitUtil.check(status, 3));
        position.set("status", status);
        position.set("battery", parser.nextDouble());
        if (parser.hasNext(7)) {
            position.set("sat", parser.nextInt());
            position.set("rssi", 6 * parser.nextInt() - 111);
            position.setValid(parser.nextInt() > 0);
            position.setFixTime(position.getDeviceTime());
            position.setLatitude(parser.nextDouble());
            position.setLongitude(parser.nextDouble());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
            position.setCourse(parser.nextDouble());
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        return position;
    }
}

