/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.model.DataByFeatureId;

public class FeatureData
extends DataByFeatureId {
    public static final String FEATURE_NAME_FIELD = "feature_name";
    private final String featureName;

    public FeatureData(String featureId, String featureName, Double data) {
        super(featureId, data);
        this.featureName = featureName;
    }

    public FeatureData(StreamInput input) throws IOException {
        this.featureId = input.readString();
        this.featureName = input.readString();
        this.data = input.readDouble();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field("feature_id", this.featureId).field(FEATURE_NAME_FIELD, this.featureName).field("data", this.data);
        return xContentBuilder.endObject();
    }

    public static FeatureData parse(XContentParser parser) throws IOException {
        String featureId = null;
        Double data = null;
        String parsedFeatureName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "feature_id": {
                    featureId = parser.text();
                    break;
                }
                case "feature_name": {
                    parsedFeatureName = parser.text();
                    break;
                }
                case "data": {
                    data = parser.doubleValue();
                    break;
                }
            }
        }
        return new FeatureData(featureId, parsedFeatureName, data);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (super.equals(o)) {
            FeatureData that = (FeatureData)o;
            return Objects.equal((Object)this.featureName, (Object)that.featureName);
        }
        return false;
    }

    @Override
    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.featureName});
    }

    @Generated
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureId);
        out.writeString(this.featureName);
        out.writeDouble(this.data.doubleValue());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("featureId", (Object)this.featureId).append("featureName", (Object)this.featureName).append("data", (Object)this.data).toString();
    }
}

