/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;

@InputDataSet(value=MLInputDataType.QUESTION_ANSWERING)
public class QuestionAnsweringInputDataSet
extends MLInputDataset {
    private final String question;
    private final String context;

    public QuestionAnsweringInputDataSet(String question, String context) {
        super(MLInputDataType.QUESTION_ANSWERING);
        if (question == null) {
            throw new IllegalArgumentException("Question is not provided");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context is not provided");
        }
        this.question = question;
        this.context = context;
    }

    public QuestionAnsweringInputDataSet(StreamInput in) throws IOException {
        super(MLInputDataType.QUESTION_ANSWERING);
        this.question = in.readString();
        this.context = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.question);
        out.writeString(this.context);
    }

    @Generated
    public static QuestionAnsweringInputDataSetBuilder builder() {
        return new QuestionAnsweringInputDataSetBuilder();
    }

    @Generated
    public QuestionAnsweringInputDataSetBuilder toBuilder() {
        return new QuestionAnsweringInputDataSetBuilder().question(this.question).context(this.context);
    }

    @Generated
    public String getQuestion() {
        return this.question;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public static class QuestionAnsweringInputDataSetBuilder {
        @Generated
        private String question;
        @Generated
        private String context;

        @Generated
        QuestionAnsweringInputDataSetBuilder() {
        }

        @Generated
        public QuestionAnsweringInputDataSetBuilder question(String question) {
            this.question = question;
            return this;
        }

        @Generated
        public QuestionAnsweringInputDataSetBuilder context(String context) {
            this.context = context;
            return this;
        }

        @Generated
        public QuestionAnsweringInputDataSet build() {
            return new QuestionAnsweringInputDataSet(this.question, this.context);
        }

        @Generated
        public String toString() {
            return "QuestionAnsweringInputDataSet.QuestionAnsweringInputDataSetBuilder(question=" + this.question + ", context=" + this.context + ")";
        }
    }
}

