/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.features;

import ciir.umass.edu.features.Normalizer;
import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.learning.RankList;
import java.util.Arrays;

public class SumNormalizor
extends Normalizer {
    @Override
    public void normalize(RankList rl) {
        int j;
        DataPoint dp;
        int i;
        if (rl.size() == 0) {
            System.out.println("Error in SumNormalizor::normalize(): The input ranked list is empty");
            System.exit(1);
        }
        int nFeature = DataPoint.getFeatureCount();
        double[] norm = new double[nFeature];
        Arrays.fill(norm, 0.0);
        for (i = 0; i < rl.size(); ++i) {
            dp = rl.get(i);
            for (j = 1; j <= nFeature; ++j) {
                int n = j - 1;
                norm[n] = norm[n] + (double)Math.abs(dp.getFeatureValue(j));
            }
        }
        for (i = 0; i < rl.size(); ++i) {
            dp = rl.get(i);
            for (j = 1; j <= nFeature; ++j) {
                if (!(norm[j - 1] > 0.0)) continue;
                dp.setFeatureValue(j, (float)((double)dp.getFeatureValue(j) / norm[j - 1]));
            }
        }
    }

    @Override
    public void normalize(RankList rl, int[] fids) {
        int j;
        DataPoint dp;
        int i;
        if (rl.size() == 0) {
            System.out.println("Error in SumNormalizor::normalize(): The input ranked list is empty");
            System.exit(1);
        }
        fids = this.removeDuplicateFeatures(fids);
        double[] norm = new double[fids.length];
        Arrays.fill(norm, 0.0);
        for (i = 0; i < rl.size(); ++i) {
            dp = rl.get(i);
            for (j = 0; j < fids.length; ++j) {
                int n = j;
                norm[n] = norm[n] + (double)Math.abs(dp.getFeatureValue(fids[j]));
            }
        }
        for (i = 0; i < rl.size(); ++i) {
            dp = rl.get(i);
            for (j = 0; j < fids.length; ++j) {
                if (!(norm[j] > 0.0)) continue;
                dp.setFeatureValue(fids[j], (float)((double)dp.getFeatureValue(fids[j]) / norm[j]));
            }
        }
    }

    @Override
    public String name() {
        return "sum";
    }
}

