/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ContextPreservingActionListener;
import org.opensearch.client.Client;
import org.opensearch.client.FilterClient;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;

public final class OriginSettingClient
extends FilterClient {
    private final String origin;

    public OriginSettingClient(Client in, String origin) {
        super(in);
        this.origin = origin;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        Supplier<ThreadContext.StoredContext> supplier = this.in().threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ThreadContextAccess.doPrivileged(() -> this.in().threadPool().getThreadContext().stashWithOrigin(this.origin));){
            super.doExecute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }
}

