/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;

public class ClusterInfoHolder
implements ClusterStateListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Boolean has6xNodes = null;
    private volatile Boolean has6xIndices = null;
    private volatile DiscoveryNodes nodes = null;
    private volatile Boolean isLocalNodeElectedClusterManager = null;
    private volatile boolean initialized;
    private final String clusterName;

    public ClusterInfoHolder(String clusterName) {
        this.clusterName = clusterName;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (this.has6xNodes == null || event.nodesChanged()) {
            this.has6xNodes = ClusterInfoHolder.clusterHas6xNodes(event.state());
            if (isTraceEnabled) {
                this.log.trace("has6xNodes: {}", (Object)this.has6xNodes);
            }
        }
        List indicesCreated = event.indicesCreated();
        List indicesDeleted = event.indicesDeleted();
        if (this.has6xIndices == null || !indicesCreated.isEmpty() || !indicesDeleted.isEmpty()) {
            this.has6xIndices = ClusterInfoHolder.clusterHas6xIndices(event.state());
            if (isTraceEnabled) {
                this.log.trace("has6xIndices: {}", (Object)this.has6xIndices);
            }
        }
        if (this.nodes == null || event.nodesChanged()) {
            this.nodes = event.state().nodes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder now initialized for 'nodes'");
            }
            this.initialized = true;
        }
        this.isLocalNodeElectedClusterManager = event.localNodeClusterManager() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getHas6xNodes() {
        return this.has6xNodes;
    }

    public Boolean getHas6xIndices() {
        return this.has6xIndices;
    }

    public Boolean isLocalNodeElectedClusterManager() {
        return this.isLocalNodeElectedClusterManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Version getMinNodeVersion() {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.getMinNodeVersion();
    }

    public Boolean hasNode(DiscoveryNode node) {
        if (this.nodes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cluster Info Holder not initialized yet for 'nodes'");
            }
            return null;
        }
        return this.nodes.nodeExists(node) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static boolean clusterHas6xNodes(ClusterState state) {
        return state.nodes().getMinNodeVersion().before((Version)LegacyESVersion.V_7_0_0);
    }

    private static boolean clusterHas6xIndices(ClusterState state) {
        for (IndexMetadata indexMetadata : state.metadata().indices().values()) {
            if (!indexMetadata.getCreationVersion().before((Version)LegacyESVersion.V_7_0_0)) continue;
            return true;
        }
        return false;
    }

    public String getClusterName() {
        return this.clusterName;
    }
}

