/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.iocscan.dao;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.action.admin.indices.AliasesNotFoundException;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.model.threatintel.BaseEntity;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.transport.RemoteTransportException;

public abstract class BaseEntityCrudService<Entity extends BaseEntity> {
    private static final Logger log = LogManager.getLogger(BaseEntityCrudService.class);
    private final Client client;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;

    public BaseEntityCrudService(Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
    }

    public void bulkIndexEntities(List<Entity> newEntityList, List<Entity> updatedEntityList, ActionListener<Void> actionListener) {
        try {
            Integer batchSize = (Integer)this.clusterService.getClusterSettings().get(SecurityAnalyticsSettings.BATCH_SIZE);
            this.createIndexIfNotExists((ActionListener<Void>)ActionListener.wrap(r -> {
                IndexRequest indexRequest;
                BaseEntity entity;
                int i;
                ArrayList<BulkRequest> bulkRequestList = new ArrayList<BulkRequest>();
                BulkRequest bulkRequest = new BulkRequest(this.getEntityAliasName());
                for (i = 0; i < newEntityList.size(); ++i) {
                    entity = (BaseEntity)newEntityList.get(i);
                    try {
                        indexRequest = new IndexRequest(this.getEntityAliasName()).id(entity.getId()).source(entity.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).opType(DocWriteRequest.OpType.CREATE);
                        bulkRequest.add(indexRequest);
                        if (bulkRequest.requests().size() != batchSize.intValue() || i == newEntityList.size() - 1) continue;
                        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
                        bulkRequestList.add(bulkRequest);
                        bulkRequest = new BulkRequest();
                        continue;
                    }
                    catch (IOException e) {
                        log.error(String.format("Failed to create index request for %s moving on to next", this.getEntityName()), (Throwable)e);
                    }
                }
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                bulkRequestList.add(bulkRequest);
                for (i = 0; i < updatedEntityList.size(); ++i) {
                    entity = (BaseEntity)updatedEntityList.get(i);
                    try {
                        indexRequest = new IndexRequest(this.getEntityAliasName()).id(entity.getId()).source(entity.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).opType(DocWriteRequest.OpType.INDEX);
                        bulkRequest.add(indexRequest);
                        if (bulkRequest.requests().size() != batchSize.intValue() || i == updatedEntityList.size() - 1) continue;
                        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
                        bulkRequestList.add(bulkRequest);
                        bulkRequest = new BulkRequest();
                        continue;
                    }
                    catch (IOException e) {
                        log.error(String.format("Failed to create index request for %s moving on to next", this.getEntityName()), (Throwable)e);
                    }
                }
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                bulkRequestList.add(bulkRequest);
                GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(bulkResponses -> {
                    int idx = 0;
                    for (BulkResponse response : bulkResponses) {
                        BulkRequest request = (BulkRequest)bulkRequestList.get(idx);
                        if (!response.hasFailures()) continue;
                        log.error("Failed to bulk index {} {}s. Failure: {}", (Object)request.requests().size(), (Object)this.getEntityName(), (Object)response.buildFailureMessage());
                    }
                    actionListener.onResponse(null);
                }, e1 -> {
                    log.error("Failed to bulk index " + this.getEntityName(), (Throwable)e1);
                    actionListener.onFailure(e1);
                }), bulkRequestList.size());
                for (BulkRequest req : bulkRequestList) {
                    try {
                        this.client.bulk(req, (ActionListener)groupedListener);
                    }
                    catch (Exception e) {
                        log.error(() -> new ParameterizedMessage("Failed to bulk save {} {}.", (Object)req.batchSize(), (Object)this.getEntityName()), (Throwable)e);
                        groupedListener.onFailure(e);
                    }
                }
            }, e -> {
                log.error(() -> new ParameterizedMessage("Failed to create System Index {}", (Object)this.getEntityAliasName()), (Throwable)e);
                actionListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Exception saving the threat intel source config in index", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    public void bulkIndexEntities(List<Entity> entityList, ActionListener<Void> actionListener) {
        try {
            Integer batchSize = (Integer)this.clusterService.getClusterSettings().get(SecurityAnalyticsSettings.BATCH_SIZE);
            this.createIndexIfNotExists((ActionListener<Void>)ActionListener.wrap(r -> {
                ArrayList<BulkRequest> bulkRequestList = new ArrayList<BulkRequest>();
                BulkRequest bulkRequest = new BulkRequest(this.getEntityAliasName());
                for (int i = 0; i < entityList.size(); ++i) {
                    BaseEntity entity = (BaseEntity)entityList.get(i);
                    try {
                        IndexRequest indexRequest = new IndexRequest(this.getEntityAliasName()).id(entity.getId()).source(entity.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).opType(DocWriteRequest.OpType.CREATE);
                        bulkRequest.add(indexRequest);
                        if (bulkRequest.requests().size() != batchSize.intValue() || i == entityList.size() - 1) continue;
                        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.NONE);
                        bulkRequestList.add(bulkRequest);
                        bulkRequest = new BulkRequest();
                        continue;
                    }
                    catch (IOException e) {
                        log.error(String.format("Failed to create index request for %s moving on to next", this.getEntityName()), (Throwable)e);
                    }
                }
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                bulkRequestList.add(bulkRequest);
                GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(bulkResponses -> {
                    int idx = 0;
                    for (BulkResponse response : bulkResponses) {
                        BulkRequest request = (BulkRequest)bulkRequestList.get(idx);
                        if (!response.hasFailures()) continue;
                        log.error("Failed to bulk index {} {}s. Failure: {}", (Object)request.batchSize(), (Object)this.getEntityName(), (Object)response.buildFailureMessage());
                    }
                    actionListener.onResponse(null);
                }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)), bulkRequestList.size());
                for (BulkRequest req : bulkRequestList) {
                    try {
                        this.client.bulk(req, (ActionListener)groupedListener);
                    }
                    catch (Exception e) {
                        log.error(() -> new ParameterizedMessage("Failed to bulk save {} {}.", (Object)req.batchSize(), (Object)this.getEntityName()), (Throwable)e);
                    }
                }
            }, e -> {
                log.error(() -> new ParameterizedMessage("Failed to create System Index {}", (Object)this.getEntityIndexPattern()), (Throwable)e);
                actionListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Exception saving the threat intel source config in index", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    public void search(SearchSourceBuilder searchSourceBuilder, ActionListener<SearchResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{this.getEntityAliasName()});
        this.client.search(searchRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            if (e instanceof IndexNotFoundException || e instanceof AliasesNotFoundException) {
                listener.onResponse((Object)DetectorUtils.getEmptySearchResponse());
                return;
            }
            log.error(() -> new ParameterizedMessage("Failed to search {}s from index {}.", (Object)this.getEntityName(), (Object)this.getEntityAliasName()), (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public void createIndexIfNotExists(ActionListener<Void> listener) {
        try {
            if (this.clusterService.state().metadata().hasAlias(this.getEntityAliasName())) {
                listener.onResponse(null);
                return;
            }
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(this.getEntityIndexPattern()).mapping(this.getEntityIndexMapping()).settings(this.getIndexSettings());
            this.client.admin().indices().create(createIndexRequest, ActionListener.wrap(r -> {
                log.debug("{} index created", (Object)this.getEntityName());
                listener.onResponse(null);
            }, e -> {
                if (e instanceof ResourceAlreadyExistsException || e instanceof RemoteTransportException && e.getCause() instanceof ResourceAlreadyExistsException) {
                    log.debug("index {} already exist", (Object)this.getEntityIndexMapping());
                    listener.onResponse(null);
                    return;
                }
                log.error(String.format("Failed to create security analytics threat intel %s index", this.getEntityName()), (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error(String.format("Failure in creating %s index", this.getEntityName()), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    protected abstract String getEntityIndexMapping();

    public abstract String getEntityName();

    protected Settings.Builder getIndexSettings() {
        return Settings.builder().put("index.hidden", true).put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-20");
    }

    public abstract String getEntityAliasName();

    public abstract String getEntityIndexPattern();
}

