/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler.monitor;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.threatIntel.action.monitor.GetThreatIntelAlertsAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.GetThreatIntelAlertsRequest;

public class RestGetThreatIntelAlertsAction
extends BaseRestHandler {
    public String getName() {
        return "get_threat_intel_alerts_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String severityLevel = request.param("severityLevel", "ALL");
        String alertState = request.param("alertState", "ALL");
        String sortString = request.param("sortString", "start_time");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        Instant startTime = null;
        String startTimeParam = request.param("startTime");
        if (startTimeParam != null && !startTimeParam.isEmpty()) {
            try {
                startTime = Instant.ofEpochMilli(Long.parseLong(startTimeParam));
            }
            catch (NullPointerException | NumberFormatException | DateTimeException e) {
                startTime = Instant.now();
            }
        }
        Instant endTime = null;
        String endTimeParam = request.param("endTime");
        if (endTimeParam != null && !endTimeParam.isEmpty()) {
            try {
                endTime = Instant.ofEpochMilli(Long.parseLong(endTimeParam));
            }
            catch (NullPointerException | NumberFormatException | DateTimeException e) {
                endTime = Instant.now();
            }
        }
        Table table = new Table(sortOrder, sortString, missing, size, startIndex, searchString);
        GetThreatIntelAlertsRequest req = new GetThreatIntelAlertsRequest(table, severityLevel, alertState, startTime, endTime);
        return channel -> client.execute((ActionType)GetThreatIntelAlertsAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/threat_intel/alerts"));
    }
}

