/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class LockOperation {
    public static final LockOperation GET = new LockOperation("GET", 1);
    public static final LockOperation GET_TIMEOUT = new LockOperation("GET_TIMEOUT", 2);
    public static final LockOperation PUT = new LockOperation("PUT", 4);
    public static final LockOperation PUT_ALL = new LockOperation("PUT_ALL", 5);
    public static final LockOperation PUT_OBJ = new LockOperation("PUT_OBJ", 6);
    public static final LockOperation TIMEOUT = new LockOperation("TIMEOUT", 8);
    private final String operationName;
    private final int flag;

    static LockOperation fromFlag(int n) {
        switch (n) {
            case 1: {
                return GET;
            }
            case 2: {
                return GET_TIMEOUT;
            }
            case 4: {
                return PUT;
            }
            case 5: {
                return PUT_ALL;
            }
            case 6: {
                return PUT_OBJ;
            }
            case 8: {
                return TIMEOUT;
            }
        }
        throw new IllegalArgumentException("Unknown lock operation: " + n);
    }

    private LockOperation(String string, int n) {
        this.operationName = string;
        this.flag = n;
    }

    public String toString() {
        return "LockOperation." + this.operationName;
    }

    int getFlag() {
        return this.flag;
    }
}

