/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.config.mvn.ArtifactException;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenProxySelector;
import org.jboss.galleon.cli.config.mvn.MavenSettings;

class MavenMvnSettings
implements MavenSettings {
    private static final String EXTERNAL = "external:";
    private static final String ALL = "*";
    private static final String NOT = "!";
    private final List<RemoteRepository> repositories;
    private final RepositorySystemSession session;
    private final MavenConfig config;
    private final Proxy proxy;
    private final MavenProxySelector proxySelector;

    MavenMvnSettings(MavenConfig config, RepositorySystem repoSystem, RepositoryListener listener) throws ArtifactException {
        this.config = config;
        Settings settings = MavenMvnSettings.buildMavenSettings(config.getSettings());
        org.apache.maven.settings.Proxy proxy = settings.getActiveProxy();
        if (proxy != null) {
            MavenProxySelector.Builder builder = new MavenProxySelector.Builder(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
            builder.setPassword(proxy.getPassword());
            builder.setUserName(proxy.getUsername());
            if (proxy.getNonProxyHosts() != null) {
                String[] hosts = proxy.getNonProxyHosts().split("\\|");
                builder.addNonProxyHosts(Arrays.asList(hosts));
            }
            this.proxySelector = builder.build();
            Authentication auth = null;
            if (proxy.getPassword() != null && proxy.getUsername() != null) {
                auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            }
            this.proxy = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        } else {
            this.proxy = null;
            this.proxySelector = null;
        }
        try {
            this.repositories = Collections.unmodifiableList(this.buildRemoteRepositories(settings));
        }
        catch (MalformedURLException ex) {
            throw new ArtifactException(ex.getMessage(), ex);
        }
        this.session = Util.newRepositorySession(repoSystem, settings.getLocalRepository() == null ? config.getLocalRepository() : Paths.get(settings.getLocalRepository(), new String[0]), listener, this.proxySelector, settings.isOffline());
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public RepositorySystemSession getSession() {
        return this.session;
    }

    private static Settings buildMavenSettings(Path settingsPath) throws ArtifactException {
        SettingsBuildingResult settingsBuildingResult;
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(settingsPath.toFile());
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        try {
            settingsBuildingResult = settingsBuilder.build(settingsBuildingRequest);
        }
        catch (SettingsBuildingException ex) {
            throw new ArtifactException(ex.getLocalizedMessage());
        }
        return settingsBuildingResult.getEffectiveSettings();
    }

    private List<RemoteRepository> buildRemoteRepositories(Settings settings) throws ArtifactException, MalformedURLException {
        Map<String, Profile> profiles = settings.getProfilesAsMap();
        LinkedHashMap<String, RemoteRepository> repos = new LinkedHashMap<String, RemoteRepository>();
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        HashSet<String> urls = new HashSet<String>();
        for (Profile profile : settings.getProfiles()) {
            if ((profile.getActivation() == null || !profile.getActivation().isActiveByDefault()) && !settings.getActiveProfiles().contains(profile.getId())) continue;
            List<Repository> list = profile.getRepositories();
            for (Repository repo : list) {
                repos.put(repo.getId(), this.buildRepository(repo.getId(), repo.getLayout(), repo.getUrl(), settings, repo.getReleases(), repo.getSnapshots(), null));
                urls.add(repo.getUrl());
            }
        }
        List<RemoteRepository> defaultRepositories = this.config.getMissingDefaultRepositories(urls, this.proxySelector, this.proxy);
        for (RemoteRepository remoteRepository : defaultRepositories) {
            repos.put(remoteRepository.getId(), remoteRepository);
        }
        repositories.addAll(this.handleMirroring(settings, repos));
        for (Map.Entry entry : repos.entrySet()) {
            repositories.add((RemoteRepository)entry.getValue());
        }
        return repositories;
    }

    private List<RemoteRepository> handleMirroring(Settings settings, Map<String, RemoteRepository> repos) throws MalformedURLException {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        for (Mirror mirror : settings.getMirrors()) {
            String[] patterns = mirror.getMirrorOf().split(",");
            ArrayList<RemoteRepository> mirrored = new ArrayList<RemoteRepository>();
            boolean all = false;
            ArrayList<String> excluded = new ArrayList<String>();
            for (String p : patterns) {
                if (ALL.equals(p = p.trim())) {
                    all = true;
                    continue;
                }
                if (!p.startsWith(NOT)) continue;
                excluded.add(p.substring(NOT.length()));
            }
            if (all) {
                ArrayList<String> safeKeys = new ArrayList<String>(repos.keySet());
                for (String k : safeKeys) {
                    if (excluded.contains(k)) continue;
                    mirrored.add(repos.remove(k));
                }
            } else {
                for (String p : patterns) {
                    if ((p = p.trim()).startsWith(EXTERNAL)) {
                        CliLogging.log.warn("external:* mirroring is not supported, skipping configuration item");
                        continue;
                    }
                    RemoteRepository m = repos.get(p);
                    if (m == null) continue;
                    mirrored.add(repos.remove(p));
                }
            }
            if (mirrored.isEmpty()) continue;
            repositories.add(this.buildRepository(mirror.getId(), mirror.getLayout(), mirror.getUrl(), settings, null, null, mirrored));
        }
        return repositories;
    }

    private RemoteRepository buildRepository(String id, String type, String url, Settings settings, org.apache.maven.settings.RepositoryPolicy rp, org.apache.maven.settings.RepositoryPolicy sp, List<RemoteRepository> mirrored) throws MalformedURLException {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, type == null ? "default" : type, url);
        if (rp != null) {
            RepositoryPolicy releases = new RepositoryPolicy(rp.isEnabled(), rp.getUpdatePolicy(), rp.getChecksumPolicy());
            builder.setReleasePolicy(releases);
        }
        if (sp != null) {
            RepositoryPolicy snapshots = new RepositoryPolicy(sp.isEnabled(), sp.getUpdatePolicy(), sp.getChecksumPolicy());
            builder.setReleasePolicy(snapshots);
        }
        for (Server server : settings.getServers()) {
            AuthenticationBuilder authBuilder;
            if (!server.getId().equals(id)) continue;
            if (server.getUsername() != null) {
                authBuilder = new AuthenticationBuilder();
                authBuilder.addPassword(server.getPassword());
                authBuilder.addUsername(server.getUsername());
                builder.setAuthentication(authBuilder.build());
                continue;
            }
            if (server.getPrivateKey() == null) continue;
            authBuilder = new AuthenticationBuilder();
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            builder.setAuthentication(authBuilder.build());
        }
        if (mirrored != null) {
            builder.setMirroredRepositories(mirrored);
        }
        if (this.proxySelector != null && this.proxySelector.proxyFor(new URL(url).getHost())) {
            builder.setProxy(this.proxy);
        }
        return builder.build();
    }
}

