/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.jndi.SchemaOps;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class DXAttribute
extends BasicAttribute
implements Comparable {
    protected boolean isString = true;
    protected boolean isASN1 = false;
    static boolean appendBinaryOption = false;
    String name;
    String syntaxOID;
    String syntaxDesc;
    String description;
    private static final String STRING = "string";
    private static final String BYTE_ARRAY = "bytes";
    private static final String ASN1 = "asn1";
    static Hashtable knownAttributeTypes;
    static SchemaOps schema;
    private CollationKey collationKey;
    private static Collator myCollator;
    private static final Logger log;

    public DXAttribute(String ID2) {
        super(ID2);
        this.init();
    }

    public DXAttribute(String ID2, Object value) {
        super(ID2, value);
        this.init();
    }

    public DXAttribute(Attribute att) {
        super(att.getID());
        try {
            this.addValues(att.getAll());
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "error reading attribute values for attribute " + this.getID() + "\n", e);
        }
        this.setName(att.getID());
        this.init();
    }

    public DXAttribute(String ID2, NamingEnumeration values) {
        super(ID2);
        this.addValues(values);
        this.init();
    }

    public void addValues(NamingEnumeration values) {
        try {
            while (values.hasMore()) {
                this.add(values.next());
            }
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "error adding values for attribute " + this.getID(), e);
        }
    }

    public void sort() {
        if (this.values.size() < 2) {
            return;
        }
        try {
            Collections.sort(this.values);
        }
        catch (ClassCastException e) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void setDefaultSchema(SchemaOps defaultSchema) {
        schema = defaultSchema;
    }

    protected void init() {
        this.setAttributeType();
        this.collationKey = myCollator.getCollationKey(this.getID());
    }

    protected void setAttributeType() {
        String ID2 = this.getID();
        if ("SYNTAXNAMENUMERICOIDDESCEQUALITY".indexOf(ID2) != -1) {
            return;
        }
        if (knownAttributeTypes.get(ID2 = ID2.toLowerCase()) != null) {
            this.isString = STRING.equals(knownAttributeTypes.get(ID2));
            this.isASN1 = ASN1.equals(knownAttributeTypes.get(ID2));
        } else if (ID2.endsWith(";binary")) {
            this.isString = false;
            this.isASN1 = true;
        } else if (schema != null) {
            this.setAttributeTypeFromSchema();
        } else {
            try {
                if (this.size() > 0) {
                    Object value = this.get();
                    boolean bl = this.isString = value == null || value instanceof String;
                    if (!this.isString) {
                        this.isASN1 = this.isKnownASN1Attribute(ID2);
                    }
                }
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "Unexpected error reading value from attribute " + ID2, e);
            }
        }
        this.updateTypesHashtable(ID2);
    }

    private void updateTypesHashtable(String ID2) {
        if (!knownAttributeTypes.contains(ID2)) {
            if (this.isString) {
                knownAttributeTypes.put(ID2, STRING);
            } else if (this.isASN1) {
                knownAttributeTypes.put(ID2, ASN1);
            } else {
                knownAttributeTypes.put(ID2, BYTE_ARRAY);
            }
        }
    }

    public static boolean isEmpty(Attribute att) {
        if (att == null || att.size() == 0) {
            return true;
        }
        if (att.size() == 1) {
            Object val = null;
            try {
                val = att.get();
            }
            catch (NamingException e) {
                return true;
            }
            if (val == null || "".equals(val)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringSyntax(String syntaxName) {
        char c;
        if (syntaxName == null) {
            return true;
        }
        int pos = syntaxName.indexOf("1.3.6.1.4.1.1466.115.121.1.");
        if (pos == -1) {
            return true;
        }
        String number = syntaxName.substring(pos + "1.3.6.1.4.1.1466.115.121.1.".length());
        if (number.length() > 2 && !Character.isDigit(c = (number = number.substring(0, 2)).charAt(1))) {
            number = number.substring(0, 1);
        }
        try {
            int finalNumber = Integer.parseInt(number);
            switch (finalNumber) {
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 10: {
                    return false;
                }
                case 28: {
                    return false;
                }
                case 40: {
                    return false;
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, "Unexpected error parsing syntax: " + syntaxName, e);
            return true;
        }
    }

    public static boolean isASN1Syntax(String syntaxName) {
        char c;
        if (syntaxName == null) {
            return false;
        }
        int pos = syntaxName.indexOf("1.3.6.1.4.1.1466.115.121.1.");
        if (pos == -1) {
            return false;
        }
        String number = syntaxName.substring(pos + "1.3.6.1.4.1.1466.115.121.1.".length());
        if (number.length() > 2 && !Character.isDigit(c = (number = number.substring(0, 2)).charAt(1))) {
            number = number.substring(0, 1);
        }
        try {
            int finalNumber = Integer.parseInt(number);
            switch (finalNumber) {
                case 5: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 10: {
                    return true;
                }
            }
            return false;
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, "Unexpected error parsing syntax: " + syntaxName, e);
            return false;
        }
    }

    public void setAttributeTypeFromSchema() {
        block11: {
            if (schema != null) {
                try {
                    String attributeNameInSchema = "AttributeDefinition/" + this.getID();
                    Attributes atts = schema.getAttributes(attributeNameInSchema);
                    Attribute syntaxAttribute = null;
                    while (atts != null && (syntaxAttribute = atts.get("SUP")) != null) {
                        atts = schema.getAttributes("AttributeDefinition/" + syntaxAttribute.get().toString());
                    }
                    if (atts != null) {
                        syntaxAttribute = atts.get("SYNTAX");
                    }
                    if (syntaxAttribute != null) {
                        this.syntaxOID = syntaxAttribute.toString();
                        this.isString = DXAttribute.isStringSyntax(this.syntaxOID);
                        if (!this.isString) {
                            this.isASN1 = DXAttribute.isASN1Syntax(this.syntaxOID);
                        }
                        break block11;
                    }
                    log.info(" Can't find SYNTAX for... " + this.getID());
                }
                catch (NamingException e) {
                    try {
                        Attributes atts = schema.getAttributes("AttributeDefinition/" + this.getID() + ";binary");
                        if (atts != null) {
                            this.isString = false;
                            this.isASN1 = true;
                        }
                    }
                    catch (Exception e2) {
                        log.log(Level.INFO, "can't find syntax for attribute " + this.getID(), e);
                    }
                }
            } else {
                log.fine("no schema available");
            }
        }
    }

    public boolean isBinary() {
        return !this.isString();
    }

    public boolean isString() {
        return this.isString;
    }

    public void setBinary(boolean bin) {
        this.setString(!bin);
    }

    public void setString(boolean stringStatus) {
        knownAttributeTypes.put(this.getID(), stringStatus ? STRING : BYTE_ARRAY);
        this.isString = stringStatus;
    }

    public String schemaLookup(String schemaEntry, String schemaAttribute) {
        if (schema == null) {
            return null;
        }
        return schema.schemaLookup(schemaEntry, schemaAttribute);
    }

    public boolean hasOptions() {
        if (this.description == null) {
            this.getDescription();
        }
        return this.description != null && this.description != "" && this.description.indexOf("LIST:") >= 0;
    }

    public String[] getOptions() {
        if (this.description == null) {
            this.getDescription();
        }
        if (this.description == null || this.description == "") {
            return new String[0];
        }
        int len = this.description.length();
        int pos = this.description.indexOf("LIST:");
        if (pos < 0) {
            return new String[0];
        }
        int next = pos += 5;
        Vector<String> resVect = new Vector<String>();
        resVect.add("");
        while (pos < len && pos > 0) {
            if ((next = this.description.indexOf(44, next + 1)) < 0) {
                resVect.add(this.description.substring(pos));
                pos = 0;
                continue;
            }
            if (this.description.charAt(next - 1) != '\\') {
                resVect.add(this.description.substring(pos, next));
                pos = next + 1;
                continue;
            }
            ++next;
        }
        String[] result = new String[resVect.size()];
        for (int i = 0; i < resVect.size(); ++i) {
            result[i] = this.unEscape((String)resVect.elementAt(i));
        }
        return result;
    }

    public String unEscape(String escapeMe) {
        int slashpos = escapeMe.indexOf(92);
        while (slashpos >= 0) {
            escapeMe = escapeMe.substring(0, slashpos) + escapeMe.substring(slashpos + 1);
            slashpos = escapeMe.indexOf(92);
        }
        return escapeMe;
    }

    public String getSyntaxOID() {
        if (this.syntaxOID == null) {
            this.setAttributeTypeFromSchema();
        }
        if (this.syntaxOID == null) {
            return "<unknown>";
        }
        return this.syntaxOID;
    }

    public String getSyntaxDesc() {
        if (this.syntaxDesc == null) {
            this.syntaxDesc = this.schemaLookup("SyntaxDefinition/" + this.getSyntaxOID(), "DESC");
        }
        return this.syntaxDesc;
    }

    public String getSyntaxName() {
        if (this.syntaxOID == null) {
            this.setAttributeTypeFromSchema();
        }
        if (this.syntaxOID == null) {
            return "<unknown>";
        }
        return schema.translateOID(this.syntaxOID);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.schemaLookup("AttributeDefinition/" + this.getID(), "NAME");
        }
        if (this.name == null) {
            this.name = this.getID();
        }
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.schemaLookup("AttributeDefinition/" + this.getID(), "DESC");
            if (this.description == null) {
                this.description = "";
            }
        }
        return this.description;
    }

    public String toString() {
        return this.getID();
    }

    public String toDebugString() {
        int count = 1;
        try {
            StringBuffer result = new StringBuffer().append("att: ").append(this.getID()).append(" (size=").append(this.size()).append(") ");
            NamingEnumeration<?> vals = this.getAll();
            if (!this.isString) {
                result.append(" (Byte Array) ");
                while (vals.hasMore()) {
                    try {
                        byte[] b = (byte[])vals.next();
                        result.append("\n    ").append(count++).append(":").append(b == null ? "null" : CBBase64.binaryToString(b));
                    }
                    catch (ClassCastException cce) {
                        result.append("\n    ").append(count++).append(": <error - not a byte array>");
                    }
                }
            } else {
                while (vals.hasMore()) {
                    Object o = vals.next();
                    result.append("\n    ").append(count++).append(":").append(o == null ? "null" : o.toString());
                }
            }
            return result.append("\n").toString();
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "error listing values for " + this.getID(), e);
            return this.getID() + " (error listing values)";
        }
    }

    public static void setVerboseBinary(boolean status) {
        appendBinaryOption = status;
        log.fine("setting isNonString attribute status to " + status);
    }

    public String getID() {
        String id = super.getID();
        if (appendBinaryOption && !id.endsWith(";binary") && this.isASN1) {
            id = id + ";binary";
            log.info("appending ;binary to attribute name " + id);
        }
        return id;
    }

    public boolean isKnownASN1Attribute(String id) {
        String search = id.toLowerCase();
        if (search.indexOf("certificate") >= 0) {
            return true;
        }
        if (search.indexOf("revocation") >= 0) {
            return true;
        }
        if (search.indexOf("supportedalgorithms") >= 0) {
            return true;
        }
        return search.indexOf("userpkcs12") >= 0;
    }

    public Object[] getValues() {
        Object[] values = new String[this.size()];
        try {
            for (int i = 0; i < this.size(); ++i) {
                values[i] = this.get(i);
            }
            return values;
        }
        catch (NamingException e) {
            return new String[0];
        }
    }

    public void trim() {
        for (int i = this.size() - 1; i > 0; --i) {
            Object o = null;
            try {
                o = this.get(i);
                if (o != null && !"".equals(o)) continue;
                this.remove(i);
                continue;
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "Bad Attribute value in DXAttribute - removing ", e);
                this.remove(i);
            }
        }
    }

    public void setOrdered(boolean state) {
        this.ordered = state;
    }

    public boolean isSingleValued() {
        return schema.isAttributeSingleValued(this.getName());
    }

    public void setCollationKey(CollationKey key) {
        this.collationKey = key;
    }

    public CollationKey getCollationKey() {
        return this.collationKey;
    }

    public int compareTo(Object o) {
        return this.collationKey.compareTo(((DXAttribute)o).getCollationKey());
    }

    static {
        myCollator = Collator.getInstance();
        log = Logger.getLogger(DXAttribute.class.getName());
        knownAttributeTypes = new Hashtable(100);
    }
}

