/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.RealmMigration;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo22_0_0
extends RealmMigration {
    public static final ModelVersion VERSION = new ModelVersion("22.0.0");
    public static final String HTTP_CHALLENGE_FLOW = "http challenge";
    private static final Logger LOG = Logger.getLogger(MigrateTo22_0_0.class);

    @Override
    public void migrateRealm(KeycloakSession session, RealmModel realm) {
        this.removeHttpChallengeFlow(session, realm);
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.removeHttpChallengeFlow(session, realm);
        this.updateLoginTheme(realm);
        this.updateAccountTheme(realm);
        this.updateEmailTheme(realm);
        this.updateClientAttributes(realm);
    }

    private void removeHttpChallengeFlow(KeycloakSession session, RealmModel realm) {
        AuthenticationFlowModel httpChallenge = realm.getFlowByAlias(HTTP_CHALLENGE_FLOW);
        if (httpChallenge == null) {
            return;
        }
        try {
            KeycloakModelUtils.deepDeleteAuthenticationFlow((KeycloakSession)session, (RealmModel)realm, (AuthenticationFlowModel)httpChallenge, () -> {}, () -> {});
            LOG.debugf("Removed '%s' authentication flow in realm '%s'", (Object)HTTP_CHALLENGE_FLOW, (Object)realm.getName());
        }
        catch (ModelException me) {
            LOG.errorf("Authentication flow '%s' is in use in realm '%s' and cannot be removed. Please update your deployment to avoid using this flow before migration to latest Keycloak", (Object)HTTP_CHALLENGE_FLOW, (Object)realm.getName());
            throw me;
        }
    }

    private void updateAccountTheme(RealmModel realm) {
        String accountTheme = realm.getAccountTheme();
        if ("keycloak".equals(accountTheme) || "rh-sso".equals(accountTheme) || "rh-sso.v2".equals(accountTheme)) {
            realm.setAccountTheme("keycloak.v2");
        }
    }

    private void updateEmailTheme(RealmModel realm) {
        String emailTheme = realm.getEmailTheme();
        if ("rh-sso".equals(emailTheme)) {
            realm.setEmailTheme(null);
        }
    }

    private void updateLoginTheme(RealmModel realm) {
        String loginTheme = realm.getLoginTheme();
        if ("rh-sso".equals(loginTheme)) {
            realm.setLoginTheme(null);
        }
    }

    private void updateClientAttributes(RealmModel realm) {
        realm.getClientsStream().filter(client -> {
            String clientLoginTheme = client.getAttribute("login_theme");
            return clientLoginTheme != null && clientLoginTheme.equals("rh-sso");
        }).forEach(client -> client.setAttribute("login_theme", null));
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

