/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.autoupdate.members;

import au.com.trgtd.tr.autoupdate.members.MemberUtils;
import au.com.trgtd.tr.autoupdate.members.nb.ProxySettings;
import au.com.trgtd.tr.autoupdate.members.prefs.MemberPrefs;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class MemberAuthenticator
extends Authenticator {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.autoupdate.members");
    private static final String MEMBER_AUTOUPDATE_USER = "authorized";
    private static final String MEMBER_AUTOUPDATE_PASS = "pVng@APP3,c1";
    private static final String MEMBER_AUTOUPDATE_HOST = "www.trgtd.com.au";
    private static final String MEMBER_AUTOUPDATE_PATH = "/tr/updates/2.2/";

    public MemberAuthenticator() {
        Preferences proxySettingsNode = NbPreferences.root().node("/org/netbeans/core");
        assert (proxySettingsNode != null);
    }

    protected PasswordAuthentication getNbPasswordAuthentication() {
        if (ProxySettings.useAuthentication()) {
            return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
        }
        LOG.warning("No authentication set while requesting " + this.getRequestingURL());
        return null;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        LOG.info("Requesting URL : " + this.getRequestingURL().toString());
        LOG.info("Requesting Host: " + this.getRequestingHost());
        LOG.info("Requesting Type: " + (this.getRequestorType() == Authenticator.RequestorType.PROXY ? "PROXY" : "SERVER"));
        if (this.getRequestorType() == Authenticator.RequestorType.SERVER && this.getRequestingURL().getHost().equals(MEMBER_AUTOUPDATE_HOST) && this.getRequestingURL().getPath().startsWith(MEMBER_AUTOUPDATE_PATH)) {
            LOG.info("Attempting to access member update center.");
            if (MemberPrefs.getMemberUsername().trim().length() == 0) {
                LOG.info("No username in preferences.");
            } else {
                if (this.isMember()) {
                    LOG.info("User is an active member.");
                    return new PasswordAuthentication(MEMBER_AUTOUPDATE_USER, MEMBER_AUTOUPDATE_PASS.toCharArray());
                }
                LOG.info("User is not an active member.");
            }
        }
        try {
            LOG.info("Using default NB authenticator.");
            return this.getNbPasswordAuthentication();
        }
        catch (Exception ex) {
            LOG.severe("Default NB authenticator could not be used.\n" + ex.getMessage());
            ex.printStackTrace(System.err);
            return super.getPasswordAuthentication();
        }
    }

    private boolean isMember() {
        String username = MemberPrefs.getMemberUsername();
        String password = MemberPrefs.getMemberPassword();
        Boolean isMember = MemberUtils.getDefault().isMember(username, password);
        return isMember == null ? false : isMember;
    }
}

