/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

@FunctionalInterface
public interface SftpVersionSelector {
    public static final NamedVersionSelector CURRENT = new NamedVersionSelector("CURRENT", (session, initial, current, available) -> current);
    public static final NamedVersionSelector MAXIMUM = new NamedVersionSelector("MAXIMUM", (session, initial, current, available) -> GenericUtils.stream((Iterable)available).mapToInt(Integer::intValue).max().orElse(current));
    public static final NamedVersionSelector MINIMUM = new NamedVersionSelector("MINIMUM", (session, initial, current, available) -> GenericUtils.stream((Iterable)available).mapToInt(Integer::intValue).min().orElse(current));

    public int selectVersion(ClientSession var1, boolean var2, int var3, List<Integer> var4);

    public static NamedVersionSelector fixedVersionSelector(int version) {
        return new NamedVersionSelector(Integer.toString(version), (session, initial, current, available) -> version);
    }

    public static NamedVersionSelector preferredVersionSelector(int ... preferred) {
        return SftpVersionSelector.preferredVersionSelector(NumberUtils.asList((int[])preferred));
    }

    public static NamedVersionSelector preferredVersionSelector(Iterable<? extends Number> preferred) {
        ValidateUtils.checkNotNullAndNotEmpty((Collection)((Collection)preferred), (String)"Empty preferred versions", (Object[])new Object[0]);
        return new NamedVersionSelector(GenericUtils.join(preferred, (char)','), (session, initial, current, available) -> StreamSupport.stream(preferred.spliterator(), false).mapToInt(Number::intValue).filter(v -> v == current || available.contains(v)).findFirst().orElseThrow(() -> new IllegalStateException("Preferred versions (" + preferred + ") not available: " + available)));
    }

    public static NamedVersionSelector resolveVersionSelector(String selector) {
        if (GenericUtils.isEmpty((CharSequence)selector)) {
            return CURRENT;
        }
        if (selector.equalsIgnoreCase(CURRENT.getName())) {
            return CURRENT;
        }
        if (selector.equalsIgnoreCase(MINIMUM.getName())) {
            return MINIMUM;
        }
        if (selector.equalsIgnoreCase(MAXIMUM.getName())) {
            return MAXIMUM;
        }
        if (NumberUtils.isIntegerNumber((CharSequence)selector)) {
            return SftpVersionSelector.fixedVersionSelector(Integer.parseInt(selector));
        }
        String[] preferred = GenericUtils.split((String)selector, (char)',');
        int[] prefs = Stream.of(preferred).mapToInt(Integer::parseInt).toArray();
        return SftpVersionSelector.preferredVersionSelector(prefs);
    }

    public static class NamedVersionSelector
    implements SftpVersionSelector,
    NamedResource {
        protected final SftpVersionSelector selector;
        private final String name;

        public NamedVersionSelector(String name, SftpVersionSelector selector) {
            this.name = ValidateUtils.checkNotNullAndNotEmpty((String)name, (String)"No name provided");
            this.selector = Objects.requireNonNull(selector, "No delegate selector provided");
        }

        @Override
        public int selectVersion(ClientSession session, boolean initial, int current, List<Integer> available) {
            return this.selector.selectVersion(session, initial, current, available);
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return GenericUtils.hashCode((String)this.getName(), (Boolean)Boolean.TRUE);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return NamedResource.safeCompareByName((NamedResource)this, (NamedResource)((NamedVersionSelector)obj), (boolean)false) == 0;
        }

        public String toString() {
            return this.getName();
        }
    }
}

