/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.ConnectorStatistics;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ByteActivityCallback;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ConnectorStatisticsImpl
implements ConnectorStatistics {
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> requestCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "requestCount");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> bytesSentUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "bytesSent");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> bytesReceivedUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "bytesReceived");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> errorCountUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "errorCount");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> processingTimeUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "processingTime");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> maxProcessingTimeUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "maxProcessingTime");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> activeConnectionsUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "activeConnections");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> maxActiveConnectionsUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "maxActiveConnections");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> activeRequestsUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "activeRequests");
    private static final AtomicLongFieldUpdater<ConnectorStatisticsImpl> maxActiveRequestsUpdater = AtomicLongFieldUpdater.newUpdater(ConnectorStatisticsImpl.class, "maxActiveRequests");
    private volatile long requestCount;
    private volatile long bytesSent;
    private volatile long bytesReceived;
    private volatile long errorCount;
    private volatile long processingTime;
    private volatile long maxProcessingTime;
    private volatile long activeConnections;
    private volatile long maxActiveConnections;
    private volatile long activeRequests;
    private volatile long maxActiveRequests;
    private final ExchangeCompletionListener completionListener = new ExchangeCompletionListener(){

        @Override
        public void exchangeEvent(HttpServerExchange exchange) {
            long start;
            activeRequestsUpdater.decrementAndGet(ConnectorStatisticsImpl.this);
            if (exchange.getStatusCode() == 500) {
                errorCountUpdater.incrementAndGet(ConnectorStatisticsImpl.this);
            }
            if ((start = exchange.getRequestStartTime()) > 0L) {
                long oldMax;
                long elapsed = System.nanoTime() - start;
                processingTimeUpdater.addAndGet(ConnectorStatisticsImpl.this, elapsed);
                while ((oldMax = maxProcessingTimeUpdater.get(ConnectorStatisticsImpl.this)) < elapsed && !maxProcessingTimeUpdater.compareAndSet(ConnectorStatisticsImpl.this, oldMax, elapsed)) {
                }
            }
        }
    };
    private final ByteActivityCallback bytesSentAccumulator = new BytesSentAccumulator();
    private final ByteActivityCallback bytesReceivedAccumulator = new BytesReceivedAccumulator();

    @Override
    public long getRequestCount() {
        return requestCountUpdater.get(this);
    }

    @Override
    public long getBytesSent() {
        return bytesSentUpdater.get(this);
    }

    @Override
    public long getBytesReceived() {
        return bytesReceivedUpdater.get(this);
    }

    @Override
    public long getErrorCount() {
        return errorCountUpdater.get(this);
    }

    @Override
    public long getProcessingTime() {
        return processingTimeUpdater.get(this);
    }

    @Override
    public long getMaxProcessingTime() {
        return maxProcessingTimeUpdater.get(this);
    }

    @Override
    public void reset() {
        requestCountUpdater.set(this, 0L);
        bytesSentUpdater.set(this, 0L);
        bytesReceivedUpdater.set(this, 0L);
        errorCountUpdater.set(this, 0L);
        maxProcessingTimeUpdater.set(this, 0L);
        processingTimeUpdater.set(this, 0L);
        maxActiveConnectionsUpdater.set(this, 0L);
        maxActiveRequestsUpdater.set(this, 0L);
    }

    public void requestFinished(long bytesSent, long bytesReceived, boolean error) {
        bytesSentUpdater.addAndGet(this, bytesSent);
        bytesReceivedUpdater.addAndGet(this, bytesReceived);
        if (error) {
            errorCountUpdater.incrementAndGet(this);
        }
    }

    public void updateBytesSent(long bytes) {
        bytesSentUpdater.addAndGet(this, bytes);
    }

    public void updateBytesReceived(long bytes) {
        bytesReceivedUpdater.addAndGet(this, bytes);
    }

    public void setup(HttpServerExchange exchange) {
        long maxActiveRequests;
        requestCountUpdater.incrementAndGet(this);
        long current = activeRequestsUpdater.incrementAndGet(this);
        while (current > (maxActiveRequests = this.maxActiveRequests) && !maxActiveRequestsUpdater.compareAndSet(this, maxActiveRequests, current)) {
        }
        exchange.addExchangeCompleteListener(this.completionListener);
    }

    public ByteActivityCallback sentAccumulator() {
        return this.bytesSentAccumulator;
    }

    public ByteActivityCallback receivedAccumulator() {
        return this.bytesReceivedAccumulator;
    }

    @Override
    public long getActiveConnections() {
        return this.activeConnections;
    }

    @Override
    public long getMaxActiveConnections() {
        return this.maxActiveConnections;
    }

    public void incrementConnectionCount() {
        long maxActiveConnections;
        long current = activeConnectionsUpdater.incrementAndGet(this);
        do {
            if (current > (maxActiveConnections = this.maxActiveConnections)) continue;
            return;
        } while (!maxActiveConnectionsUpdater.compareAndSet(this, maxActiveConnections, current));
    }

    public void decrementConnectionCount() {
        activeConnectionsUpdater.decrementAndGet(this);
    }

    @Override
    public long getActiveRequests() {
        return this.activeRequests;
    }

    @Override
    public long getMaxActiveRequests() {
        return this.maxActiveRequests;
    }

    private class BytesSentAccumulator
    implements ByteActivityCallback {
        private BytesSentAccumulator() {
        }

        @Override
        public void activity(long bytes) {
            bytesSentUpdater.addAndGet(ConnectorStatisticsImpl.this, bytes);
        }
    }

    private class BytesReceivedAccumulator
    implements ByteActivityCallback {
        private BytesReceivedAccumulator() {
        }

        @Override
        public void activity(long bytes) {
            bytesReceivedUpdater.addAndGet(ConnectorStatisticsImpl.this, bytes);
        }
    }
}

