/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4F_compressOptions_t")
public class LZ4FCompressOptions
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STABLESRC;
    public static final int RESERVED;

    public LZ4FCompressOptions(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4FCompressOptions.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int stableSrc() {
        return LZ4FCompressOptions.nstableSrc(this.address());
    }

    @NativeType(value="unsigned[3]")
    public IntBuffer reserved() {
        return LZ4FCompressOptions.nreserved(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved(int index) {
        return LZ4FCompressOptions.nreserved(this.address(), index);
    }

    public LZ4FCompressOptions stableSrc(@NativeType(value="unsigned") int value) {
        LZ4FCompressOptions.nstableSrc(this.address(), value);
        return this;
    }

    public LZ4FCompressOptions reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
        LZ4FCompressOptions.nreserved(this.address(), value);
        return this;
    }

    public LZ4FCompressOptions reserved(int index, @NativeType(value="unsigned") int value) {
        LZ4FCompressOptions.nreserved(this.address(), index, value);
        return this;
    }

    public LZ4FCompressOptions set(int stableSrc, IntBuffer reserved) {
        this.stableSrc(stableSrc);
        this.reserved(reserved);
        return this;
    }

    public LZ4FCompressOptions set(LZ4FCompressOptions src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LZ4FCompressOptions malloc() {
        return (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LZ4FCompressOptions calloc() {
        return (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LZ4FCompressOptions create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LZ4FCompressOptions create(long address) {
        return (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)address);
    }

    @Nullable
    public static LZ4FCompressOptions createSafe(long address) {
        return address == 0L ? null : (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LZ4FCompressOptions.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FCompressOptions.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static LZ4FCompressOptions mallocStack() {
        return LZ4FCompressOptions.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FCompressOptions callocStack() {
        return LZ4FCompressOptions.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FCompressOptions mallocStack(MemoryStack stack) {
        return LZ4FCompressOptions.malloc(stack);
    }

    @Deprecated
    public static LZ4FCompressOptions callocStack(MemoryStack stack) {
        return LZ4FCompressOptions.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LZ4FCompressOptions.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LZ4FCompressOptions.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FCompressOptions.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FCompressOptions.calloc(capacity, stack);
    }

    public static LZ4FCompressOptions malloc(MemoryStack stack) {
        return (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LZ4FCompressOptions calloc(MemoryStack stack) {
        return (LZ4FCompressOptions)LZ4FCompressOptions.wrap(LZ4FCompressOptions.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LZ4FCompressOptions.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nstableSrc(long struct) {
        return UNSAFE.getInt(null, struct + (long)STABLESRC);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)3);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)3) * 4L);
    }

    public static void nstableSrc(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STABLESRC, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 4));
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)3) * 4L, value);
    }

    static {
        Struct.Layout layout = LZ4FCompressOptions.__struct((Struct.Member[])new Struct.Member[]{LZ4FCompressOptions.__member((int)4), LZ4FCompressOptions.__array((int)4, (int)3)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STABLESRC = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4FCompressOptions, Buffer>
    implements NativeResource {
        private static final LZ4FCompressOptions ELEMENT_FACTORY = LZ4FCompressOptions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4FCompressOptions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int stableSrc() {
            return LZ4FCompressOptions.nstableSrc(this.address());
        }

        @NativeType(value="unsigned[3]")
        public IntBuffer reserved() {
            return LZ4FCompressOptions.nreserved(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved(int index) {
            return LZ4FCompressOptions.nreserved(this.address(), index);
        }

        public Buffer stableSrc(@NativeType(value="unsigned") int value) {
            LZ4FCompressOptions.nstableSrc(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
            LZ4FCompressOptions.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned") int value) {
            LZ4FCompressOptions.nreserved(this.address(), index, value);
            return this;
        }
    }
}

