/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.HashSetBuilder$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.SetNode;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;

public final class HashSetBuilder<A>
implements ReusableBuilder<A, HashSet<A>> {
    private HashSet<A> aliased;
    private BitmapIndexedSetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode = this.newEmptyRootNode();

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(int size) {
        void var1_1;
        Builder.sizeHint$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        void var2_2;
        void var1_1;
        Builder.sizeHint$(this, (IterableOnce)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <NewTo> Builder<A, NewTo> mapResult(Function1<HashSet<A>, NewTo> f) {
        void var1_1;
        return Builder.mapResult$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Growable<A> $plus$eq(A elem) {
        void var1_1;
        return Growable.$plus$eq$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Growable<A> $plus$plus$eq(IterableOnce<A> elems) {
        void var1_1;
        return Growable.$plus$plus$eq$(this, (IterableOnce)var1_1);
    }

    private BitmapIndexedSetNode<A> newEmptyRootNode() {
        return new BitmapIndexedSetNode(0, 0, Array$.MODULE$.emptyObjectArray(), Array$.MODULE$.emptyIntArray(), 0, 0);
    }

    private HashSet<A> aliased() {
        return this.aliased;
    }

    /*
     * WARNING - void declaration
     */
    private void aliased_$eq(HashSet<A> x$1) {
        void var1_1;
        this.aliased = var1_1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public final BitmapIndexedSetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode;
    }

    /*
     * WARNING - void declaration
     */
    private void rootNode_$eq(BitmapIndexedSetNode<A> x$1) {
        void var1_1;
        this.scala$collection$immutable$HashSetBuilder$$rootNode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int[] insertElement(int[] as, int ix, int elem) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = var3_3;
        System.arraycopy(as, ix, result, ix + 1, ((void)var1_1).length - var2_2);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private <A1> void insertValue(BitmapIndexedSetNode<A> bm, int bitpos, A key, int originalHash, int keyHash) {
        void var1_1;
        void var3_3;
        void var2_2;
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        BitmapIndexedSetNode<A> bitmapIndexedSetNode = bm;
        bitmapIndexedSetNode.dataMap_$eq(bitmapIndexedSetNode.dataMap() | var2_2);
        bm.content_$eq(dst);
        bm.originalHashes_$eq((int[])var3_3);
        BitmapIndexedSetNode<A> bitmapIndexedSetNode2 = bm;
        bitmapIndexedSetNode2.size_$eq(bitmapIndexedSetNode2.size() + 1);
        void v2 = var1_1;
        v2.cachedJavaKeySetHashCode_$eq(v2.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    private <A1> void setValue(BitmapIndexedSetNode<A> bm, int bitpos, A elem) {
        void var3_3;
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        var1_1.content()[var2_2] = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(SetNode<A> setNode, A element, int originalHash, int elementHash, int shift) {
        void var1_1;
        void var2_2;
        if (setNode instanceof BitmapIndexedSetNode) {
            void var7_8;
            int element0UnimprovedHash;
            int index;
            setNode = (BitmapIndexedSetNode)setNode;
            int mask = elementHash >>> shift & 0x1F;
            int bitpos = 1 << mask;
            if ((((BitmapIndexedSetNode)setNode).dataMap() & bitpos) != 0) {
                index = Node$.MODULE$.indexFrom(((BitmapIndexedSetNode)setNode).dataMap(), mask, bitpos);
                Object element0 = ((BitmapIndexedSetNode)setNode).content()[index];
                element0UnimprovedHash = ((BitmapIndexedSetNode)setNode).originalHashes()[index];
                if (element0UnimprovedHash == originalHash && BoxesRunTime.equals(element0, element)) {
                    this.setValue((BitmapIndexedSetNode<A>)setNode, bitpos, (A)element0);
                    return;
                }
                int element0Hash = Hashing$.MODULE$.improve(element0UnimprovedHash);
                SetNode<Object> subNodeNew = ((BitmapIndexedSetNode)setNode).mergeTwoKeyValPairs(element0, element0UnimprovedHash, element0Hash, element, originalHash, elementHash, shift + 5);
                ((BitmapIndexedSetNode)setNode).migrateFromInlineToNodeInPlace(bitpos, element0Hash, var2_2);
                return;
            }
            if ((((BitmapIndexedSetNode)setNode).nodeMap() & bitpos) != 0) {
                index = Node$.MODULE$.indexFrom(((BitmapIndexedSetNode)setNode).nodeMap(), element0UnimprovedHash, bitpos);
                Node subNode = ((BitmapIndexedSetNode)setNode).getNode(index);
                int beforeSize = ((SetNode)subNode).size();
                int beforeHashCode = subNode.cachedJavaKeySetHashCode();
                this.update((SetNode<A>)subNode, var2_2, originalHash, elementHash, shift + 5);
                SetNode setNode2 = setNode;
                ((BitmapIndexedSetNode)setNode2).size_$eq(((BitmapIndexedSetNode)setNode2).size() + (((SetNode)subNode).size() - beforeSize));
                SetNode setNode3 = setNode;
                ((BitmapIndexedSetNode)setNode3).cachedJavaKeySetHashCode_$eq(((BitmapIndexedSetNode)setNode3).cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHashCode));
                return;
            }
            this.insertValue((BitmapIndexedSetNode<A>)setNode, (int)var7_8, var2_2, originalHash, elementHash);
            return;
        }
        if (setNode instanceof HashCollisionSetNode) {
            void var3_3;
            int index = ((HashCollisionSetNode)(setNode = (HashCollisionSetNode)setNode)).content().indexOf(var2_2);
            if (index < 0) {
                SetNode setNode4 = setNode;
                ((HashCollisionSetNode)setNode4).content_$eq(((HashCollisionSetNode)setNode4).content().appended((Object)var2_2));
                return;
            }
            SetNode setNode5 = setNode;
            ((HashCollisionSetNode)setNode5).content_$eq(((HashCollisionSetNode)setNode5).content().updated((int)var3_3, (Object)var2_2));
            return;
        }
        throw new MatchError(var1_1);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        HashSetBuilder hashSetBuilder = this;
        hashSetBuilder.rootNode_$eq((BitmapIndexedSetNode<A>)hashSetBuilder.scala$collection$immutable$HashSetBuilder$$rootNode().copy());
    }

    @Override
    public final HashSet<A> result() {
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashSet<A>(this.scala$collection$immutable$HashSetBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSetBuilder<A> addOne(A elem) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ensureUnaliased();
        int h = Statics.anyHash(elem);
        int im = Hashing$.MODULE$.improve(h);
        HashSetBuilder hashSetBuilder = this;
        hashSetBuilder.update(hashSetBuilder.scala$collection$immutable$HashSetBuilder$$rootNode(), var1_1, (int)var2_2, (int)var3_3, 0);
        return this;
    }

    @Override
    public final HashSetBuilder<A> addAll(IterableOnce<A> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashSet) {
            xs = xs;
            new ChampBaseIterator<A, SetNode<A>>(this, xs){

                public final Nothing$ next() {
                    return Iterator$.scala$collection$Iterator$$_empty.next();
                }
                {
                    while (this.hasNext()) {
                        void var2_3;
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        HashSetBuilder hashSetBuilder = $outer;
                        hashSetBuilder.update(hashSetBuilder.scala$collection$immutable$HashSetBuilder$$rootNode(), ((SetNode)this.currentValueNode()).getPayload(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve((int)var2_3), 0);
                        $anon$1 v1 = this;
                        v1.currentValueCursor_$eq(v1.currentValueCursor() + 1);
                    }
                }
            };
        } else {
            Iterator<A> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne((Object)it.next());
            }
        }
        return this;
    }

    @Override
    public final void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() > 0) {
            HashSetBuilder hashSetBuilder = this;
            hashSetBuilder.rootNode_$eq(hashSetBuilder.newEmptyRootNode());
            return;
        }
    }
}

