/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.FinishedParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.FinishedPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.FinishedSerializer;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySetGenerator;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FinishedHandler
extends HandshakeMessageHandler<FinishedMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public FinishedHandler(TlsContext context) {
        super(context);
    }

    @Override
    public FinishedParser getParser(byte[] message, int pointer) {
        return new FinishedParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public FinishedPreparator getPreparator(FinishedMessage message) {
        return new FinishedPreparator(this.tlsContext.getChooser(), message);
    }

    public FinishedSerializer getSerializer(FinishedMessage message) {
        return new FinishedSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(FinishedMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
            if (this.tlsContext.getTalkingConnectionEndType() != this.tlsContext.getChooser().getConnectionEndType()) {
                if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
                    this.adjustApplicationTrafficSecrets();
                    this.setServerRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
                } else {
                    this.setClientRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
                }
            } else if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT || !this.tlsContext.isExtensionNegotiated(ExtensionType.EARLY_DATA)) {
                this.setClientRecordCipher(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
            }
        }
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setLastClientVerifyData((byte[])message.getVerifyData().getValue());
        } else {
            this.tlsContext.setLastServerVerifyData((byte[])message.getVerifyData().getValue());
        }
    }

    private void adjustApplicationTrafficSecrets() {
        HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite());
        DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getChooser().getSelectedCipherSuite());
        try {
            int macLength = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName()).getMacLength();
            byte[] saltMasterSecret = HKDFunction.deriveSecret(hkdfAlgortihm, digestAlgo.getJavaName(), this.tlsContext.getChooser().getHandshakeSecret(), "derived", ArrayConverter.hexStringToByteArray((String)""));
            byte[] masterSecret = HKDFunction.extract(hkdfAlgortihm, saltMasterSecret, new byte[macLength]);
            byte[] clientApplicationTrafficSecret = HKDFunction.deriveSecret(hkdfAlgortihm, digestAlgo.getJavaName(), masterSecret, "c ap traffic", this.tlsContext.getDigest().getRawBytes());
            this.tlsContext.setClientApplicationTrafficSecret(clientApplicationTrafficSecret);
            LOGGER.debug("Set clientApplicationTrafficSecret in Context to " + ArrayConverter.bytesToHexString((byte[])clientApplicationTrafficSecret));
            byte[] serverApplicationTrafficSecret = HKDFunction.deriveSecret(hkdfAlgortihm, digestAlgo.getJavaName(), masterSecret, "s ap traffic", this.tlsContext.getDigest().getRawBytes());
            this.tlsContext.setServerApplicationTrafficSecret(serverApplicationTrafficSecret);
            LOGGER.debug("Set serverApplicationTrafficSecret in Context to " + ArrayConverter.bytesToHexString((byte[])serverApplicationTrafficSecret));
            this.tlsContext.setMasterSecret(masterSecret);
            LOGGER.debug("Set masterSecret in Context to " + ArrayConverter.bytesToHexString((byte[])masterSecret));
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new AdjustmentException(ex);
        }
    }

    @Override
    public void adjustTlsContextAfterSerialize(FinishedMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
            if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
                this.setClientRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
            } else {
                this.adjustApplicationTrafficSecrets();
                this.setServerRecordCipher(Tls13KeySetType.APPLICATION_TRAFFIC_SECRETS);
            }
        }
    }

    private KeySet getKeySet(TlsContext context, Tls13KeySetType keySetType) {
        try {
            LOGGER.debug("Generating new KeySet");
            KeySet keySet = KeySetGenerator.generateKeySet(context, context.getChooser().getSelectedProtocolVersion(), keySetType);
            return keySet;
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
    }

    private void setServerRecordCipher(Tls13KeySetType keySetType) {
        this.tlsContext.setActiveServerKeySetType(keySetType);
        LOGGER.debug("Setting cipher for server to use " + (Object)((Object)keySetType));
        KeySet serverKeySet = this.getKeySet(this.tlsContext, this.tlsContext.getActiveServerKeySetType());
        RecordCipher recordCipherServer = RecordCipherFactory.getRecordCipher(this.tlsContext, serverKeySet, this.tlsContext.getChooser().getSelectedCipherSuite());
        this.tlsContext.getRecordLayer().setRecordCipher(recordCipherServer);
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setReadSequenceNumber(0L);
            this.tlsContext.getRecordLayer().updateDecryptionCipher();
        } else {
            this.tlsContext.setWriteSequenceNumber(0L);
            this.tlsContext.getRecordLayer().updateEncryptionCipher();
        }
    }

    private void setClientRecordCipher(Tls13KeySetType keySetType) {
        this.tlsContext.setActiveClientKeySetType(keySetType);
        LOGGER.debug("Setting cipher for client to use " + (Object)((Object)keySetType));
        KeySet clientKeySet = this.getKeySet(this.tlsContext, this.tlsContext.getActiveClientKeySetType());
        RecordCipher recordCipherClient = RecordCipherFactory.getRecordCipher(this.tlsContext, clientKeySet, this.tlsContext.getChooser().getSelectedCipherSuite());
        this.tlsContext.getRecordLayer().setRecordCipher(recordCipherClient);
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
            this.tlsContext.setReadSequenceNumber(0L);
            this.tlsContext.getRecordLayer().updateDecryptionCipher();
        } else {
            this.tlsContext.setWriteSequenceNumber(0L);
            this.tlsContext.getRecordLayer().updateEncryptionCipher();
        }
    }
}

