/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geofence;

import java.util.Iterator;
import java.util.List;
import org.traccar.helper.DistanceCalculator;

public abstract class GeofenceGeometry {
    private Coordinate min;
    private Coordinate max;

    protected void setMin(Coordinate min) {
        this.min = min;
    }

    protected void setMax(Coordinate max) {
        this.max = max;
    }

    protected void calculateBoundary(List<Coordinate> coordinates, double padding) {
        Iterator<Coordinate> iterator = coordinates.iterator();
        Coordinate current = iterator.next();
        double minLat = current.lat();
        double minLon = current.lon();
        double maxLat = current.lat();
        double maxLon = current.lon();
        while (iterator.hasNext()) {
            current = iterator.next();
            minLat = Math.min(minLat, current.lat());
            minLon = Math.min(minLon, current.lon());
            maxLat = Math.max(maxLat, current.lat());
            maxLon = Math.max(maxLon, current.lon());
        }
        if (padding > 0.0) {
            double latPadding = DistanceCalculator.getLatitudeDelta(padding);
            double lonPadding = Math.max(DistanceCalculator.getLongitudeDelta(padding, minLat), DistanceCalculator.getLongitudeDelta(padding, maxLat));
            this.setMin(new Coordinate(minLat - latPadding, minLon - lonPadding));
            this.setMax(new Coordinate(maxLat + latPadding, maxLon + lonPadding));
        } else {
            this.setMin(new Coordinate(minLat, minLon));
            this.setMax(new Coordinate(maxLat, maxLon));
        }
    }

    public boolean containsPoint(double latitude, double longitude) {
        if (this.min.lon >= 0.0 || this.max.lon < 0.0) {
            if (latitude < this.min.lat || latitude > this.max.lat) {
                return false;
            }
            if (longitude < this.min.lon || longitude > this.max.lon) {
                return false;
            }
        }
        return this.containsPointInternal(latitude, longitude);
    }

    protected abstract boolean containsPointInternal(double var1, double var3);

    public abstract double calculateArea();

    public abstract String toWkt();

    public record Coordinate(double lat, double lon) {
    }
}

