/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig.keyinfo;

import java.math.BigInteger;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class X509IssuerSerialTest
extends TestCase {
    private KeyInfoFactory fac;
    private String name;

    public X509IssuerSerialTest() {
        super("X509IssuerSerialTest");
    }

    public X509IssuerSerialTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.fac = KeyInfoFactory.getInstance("DOM", new XMLDSigRI());
        this.name = "CN = Wolfgang";
    }

    public void tearDown() {
    }

    public void testgetIssuerName() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ZERO);
        X509IssuerSerialTest.assertNotNull((Object)x509IssuerSerial.getIssuerName());
    }

    public void testgetSerialNumber() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ZERO);
        X509IssuerSerialTest.assertNotNull((Object)x509IssuerSerial.getSerialNumber());
    }

    public void testConstructor() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ONE);
        X509IssuerSerialTest.assertEquals((String)this.name, (String)x509IssuerSerial.getIssuerName());
        X509IssuerSerialTest.assertEquals((Object)BigInteger.ONE, (Object)x509IssuerSerial.getSerialNumber());
    }

    public void testConstructorBadIssuerName() {
        String string = "cn=bad,=+bad,";
        try {
            this.fac.newX509IssuerSerial(string, BigInteger.ONE);
            X509IssuerSerialTest.fail((String)"Should raise an IllegalArgumentException when issuer distinguished name does not conform to RFC 2253");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testisFeatureSupported() {
        X509IssuerSerial x509IssuerSerial = this.fac.newX509IssuerSerial(this.name, BigInteger.ONE);
        try {
            x509IssuerSerial.isFeatureSupported(null);
            X509IssuerSerialTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        X509IssuerSerialTest.assertTrue((!x509IssuerSerial.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

