/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.HeartbeatMessageType;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected byte[] padding;

    public static HeartbeatMessage create(TlsContext tlsContext, short s2, byte[] byArray) {
        return HeartbeatMessage.create(tlsContext, s2, byArray, 16);
    }

    public static HeartbeatMessage create(TlsContext tlsContext, short s2, byte[] byArray, int n) {
        byte[] byArray2 = tlsContext.getNonceGenerator().generateNonce(n);
        return new HeartbeatMessage(s2, byArray, byArray2);
    }

    public HeartbeatMessage(short s2, byte[] byArray, byte[] byArray2) {
        if (!HeartbeatMessageType.isValid(s2)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (null == byArray || byArray.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (null == byArray2 || byArray2.length < 16) {
            throw new IllegalArgumentException("'padding' must have length >= 16");
        }
        this.type = s2;
        this.payload = byArray;
        this.padding = byArray2;
    }

    public int getPaddingLength() {
        return this.padding.length;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short getType() {
        return this.type;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.type, outputStream);
        TlsUtils.checkUint16(this.payload.length);
        TlsUtils.writeUint16(this.payload.length, outputStream);
        outputStream.write(this.payload);
        outputStream.write(this.padding);
    }

    public static HeartbeatMessage parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        if (!HeartbeatMessageType.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        int n = TlsUtils.readUint16(inputStream);
        PayloadBuffer payloadBuffer = new PayloadBuffer();
        Streams.pipeAll(inputStream, payloadBuffer);
        byte[] byArray = payloadBuffer.getPayload(n);
        if (null == byArray) {
            return null;
        }
        byte[] byArray2 = payloadBuffer.getPadding(n);
        return new HeartbeatMessage(s2, byArray, byArray2);
    }

    static class PayloadBuffer
    extends ByteArrayOutputStream {
        PayloadBuffer() {
        }

        byte[] getPayload(int n) {
            int n2 = this.count - 16;
            if (n > n2) {
                return null;
            }
            return Arrays.copyOf(this.buf, n);
        }

        byte[] getPadding(int n) {
            return TlsUtils.copyOfRangeExact(this.buf, n, this.count);
        }
    }
}

