/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) >> 0ul) => i64vec4(165l, 133l, 193l, 76l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 1ul) => i64vec4(82l, 66l, 96l, 38l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 2ul) => i64vec4(41l, 33l, 48l, 19l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 5ul) => i64vec4(5l, 4l, 6l, 2l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 25ul) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 31ul) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 32ul) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 47ul) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) >> 63ul) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 0ul) => i64vec4(80l, -15l, -51l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 1ul) => i64vec4(40l, -8l, -26l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 2ul) => i64vec4(20l, -4l, -13l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 5ul) => i64vec4(2l, -1l, -2l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 25ul) => i64vec4(0l, -1l, -1l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 31ul) => i64vec4(0l, -1l, -1l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 32ul) => i64vec4(0l, -1l, -1l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 47ul) => i64vec4(0l, -1l, -1l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) >> 63ul) => i64vec4(0l, -1l, -1l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 0ul), i64vec4(165l, 133l, 193l, 76l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 1ul), i64vec4(82l, 66l, 96l, 38l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 2ul), i64vec4(41l, 33l, 48l, 19l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 5ul), i64vec4(5l, 4l, 6l, 2l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 25ul), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 31ul), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 32ul), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 47ul), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) >> 63ul), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 0ul), i64vec4(80l, -15l, -51l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 1ul), i64vec4(40l, -8l, -26l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 2ul), i64vec4(20l, -4l, -13l, 0l))) ? 1 : -1] array11;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 5ul), i64vec4(2l, -1l, -2l, 0l))) ? 1 : -1] array12;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 25ul), i64vec4(0l, -1l, -1l, 0l))) ? 1 : -1] array13;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 31ul), i64vec4(0l, -1l, -1l, 0l))) ? 1 : -1] array14;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 32ul), i64vec4(0l, -1l, -1l, 0l))) ? 1 : -1] array15;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 47ul), i64vec4(0l, -1l, -1l, 0l))) ? 1 : -1] array16;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) >> 63ul), i64vec4(0l, -1l, -1l, 0l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
