/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jde.debugger.Debugger;
import jde.debugger.JDE;
import jde.debugger.Protocol;
import jde.debugger.gui.LocalVariableDisplay;
import jde.debugger.gui.ThreadDisplay;

public class GUI
implements Protocol {
    private final JFrame m_frame;
    private final JMenuBar m_menuBar;
    private final JMenu m_menuWindow;

    public GUI(Debugger debugger) {
        this.m_frame = new JFrame("JDEbug " + debugger.getProcID());
        this.m_frame.setDefaultCloseOperation(0);
        JDesktopPane desktop = new JDesktopPane();
        this.m_frame.setContentPane(desktop);
        this.m_menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(this.m_menuBar);
        this.m_menuWindow = new JMenu("Window");
        this.m_menuBar.add(this.m_menuWindow);
        this.addComponent("Local Variables", new LocalVariableDisplay(debugger));
        this.addComponent("Threads", new ThreadDisplay(debugger));
        ((Component)this.m_frame).setSize(350, 400);
        this.m_frame.show();
        JDE.debug(16, "GUI constructor done");
    }

    private void addComponent(String title, Component comp) {
        final JInternalFrame internalFrame = new JInternalFrame(title, true, false, true, true);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridLayout(0, 1));
        basePanel.add(comp);
        internalFrame.getContentPane().add(basePanel);
        internalFrame.pack();
        internalFrame.show();
        this.m_frame.getContentPane().add(internalFrame);
        int offset = 10 * this.m_frame.getContentPane().getComponentCount();
        internalFrame.setLocation(offset, offset);
        internalFrame.setSize(200, 300);
        JMenuItem menuItem = new JMenuItem(title);
        this.m_menuWindow.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    internalFrame.setIcon(false);
                    internalFrame.toFront();
                }
                catch (PropertyVetoException exc) {
                    JDE.signalException(exc);
                }
            }
        });
    }

    public synchronized void shutdown() {
        if (null != this.m_frame) {
            this.m_frame.dispose();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }
}

