untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N931nsM8gxVkesD0Os49u5oCTJ0X5MyjbYDS4pF7vHCqf+071xhh1w3GpCw80WKj0H7+gsw6GMJ069rh3VaNADKAo=

OpenBSD 5.5 errata 4, Apr 12, 2014:  A use-after-free race condition
in OpenSSL's read buffer may permit an attacker to inject data from
one connection into another.

The advice in the previous OpenSSL errata also applies.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 004_openssl.patch.sig \
	-m - | (cd /usr/src && patch -p0)

Then build and install libssl

    cd /usr/src/lib/libssl/ssl
    make obj
    make
    make install

Also recompile any statically-linked binaries depending on it - in
the base OS, this is just ftp(1):

    cd /usr/src/usr.bin/ftp
    make obj
    make clean
    make
    make install

Then restart services which depend on SSL.

Index: lib/libssl/src/ssl/s3_pkt.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/ssl/s3_pkt.c,v
retrieving revision 1.20
retrieving revision 1.20.4.1
diff -u -p -u -r1.20 -r1.20.4.1
--- lib/libssl/src/ssl/s3_pkt.c	27 Feb 2014 21:04:57 -0000	1.20
+++ lib/libssl/src/ssl/s3_pkt.c	12 Apr 2014 17:01:14 -0000	1.20.4.1
@@ -1054,7 +1054,7 @@ start:
 				{
 				s->rstate=SSL_ST_READ_HEADER;
 				rr->off=0;
-				if (s->mode & SSL_MODE_RELEASE_BUFFERS)
+				if (s->mode & SSL_MODE_RELEASE_BUFFERS && s->s3->rbuf.left == 0)
 					ssl3_release_read_buffer(s);
 				}
 			}
