untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ4XKs9hiELd5Eg2hRuepMQFJrxI+lLvu6pDD5yYq3YIvfJ0bAjrCIK5ZBC8e++zT874bqW+nYfUP7DmLlFWbDgQ=

OpenBSD 6.0 errata 036, August 3, 2017:

An uninitialized variable in sys_fcntl() may result in an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 036_fcntl.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/kern_descrip.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_descrip.c,v
--- sys/kern/kern_descrip.c	29 May 2016 13:51:53 -0000	1.132
+++ sys/kern/kern_descrip.c	2 Aug 2017 16:28:32 -0000
@@ -435,6 +435,7 @@ restart:
 			*retval = ((struct pipe *)fp->f_data)->pipe_pgid;
 			break;
 		}
+		tmp = 0;
 		error = (*fp->f_ops->fo_ioctl)
 			(fp, TIOCGPGRP, (caddr_t)&tmp, p);
 		*retval = -tmp;
