require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_TCIC2REG_H)) {
    eval 'sub _TCIC2REG_H () {1;}' unless defined(&_TCIC2REG_H);
    eval 'sub TCIC_IOSIZE () {16;}' unless defined(&TCIC_IOSIZE);
    eval 'sub TCIC_R_DATA () {0;}' unless defined(&TCIC_R_DATA);
    eval 'sub TCIC_R_ADDR () {2;}' unless defined(&TCIC_R_ADDR);
    eval 'sub TCIC_R_ADDR2 () {( &TCIC_R_ADDR+2);}' unless defined(&TCIC_R_ADDR2);
    eval 'sub TCIC_R_SCTRL () {6;}' unless defined(&TCIC_R_SCTRL);
    eval 'sub TCIC_R_SSTAT () {7;}' unless defined(&TCIC_R_SSTAT);
    eval 'sub TCIC_R_MODE () {8;}' unless defined(&TCIC_R_MODE);
    eval 'sub TCIC_R_PWR () {9;}' unless defined(&TCIC_R_PWR);
    eval 'sub TCIC_R_EDC () {0xa;}' unless defined(&TCIC_R_EDC);
    eval 'sub TCIC_R_ICSR () {0xc;}' unless defined(&TCIC_R_ICSR);
    eval 'sub TCIC_R_IENA () {0xd;}' unless defined(&TCIC_R_IENA);
    eval 'sub TCIC_R_AUX () {0xe;}' unless defined(&TCIC_R_AUX);
    eval 'sub TCIC_AR_MASK () {0xe0;}' unless defined(&TCIC_AR_MASK);
    eval 'sub TCIC_AR_TCTL () {0x;}' unless defined(&TCIC_AR_TCTL);
    eval 'sub TCIC_AR_PCTL () {0x20;}' unless defined(&TCIC_AR_PCTL);
    eval 'sub TCIC_AR_WCTL () {0x40;}' unless defined(&TCIC_AR_WCTL);
    eval 'sub TCIC_AR_EXTERN () {0x60;}' unless defined(&TCIC_AR_EXTERN);
    eval 'sub TCIC_AR_PDATA () {0x80;}' unless defined(&TCIC_AR_PDATA);
    eval 'sub TCIC_AR_SYSCFG () {0xa0;}' unless defined(&TCIC_AR_SYSCFG);
    eval 'sub TCIC_AR_ILOCK () {0xc0;}' unless defined(&TCIC_AR_ILOCK);
    eval 'sub TCIC_AR_TEST () {0xe0;}' unless defined(&TCIC_AR_TEST);
    eval 'sub TCIC_WR_MEM_BASE () {0x100;}' unless defined(&TCIC_WR_MEM_BASE);
    eval 'sub TCIC_WR_MEM_SHFT () {3;}' unless defined(&TCIC_WR_MEM_SHFT);
    eval 'sub TCIC_WR_MEXT_N {
        my($n) = @_;
	    eval q((( &TCIC_WR_MEM_BASE+(($n)<< &TCIC_WR_MEM_SHFT))+0));
    }' unless defined(&TCIC_WR_MEXT_N);
    eval 'sub TCIC_WR_MBASE_N {
        my($n) = @_;
	    eval q((( &TCIC_WR_MEM_BASE+(($n)<< &TCIC_WR_MEM_SHFT))+2));
    }' unless defined(&TCIC_WR_MBASE_N);
    eval 'sub TCIC_WR_MMAP_N {
        my($n) = @_;
	    eval q((( &TCIC_WR_MEM_BASE+(($n)<< &TCIC_WR_MEM_SHFT))+4));
    }' unless defined(&TCIC_WR_MMAP_N);
    eval 'sub TCIC_WR_MCTL_N {
        my($n) = @_;
	    eval q((( &TCIC_WR_MEM_BASE+(($n)<< &TCIC_WR_MEM_SHFT))+6));
    }' unless defined(&TCIC_WR_MCTL_N);
    eval 'sub TCIC_WR_IO_BASE () {0x200;}' unless defined(&TCIC_WR_IO_BASE);
    eval 'sub TCIC_WR_IO_SHFT () {2;}' unless defined(&TCIC_WR_IO_SHFT);
    eval 'sub TCIC_WR_IBASE_N {
        my($n) = @_;
	    eval q((( &TCIC_WR_IO_BASE+(($n)<< &TCIC_WR_IO_SHFT))+0));
    }' unless defined(&TCIC_WR_IBASE_N);
    eval 'sub TCIC_WR_ICTL_N {
        my($n) = @_;
	    eval q((( &TCIC_WR_IO_BASE+(($n)<< &TCIC_WR_IO_SHFT))+2));
    }' unless defined(&TCIC_WR_ICTL_N);
    eval 'sub TCIC_IR_SCF_BASE () {0;}' unless defined(&TCIC_IR_SCF_BASE);
    eval 'sub TCIC_IR_SCF_SHFT () {3;}' unless defined(&TCIC_IR_SCF_SHFT);
    eval 'sub TCIC_IR_SCF1_N {
        my($n) = @_;
	    eval q((( &TCIC_IR_SCF_BASE+(($n)<< &TCIC_IR_SCF_SHFT))+0));
    }' unless defined(&TCIC_IR_SCF1_N);
    eval 'sub TCIC_IR_SCF2_N {
        my($n) = @_;
	    eval q((( &TCIC_IR_SCF_BASE+(($n)<< &TCIC_IR_SCF_SHFT))+2));
    }' unless defined(&TCIC_IR_SCF2_N);
    eval 'sub TCIC_SS_SHIFT () {12;}' unless defined(&TCIC_SS_SHIFT);
    eval 'sub TCIC_SS_MASK () {(7<<( &TCIC_SS_SHIFT));}' unless defined(&TCIC_SS_MASK);
    eval 'sub TCIC_ADDR2_REG () {(1<< 15);}' unless defined(&TCIC_ADDR2_REG);
    eval 'sub TCIC_ADDR2_SS_SHFT () { &TCIC_SS_SHIFT;}' unless defined(&TCIC_ADDR2_SS_SHFT);
    eval 'sub TCIC_ADDR2_SS_MASK () { &TCIC_SS_MASK;}' unless defined(&TCIC_ADDR2_SS_MASK);
    eval 'sub TCIC_ADDR2_INDREG () {(1<< 11);}' unless defined(&TCIC_ADDR2_INDREG);
    eval 'sub TCIC_ADDR2_IO () {(1<< 10);}' unless defined(&TCIC_ADDR2_IO);
    eval 'sub TCIC_ADDR_REG () {( &u_int32_t)  &TCIC_ADDR2_REG << 16);}' unless defined(&TCIC_ADDR_REG);
    eval 'sub TCIC_ADDR_SS_SHFT () {(( &u_int32_t)  &TCIC_ADDR2_SS_SHFT + 16);}' unless defined(&TCIC_ADDR_SS_SHFT);
    eval 'sub TCIC_ADDR_SS_MASK () {(( &u_int32_t)  &TCIC_ADDR2_SS_MASK << 16);}' unless defined(&TCIC_ADDR_SS_MASK);
    eval 'sub TCIC_ADDR_INDREG () {(( &u_int32_t)  &TCIC_ADDR2_INDREG << 16);}' unless defined(&TCIC_ADDR_INDREG);
    eval 'sub TCIC_ADDR_IO () {(( &u_int32_t)  &TCIC_ADDR2_IO << 16);}' unless defined(&TCIC_ADDR_IO);
    eval 'sub TCIC_ADDR_SPACE_SIZE () {(( &u_int32_t) 1<< 26);}' unless defined(&TCIC_ADDR_SPACE_SIZE);
    eval 'sub TCIC_ADDR_MASK () {( &ADDR_SPACE_SIZE - 1);}' unless defined(&TCIC_ADDR_MASK);
    eval 'sub TCIC_ADDR_DIAG_NREG () {(( &u_int32_t) 1 << 31);}' unless defined(&TCIC_ADDR_DIAG_NREG);
    eval 'sub TCIC_ADDR_DIAG_NCEH () {(( &u_int32_t) 1 << 30);}' unless defined(&TCIC_ADDR_DIAG_NCEH);
    eval 'sub TCIC_ADDR_DIAG_NCEL () {(( &u_int32_t) 1 << 29);}' unless defined(&TCIC_ADDR_DIAG_NCEL);
    eval 'sub TCIC_ADDR_DIAG_NCWR () {(( &u_int32_t) 1 << 28);}' unless defined(&TCIC_ADDR_DIAG_NCWR);
    eval 'sub TCIC_ADDR_DIAG_NCRD () {(( &u_int32_t) 1 << 27);}' unless defined(&TCIC_ADDR_DIAG_NCRD);
    eval 'sub TCIC_ADDR_DIAG_CRESET () {(( &u_int32_t) 1 << 26);}' unless defined(&TCIC_ADDR_DIAG_CRESET);
    eval 'sub TCIC_SCTRL_ENA () {(1<< 0);}' unless defined(&TCIC_SCTRL_ENA);
    eval 'sub TCIC_SCTRL_INCMODE () {(3<< 3);}' unless defined(&TCIC_SCTRL_INCMODE);
    eval 'sub TCIC_SCTRL_INCMODE_AUTO () {(3<< 3);}' unless defined(&TCIC_SCTRL_INCMODE_AUTO);
    eval 'sub TCIC_SCTRL_INCMODE_HOLD () {(0<< 3);}' unless defined(&TCIC_SCTRL_INCMODE_HOLD);
    eval 'sub TCIC_SCTRL_INCMODE_WORD () {(1<< 3);}' unless defined(&TCIC_SCTRL_INCMODE_WORD);
    eval 'sub TCIC_SCTRL_INCMODE_REG () {(2<< 3);}' unless defined(&TCIC_SCTRL_INCMODE_REG);
    eval 'sub TCIC_SCTRL_EDCSUM () {(1<< 5);}' unless defined(&TCIC_SCTRL_EDCSUM);
    eval 'sub TCIC_SCTRL_RESET () {(1<< 7);}' unless defined(&TCIC_SCTRL_RESET);
    eval 'sub TCIC_SCTRL_RSVD () {0x46;}' unless defined(&TCIC_SCTRL_RSVD);
    eval 'sub TCIC_SSTAT_6US () {(1<<0);}' unless defined(&TCIC_SSTAT_6US);
    eval 'sub TCIC_SSTAT_10US () {(1<<1);}' unless defined(&TCIC_SSTAT_10US);
    eval 'sub TCIC_SSTAT_PROGTIME () {(1<<2);}' unless defined(&TCIC_SSTAT_PROGTIME);
    eval 'sub TCIC_SSTAT_LBAT1 () {(1<<3);}' unless defined(&TCIC_SSTAT_LBAT1);
    eval 'sub TCIC_SSTAT_LBAT2 () {(1<<4);}' unless defined(&TCIC_SSTAT_LBAT2);
    eval 'sub TCIC_SSTAT_BATOK () {(0<<3);}' unless defined(&TCIC_SSTAT_BATOK);
    eval 'sub TCIC_SSTAT_BATBAD1 () {(1<<3);}' unless defined(&TCIC_SSTAT_BATBAD1);
    eval 'sub TCIC_SSTAT_BATLO () {(2<<3);}' unless defined(&TCIC_SSTAT_BATLO);
    eval 'sub TCIC_SSTAT_BATBAD2 () {(3<<3);}' unless defined(&TCIC_SSTAT_BATBAD2);
    eval 'sub TCIC_SSTAT_RDY () {(1<<5);}' unless defined(&TCIC_SSTAT_RDY);
    eval 'sub TCIC_SSTAT_WP () {(1<<6);}' unless defined(&TCIC_SSTAT_WP);
    eval 'sub TCIC_SSTAT_CD () {(1<<7);}' unless defined(&TCIC_SSTAT_CD);
    eval 'sub TCIC_SSTAT_STAT_MASK () {0xf8;}' unless defined(&TCIC_SSTAT_STAT_MASK);
    eval 'sub TCIC_MODE_PGMMASK () {(0x1f);}' unless defined(&TCIC_MODE_PGMMASK);
    eval 'sub TCIC_MODE_NORMAL () {(0);}' unless defined(&TCIC_MODE_NORMAL);
    eval 'sub TCIC_MODE_PGMWR () {(1<< 0);}' unless defined(&TCIC_MODE_PGMWR);
    eval 'sub TCIC_MODE_PGMRD () {(1<< 1);}' unless defined(&TCIC_MODE_PGMRD);
    eval 'sub TCIC_MODE_PGMCE () {(1<< 2);}' unless defined(&TCIC_MODE_PGMCE);
    eval 'sub TCIC_MODE_PGMDBW () {(1<< 3);}' unless defined(&TCIC_MODE_PGMDBW);
    eval 'sub TCIC_MODE_PGMWORD () {(1<< 4);}' unless defined(&TCIC_MODE_PGMWORD);
    eval 'sub TCIC_PWR_VCC_SHFT () {(0);}' unless defined(&TCIC_PWR_VCC_SHFT);
    eval 'sub TCIC_PWR_VCC_MASK () {(3<<  &TCIC_PWR_VCC_SHFT);}' unless defined(&TCIC_PWR_VCC_MASK);
    eval 'sub TCIC_PWR_VPP_SHFT () {(3);}' unless defined(&TCIC_PWR_VPP_SHFT);
    eval 'sub TCIC_PWR_VPP_MASK () {(3<<  &TCIC_PWR_VPP_SHFT);}' unless defined(&TCIC_PWR_VPP_MASK);
    eval 'sub TCIC_PWR_ENA () {(1<< 5);}' unless defined(&TCIC_PWR_ENA);
    eval 'sub TCIC_PWR_VCC5V () {(1<< 2);}' unless defined(&TCIC_PWR_VCC5V);
    if(0) {
	eval 'sub TCIC_PWR_VOFF_POFF () {(0);}' unless defined(&TCIC_PWR_VOFF_POFF);
	eval 'sub TCIC_PWR_VON_PVCC () {(1);}' unless defined(&TCIC_PWR_VON_PVCC);
	eval 'sub TCIC_PWR_VON_PVPP () {(2);}' unless defined(&TCIC_PWR_VON_PVPP);
	eval 'sub TCIC_PWR_VON_POFF () {(3);}' unless defined(&TCIC_PWR_VON_POFF);
    }
    eval 'sub TCIC_PWR_VCC_N {
        my($n) = @_;
	    eval q((1<<(($n))));
    }' unless defined(&TCIC_PWR_VCC_N);
    eval 'sub TCIC_PWR_VPP_N {
        my($n) = @_;
	    eval q((1<<(3+($n))));
    }' unless defined(&TCIC_PWR_VPP_N);
    eval 'sub TCIC_PWR_CLIMENA () {(1<< 6);}' unless defined(&TCIC_PWR_CLIMENA);
    eval 'sub TCIC_PWR_CLIMSTAT () {(1<< 7);}' unless defined(&TCIC_PWR_CLIMSTAT);
    eval 'sub TCIC_ICSR_IOCHK () {(1<<7);}' unless defined(&TCIC_ICSR_IOCHK);
    eval 'sub TCIC_ICSR_CDCHG () {(1<<6);}' unless defined(&TCIC_ICSR_CDCHG);
    eval 'sub TCIC_ICSR_ERR () {(1<<5);}' unless defined(&TCIC_ICSR_ERR);
    eval 'sub TCIC_ICSR_PROGTIME () {(1<<4);}' unless defined(&TCIC_ICSR_PROGTIME);
    eval 'sub TCIC_ICSR_ILOCK () {(1<<3);}' unless defined(&TCIC_ICSR_ILOCK);
    eval 'sub TCIC_ICSR_STOPCPU () {(1<<2);}' unless defined(&TCIC_ICSR_STOPCPU);
    eval 'sub TCIC_ICSR_SET () {(1<<1);}' unless defined(&TCIC_ICSR_SET);
    eval 'sub TCIC_ICSR_CLEAR () {(1<<0);}' unless defined(&TCIC_ICSR_CLEAR);
    eval 'sub TCIC_ICSR_JAM () {( &TCIC_ICSR_SET| &TCIC_ICSR_CLEAR);}' unless defined(&TCIC_ICSR_JAM);
    eval 'sub TCIC_IENA_CDCHG () {(1<< 6);}' unless defined(&TCIC_IENA_CDCHG);
    eval 'sub TCIC_IENA_ERR () {(1<< 5);}' unless defined(&TCIC_IENA_ERR);
    eval 'sub TCIC_IENA_PROGTIME () {(1<< 4);}' unless defined(&TCIC_IENA_PROGTIME);
    eval 'sub TCIC_IENA_ILOCK () {(1<< 3);}' unless defined(&TCIC_IENA_ILOCK);
    eval 'sub TCIC_IENA_CFG_MASK () {(3<< 0);}' unless defined(&TCIC_IENA_CFG_MASK);
    eval 'sub TCIC_IENA_CFG_OFF () {(0<< 0);}' unless defined(&TCIC_IENA_CFG_OFF);
    eval 'sub TCIC_IENA_CFG_OD () {(1<< 0);}' unless defined(&TCIC_IENA_CFG_OD);
    eval 'sub TCIC_IENA_CFG_LOW () {(2<< 0);}' unless defined(&TCIC_IENA_CFG_LOW);
    eval 'sub TCIC_IENA_CFG_HIGH () {(3<< 0);}' unless defined(&TCIC_IENA_CFG_HIGH);
    eval 'sub TCIC_IENA_RSVD () {0x84;}' unless defined(&TCIC_IENA_RSVD);
    eval 'sub TCIC_TCTL_6US_SHFT () {(0);}' unless defined(&TCIC_TCTL_6US_SHFT);
    eval 'sub TCIC_TCTL_10US_SHFT () {(8);}' unless defined(&TCIC_TCTL_10US_SHFT);
    eval 'sub TCIC_TCTL_6US_MASK () {(0xff <<  &TCIC_TCTL_6US_SHFT);}' unless defined(&TCIC_TCTL_6US_MASK);
    eval 'sub TCIC_TCTL_10US_MASK () {(0xff <<  &TCIC_TCTL_10US_SHFT);}' unless defined(&TCIC_TCTL_10US_MASK);
    eval 'sub TCIC_R_TCTL_6US () {( &TCIC_R_AUX + 0);}' unless defined(&TCIC_R_TCTL_6US);
    eval 'sub TCIC_R_TCTL_10US () {( &TCIC_R_AUX + 1);}' unless defined(&TCIC_R_TCTL_10US);
    eval 'sub TCIC_R_PULSE_LO () {( &TCIC_R_AUX + 0);}' unless defined(&TCIC_R_PULSE_LO);
    eval 'sub TCIC_R_PULSE_HI () {( &TCIC_R_AUX + 1);}' unless defined(&TCIC_R_PULSE_HI);
    eval 'sub TCIC_WAIT_COUNT_MASK () {(0x1f);}' unless defined(&TCIC_WAIT_COUNT_MASK);
    eval 'sub TCIC_WAIT_COUNT_SHFT () {(0);}' unless defined(&TCIC_WAIT_COUNT_SHFT);
    eval 'sub TCIC_WAIT_SYNC () {(1<< 5);}' unless defined(&TCIC_WAIT_SYNC);
    eval 'sub TCIC_WAIT_ASYNC () {(0);}' unless defined(&TCIC_WAIT_ASYNC);
    eval 'sub TCIC_WAIT_SENSE () {(1<< 6);}' unless defined(&TCIC_WAIT_SENSE);
    eval 'sub TCIC_WAIT_SRC () {(1<< 7);}' unless defined(&TCIC_WAIT_SRC);
    eval 'sub TCIC_WAIT_BCLK () {(1*  &TCIC_WAIT_SRC);}' unless defined(&TCIC_WAIT_BCLK);
    eval 'sub TCIC_WAIT_CCLK () {(0*  &TCIC_WAIT_SRC);}' unless defined(&TCIC_WAIT_CCLK);
    eval 'sub TCIC_WAIT_RISING () {(1*  &TCIC_WAIT_SENSE);}' unless defined(&TCIC_WAIT_RISING);
    eval 'sub TCIC_WAIT_FALLING () {(0*  &TCIC_WAIT_SENSE);}' unless defined(&TCIC_WAIT_FALLING);
    eval 'sub TCIC_WCTL_WR () {(1<< 8);}' unless defined(&TCIC_WCTL_WR);
    eval 'sub TCIC_WCTL_RD () {(1<< 9);}' unless defined(&TCIC_WCTL_RD);
    eval 'sub TCIC_WCTL_CE () {(1<< 10);}' unless defined(&TCIC_WCTL_CE);
    eval 'sub TCIC_WCTL_LLBAT1 () {(1<< 11);}' unless defined(&TCIC_WCTL_LLBAT1);
    eval 'sub TCIC_WCTL_LLBAT2 () {(1<< 12);}' unless defined(&TCIC_WCTL_LLBAT2);
    eval 'sub TCIC_WCTL_LRDY () {(1<< 13);}' unless defined(&TCIC_WCTL_LRDY);
    eval 'sub TCIC_WCTL_LWP () {(1<< 14);}' unless defined(&TCIC_WCTL_LWP);
    eval 'sub TCIC_WCTL_LCD () {(1<< 15);}' unless defined(&TCIC_WCTL_LCD);
    eval 'sub TCIC_R_WCTL_WAIT () {( &TCIC_R_AUX + 0);}' unless defined(&TCIC_R_WCTL_WAIT);
    eval 'sub TCIC_R_WCTL_XCSR () {( &TCIC_R_AUX + 1);}' unless defined(&TCIC_R_WCTL_XCSR);
    eval 'sub TCIC_XCSR_WR () {(1<< 0);}' unless defined(&TCIC_XCSR_WR);
    eval 'sub TCIC_XCSR_RD () {(1<< 1);}' unless defined(&TCIC_XCSR_RD);
    eval 'sub TCIC_XCSR_CE () {(1<< 2);}' unless defined(&TCIC_XCSR_CE);
    eval 'sub TCIC_XCSR_LLBAT1 () {(1<< 3);}' unless defined(&TCIC_XCSR_LLBAT1);
    eval 'sub TCIC_XCSR_LLBAT2 () {(1<< 4);}' unless defined(&TCIC_XCSR_LLBAT2);
    eval 'sub TCIC_XCSR_LRDY () {(1<< 5);}' unless defined(&TCIC_XCSR_LRDY);
    eval 'sub TCIC_XCSR_LWP () {(1<< 6);}' unless defined(&TCIC_XCSR_LWP);
    eval 'sub TCIC_XCSR_LCD () {(1<< 7);}' unless defined(&TCIC_XCSR_LCD);
    eval 'sub TCIC_XCSR_STAT_MASK () {0xf8;}' unless defined(&TCIC_XCSR_STAT_MASK);
    eval 'sub TCIC_R_PDATA_LO () {( &TCIC_R_AUX + 0);}' unless defined(&TCIC_R_PDATA_LO);
    eval 'sub TCIC_R_PDATA_HI () {( &TCIC_R_AUX + 1);}' unless defined(&TCIC_R_PDATA_HI);
    eval 'sub TCIC_SYSCFG_IRQ_MASK () {(0xf);}' unless defined(&TCIC_SYSCFG_IRQ_MASK);
    eval 'sub TCIC_SYSCFG_SSIRQDFLT () {(0);}' unless defined(&TCIC_SYSCFG_SSIRQDFLT);
    eval 'sub TCIC_SYSCFG_SSIRQ () {(0x1);}' unless defined(&TCIC_SYSCFG_SSIRQ);
    eval 'sub TCIC_SYSCFG_SIRQ3 () {(0x3);}' unless defined(&TCIC_SYSCFG_SIRQ3);
    eval 'sub TCIC_SYSCFG_SIRQ4 () {(0x4);}' unless defined(&TCIC_SYSCFG_SIRQ4);
    eval 'sub TCIC_SYSCFG_SIRQ5 () {(0x5);}' unless defined(&TCIC_SYSCFG_SIRQ5);
    eval 'sub TCIC_SYSCFG_SIRQ6 () {(0x6);}' unless defined(&TCIC_SYSCFG_SIRQ6);
    eval 'sub TCIC_SYSCFG_SIRQ7 () {(0x7);}' unless defined(&TCIC_SYSCFG_SIRQ7);
    eval 'sub TCIC_SYSCFG_SIRQ10 () {(0xa);}' unless defined(&TCIC_SYSCFG_SIRQ10);
    eval 'sub TCIC_SYSCFG_SIRQ14 () {(0xe);}' unless defined(&TCIC_SYSCFG_SIRQ14);
    eval 'sub TCIC_SYSCFG_MCSFULL () {(1<< 4);}' unless defined(&TCIC_SYSCFG_MCSFULL);
    eval 'sub TCIC_SYSCFG_IO1723 () {(1<< 5);}' unless defined(&TCIC_SYSCFG_IO1723);
    eval 'sub TCIC_SYSCFG_MCSXB () {(1<< 6);}' unless defined(&TCIC_SYSCFG_MCSXB);
    eval 'sub TCIC_SYSCFG_ICSXB () {(1<< 7);}' unless defined(&TCIC_SYSCFG_ICSXB);
    eval 'sub TCIC_SYSCFG_NOPDN () {(1<< 8);}' unless defined(&TCIC_SYSCFG_NOPDN);
    eval 'sub TCIC_SYSCFG_MPSEL_SHFT () {(9);}' unless defined(&TCIC_SYSCFG_MPSEL_SHFT);
    eval 'sub TCIC_SYSCFG_MPSEL_MASK () {(7<< 9);}' unless defined(&TCIC_SYSCFG_MPSEL_MASK);
    eval 'sub TCIC_SYSCFG_MPSEL_OFF () {(0<<  &TCIC_SYSCFG_MPSEL_SHFT);}' unless defined(&TCIC_SYSCFG_MPSEL_OFF);
    eval 'sub TCIC_SYSCFG_MPSEL_NEEDCLK () {(1<<  &TCIC_SYSCFG_MPSEL_SHFT);}' unless defined(&TCIC_SYSCFG_MPSEL_NEEDCLK);
    eval 'sub TCIC_SYSCFG_MPSEL_MIO () {(2<<  &TCIC_SYSCFG_MPSEL_SHFT);}' unless defined(&TCIC_SYSCFG_MPSEL_MIO);
    eval 'sub TCIC_SYSCFG_MPSEL_EXTSEL () {(3<<  &TCIC_SYSCFG_MPSEL_SHFT);}' unless defined(&TCIC_SYSCFG_MPSEL_EXTSEL);
    eval 'sub TCIC_SYSCFG_MPSEL_RI () {(5<<  &TCIC_SYSCFG_MPSEL_SHFT);}' unless defined(&TCIC_SYSCFG_MPSEL_RI);
    eval 'sub TCIC_SYSCFG_MPSENSE () {(1<< 13);}' unless defined(&TCIC_SYSCFG_MPSENSE);
    eval 'sub TCIC_SYSCFG_AUTOBUSY () {(1<< 14);}' unless defined(&TCIC_SYSCFG_AUTOBUSY);
    eval 'sub TCIC_SYSCFG_ACC () {(1<<15);}' unless defined(&TCIC_SYSCFG_ACC);
    eval 'sub TCIC_ILOCK_OUT () {(1<< 0);}' unless defined(&TCIC_ILOCK_OUT);
    eval 'sub TCIC_ILOCK_SENSE () {(1<< 1);}' unless defined(&TCIC_ILOCK_SENSE);
    eval 'sub TCIC_ILOCK_CRESET () {(1<< 2);}' unless defined(&TCIC_ILOCK_CRESET);
    eval 'sub TCIC_ILOCK_CRESENA () {(1<< 3);}' unless defined(&TCIC_ILOCK_CRESENA);
    eval 'sub TCIC_ILOCK_CWAIT () {(1<< 4);}' unless defined(&TCIC_ILOCK_CWAIT);
    eval 'sub TCIC_ILOCK_CWAITSNS () {(1<< 5);}' unless defined(&TCIC_ILOCK_CWAITSNS);
    eval 'sub TCIC_ILOCK_HOLD_SHIFT () {6;}' unless defined(&TCIC_ILOCK_HOLD_SHIFT);
    eval 'sub TCIC_ILOCK_HOLD_MASK () {(3<<  &TCIC_ILOCK_HOLD_SHIFT);}' unless defined(&TCIC_ILOCK_HOLD_MASK);
    eval 'sub TCIC_ILOCK_HOLD_QUICK () {(0<<  &TCIC_ILOCK_HOLD_SHIFT);}' unless defined(&TCIC_ILOCK_HOLD_QUICK);
    eval 'sub TCIC_ILOCK_HOLD_CCLK () {(3<<  &TCIC_ILOCK_HOLD_SHIFT);}' unless defined(&TCIC_ILOCK_HOLD_CCLK);
    eval 'sub TCIC_ILOCK_INPACK () {(1<< 11);}' unless defined(&TCIC_ILOCK_INPACK);
    eval 'sub TCIC_ILOCK_CP0 () {(1<< 12);}' unless defined(&TCIC_ILOCK_CP0);
    eval 'sub TCIC_ILOCK_CP1 () {(1<< 13);}' unless defined(&TCIC_ILOCK_CP1);
    eval 'sub TCIC_ILOCK_VS1 () {(1<< 14);}' unless defined(&TCIC_ILOCK_VS1);
    eval 'sub TCIC_ILOCK_VS2 () {(1<< 15);}' unless defined(&TCIC_ILOCK_VS2);
    eval 'sub TCIC_CHIPID_DB86082_1 () {(0x2);}' unless defined(&TCIC_CHIPID_DB86082_1);
    eval 'sub TCIC_CHIPID_DB86082A () {(0x3);}' unless defined(&TCIC_CHIPID_DB86082A);
    eval 'sub TCIC_CHIPID_DB86082B_ES () {(0x7);}' unless defined(&TCIC_CHIPID_DB86082B_ES);
    eval 'sub TCIC_CHIPID_DB86082B () {(0x17);}' unless defined(&TCIC_CHIPID_DB86082B);
    eval 'sub TCIC_CHIPID_DB86084_1 () {(0x4);}' unless defined(&TCIC_CHIPID_DB86084_1);
    eval 'sub TCIC_CHIPID_DB86084A () {(0x8);}' unless defined(&TCIC_CHIPID_DB86084A);
    eval 'sub TCIC_CHIPID_DB86184_1 () {(0x14);}' unless defined(&TCIC_CHIPID_DB86184_1);
    eval 'sub TCIC_CHIPID_DB86072_1_ES () {(0x5);}' unless defined(&TCIC_CHIPID_DB86072_1_ES);
    eval 'sub TCIC_CHIPID_DB86072_1 () {(0x15);}' unless defined(&TCIC_CHIPID_DB86072_1);
    eval 'sub TCIC_R_ILOCK_ID () {( &TCIC_R_AUX + 1);}' unless defined(&TCIC_R_ILOCK_ID);
    eval 'sub TCIC_ILOCKTEST_ID_SHFT () {8;}' unless defined(&TCIC_ILOCKTEST_ID_SHFT);
    eval 'sub TCIC_ILOCKTEST_ID_MASK () {(0x7f <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_ID_MASK);
    eval 'sub TCIC_ILOCKTEST_TCIC2N_1 () {(( &TCIC_CHIPID_DB86082_1) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_TCIC2N_1);
    eval 'sub TCIC_ILOCKTEST_DB86082_1 () { &TCIC_ILOCKTEST_TCIC2N_1;}' unless defined(&TCIC_ILOCKTEST_DB86082_1);
    eval 'sub TCIC_ILOCKTEST_TCIC2N_2 () {(( &TCIC_CHIPID_DB86082A) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_TCIC2N_2);
    eval 'sub TCIC_ILOCKTEST_DB86082A () { &TCIC_ILOCKTEST_TCIC2N_2;}' unless defined(&TCIC_ILOCKTEST_DB86082A);
    eval 'sub TCIC_ILOCKTEST_TCIC2N_3 () {(( &TCIC_CHIPID_DB86082B_ES) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_TCIC2N_3);
    eval 'sub TCIC_ILOCKTEST_DB86082B_ES () { &TCIC_ILOCKTEST_TCIC2N_3;}' unless defined(&TCIC_ILOCKTEST_DB86082B_ES);
    eval 'sub TCIC_ILOCKTEST_DB86082B () {(( &TCIC_CHIPID_DB86082B) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_DB86082B);
    eval 'sub TCIC_ILOCKTEST_DB86084_1 () {(( &TCIC_CHIPID_DB86084_1) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_DB86084_1);
    eval 'sub TCIC_ILOCKTEST_DB86084A () {(( &TCIC_CHIPID_DB86084A) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_DB86084A);
    eval 'sub TCIC_ILOCKTEST_DB86184_1 () {(( &TCIC_CHIPID_DB86184_1) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_DB86184_1);
    eval 'sub TCIC_ILOCKTEST_DB86072_1 () {(( &TCIC_CHIPID_DB86072_1) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_DB86072_1);
    eval 'sub TCIC_ILOCKTEST_DB86072_1_ES () {(( &TCIC_CHIPID_DB86072_1_ES) <<  &TCIC_ILOCKTEST_ID_SHFT);}' unless defined(&TCIC_ILOCKTEST_DB86072_1_ES);
    eval 'sub TCIC_R_TEST () {( &TCIC_R_AUX + 0);}' unless defined(&TCIC_R_TEST);
    eval 'sub TCIC_TEST_AEN () {(1<< 0);}' unless defined(&TCIC_TEST_AEN);
    eval 'sub TCIC_TEST_CEN () {(1<< 1);}' unless defined(&TCIC_TEST_CEN);
    eval 'sub TCIC_TEST_CTR () {(1<< 2);}' unless defined(&TCIC_TEST_CTR);
    eval 'sub TCIC_TEST_ENA () {(1<< 3);}' unless defined(&TCIC_TEST_ENA);
    eval 'sub TCIC_TEST_IO () {(1<< 4);}' unless defined(&TCIC_TEST_IO);
    eval 'sub TCIC_TEST_OUT1 () {(1<< 5);}' unless defined(&TCIC_TEST_OUT1);
    eval 'sub TCIC_TEST_ZPB () {(1<< 6);}' unless defined(&TCIC_TEST_ZPB);
    eval 'sub TCIC_TEST_WAIT () {(1<< 7);}' unless defined(&TCIC_TEST_WAIT);
    eval 'sub TCIC_TEST_PCTR () {(1<< 8);}' unless defined(&TCIC_TEST_PCTR);
    eval 'sub TCIC_TEST_VCTL () {(1<< 9);}' unless defined(&TCIC_TEST_VCTL);
    eval 'sub TCIC_TEST_EXTA () {(1<< 10);}' unless defined(&TCIC_TEST_EXTA);
    eval 'sub TCIC_TEST_DRIVECDB () {(1<< 11);}' unless defined(&TCIC_TEST_DRIVECDB);
    eval 'sub TCIC_TEST_ISTP () {(1<< 12);}' unless defined(&TCIC_TEST_ISTP);
    eval 'sub TCIC_TEST_BSTP () {(1<< 13);}' unless defined(&TCIC_TEST_BSTP);
    eval 'sub TCIC_TEST_CSTP () {(1<< 14);}' unless defined(&TCIC_TEST_CSTP);
    eval 'sub TCIC_TEST_DIAG () {(1<< 15);}' unless defined(&TCIC_TEST_DIAG);
    eval 'sub TCIC_SCF1_IRQ_MASK () {(0xf);}' unless defined(&TCIC_SCF1_IRQ_MASK);
    eval 'sub TCIC_SCF1_IRQOFF () {(0);}' unless defined(&TCIC_SCF1_IRQOFF);
    eval 'sub TCIC_SCF1_SIRQ () {(0x1);}' unless defined(&TCIC_SCF1_SIRQ);
    eval 'sub TCIC_SCF1_IRQ3 () {(0x3);}' unless defined(&TCIC_SCF1_IRQ3);
    eval 'sub TCIC_SCF1_IRQ4 () {(0x4);}' unless defined(&TCIC_SCF1_IRQ4);
    eval 'sub TCIC_SCF1_IRQ5 () {(0x5);}' unless defined(&TCIC_SCF1_IRQ5);
    eval 'sub TCIC_SCF1_IRQ6 () {(0x6);}' unless defined(&TCIC_SCF1_IRQ6);
    eval 'sub TCIC_SCF1_IRQ7 () {(0x7);}' unless defined(&TCIC_SCF1_IRQ7);
    eval 'sub TCIC_SCF1_IRQ9 () {(0x9);}' unless defined(&TCIC_SCF1_IRQ9);
    eval 'sub TCIC_SCF1_IRQ10 () {(0xa);}' unless defined(&TCIC_SCF1_IRQ10);
    eval 'sub TCIC_SCF1_IRQ11 () {(0xb);}' unless defined(&TCIC_SCF1_IRQ11);
    eval 'sub TCIC_SCF1_IRQ12 () {(0xc);}' unless defined(&TCIC_SCF1_IRQ12);
    eval 'sub TCIC_SCF1_IRQ14 () {(0xe);}' unless defined(&TCIC_SCF1_IRQ14);
    eval 'sub TCIC_SCF1_IRQ15 () {(0xf);}' unless defined(&TCIC_SCF1_IRQ15);
    eval 'sub TCIC_SCF1_IRQOD () {(1<< 4);}' unless defined(&TCIC_SCF1_IRQOD);
    eval 'sub TCIC_SCF1_IRQOC () {(0);}' unless defined(&TCIC_SCF1_IRQOC);
    eval 'sub TCIC_SCF1_PCVT () {(1<< 5);}' unless defined(&TCIC_SCF1_PCVT);
    eval 'sub TCIC_SCF1_IRDY () {(1<< 6);}' unless defined(&TCIC_SCF1_IRDY);
    eval 'sub TCIC_SCF1_ATA () {(1<< 7);}' unless defined(&TCIC_SCF1_ATA);
    eval 'sub TCIC_SCF1_DMA_SHIFT () {8;}' unless defined(&TCIC_SCF1_DMA_SHIFT);
    eval 'sub TCIC_SCF1_DMA_MASK () {(0x7 <<  &IRSCFG_DMA_SHIFT);}' unless defined(&TCIC_SCF1_DMA_MASK);
    eval 'sub TCIC_SCF1_DMAOFF () {(0<<  &IRSCFG_DMA_SHIFT);}' unless defined(&TCIC_SCF1_DMAOFF);
    eval 'sub TCIC_SCF1_DREQ2 () {(2<<  &IRSCFG_DMA_SHIFT);}' unless defined(&TCIC_SCF1_DREQ2);
    eval 'sub TCIC_SCF1_IOSTS () {(1<< 11);}' unless defined(&TCIC_SCF1_IOSTS);
    eval 'sub TCIC_SCF1_SPKR () {(1<< 12);}' unless defined(&TCIC_SCF1_SPKR);
    eval 'sub TCIC_SCF1_FINPACK () {(1<< 13);}' unless defined(&TCIC_SCF1_FINPACK);
    eval 'sub TCIC_SCF1_DELWR () {(1<< 14);}' unless defined(&TCIC_SCF1_DELWR);
    eval 'sub TCIC_SCF1_HD7IDE () {(1<< 15);}' unless defined(&TCIC_SCF1_HD7IDE);
    eval 'sub TCIC_SCF2_RI () {(1<< 0);}' unless defined(&TCIC_SCF2_RI);
    eval 'sub TCIC_SCF2_IDBR () {(1<< 1);}' unless defined(&TCIC_SCF2_IDBR);
    eval 'sub TCIC_SCF2_MDBR () {(1<< 2);}' unless defined(&TCIC_SCF2_MDBR);
    eval 'sub TCIC_SCF2_MLBAT1 () {(1<< 3);}' unless defined(&TCIC_SCF2_MLBAT1);
    eval 'sub TCIC_SCF2_MLBAT2 () {(1<< 4);}' unless defined(&TCIC_SCF2_MLBAT2);
    eval 'sub TCIC_SCF2_MRDY () {(1<< 5);}' unless defined(&TCIC_SCF2_MRDY);
    eval 'sub TCIC_SCF2_MWP () {(1<< 6);}' unless defined(&TCIC_SCF2_MWP);
    eval 'sub TCIC_SCF2_MCD () {(1<< 7);}' unless defined(&TCIC_SCF2_MCD);
    eval 'sub TCIC_SCF2_DMASRC_MASK () {(0x3 << 8);}' unless defined(&TCIC_SCF2_DMASRC_MASK);
    eval 'sub TCIC_SCF2_DRQ_BVD2 () {(0x << 8);}' unless defined(&TCIC_SCF2_DRQ_BVD2);
    eval 'sub TCIC_SCF2_DRQ_IOIS16 () {(0x1 << 8);}' unless defined(&TCIC_SCF2_DRQ_IOIS16);
    eval 'sub TCIC_SCF2_DRQ_INPACK () {(0x2 << 8);}' unless defined(&TCIC_SCF2_DRQ_INPACK);
    eval 'sub TCIC_SCF2_DRQ_FORCE () {(0x3 << 8);}' unless defined(&TCIC_SCF2_DRQ_FORCE);
    eval 'sub TCIC_SCFS2_RSVD () {(0xfc00);}' unless defined(&TCIC_SCFS2_RSVD);
    eval 'sub TCIC_MBASE_4K () {(1<< 14);}' unless defined(&TCIC_MBASE_4K);
    eval 'sub TCIC_MBASE_ADDR_MASK () {0xfff;}' unless defined(&TCIC_MBASE_ADDR_MASK);
    eval 'sub TCIC_MMAP_ATTR () {(1<< 15);}' unless defined(&TCIC_MMAP_ATTR);
    eval 'sub TCIC_MMAP_ADDR_MASK () {0x3fff;}' unless defined(&TCIC_MMAP_ADDR_MASK);
    eval 'sub TCIC_MCTL_ENA () {(1<< 15);}' unless defined(&TCIC_MCTL_ENA);
    eval 'sub TCIC_MCTL_SS_SHIFT () {12;}' unless defined(&TCIC_MCTL_SS_SHIFT);
    eval 'sub TCIC_MCTL_SS_MASK () {(7<<  &TCIC_MCTL_SS_SHIFT);}' unless defined(&TCIC_MCTL_SS_MASK);
    eval 'sub TCIC_MCTL_B8 () {(1<< 11);}' unless defined(&TCIC_MCTL_B8);
    eval 'sub TCIC_MCTL_EDC () {(1<< 10);}' unless defined(&TCIC_MCTL_EDC);
    eval 'sub TCIC_MCTL_KE () {(1<< 9);}' unless defined(&TCIC_MCTL_KE);
    eval 'sub TCIC_MCTL_ACC () {(1<< 8);}' unless defined(&TCIC_MCTL_ACC);
    eval 'sub TCIC_MCTL_WP () {(1<< 7);}' unless defined(&TCIC_MCTL_WP);
    eval 'sub TCIC_MCTL_QUIET () {(1<< 6);}' unless defined(&TCIC_MCTL_QUIET);
    eval 'sub TCIC_MCTL_WSCNT_MASK () {0xf;}' unless defined(&TCIC_MCTL_WSCNT_MASK);
    eval 'sub TCIC_ICTL_ENA () {(1<< 15);}' unless defined(&TCIC_ICTL_ENA);
    eval 'sub TCIC_ICTL_SS_SHIFT () {12;}' unless defined(&TCIC_ICTL_SS_SHIFT);
    eval 'sub TCIC_ICTL_SS_MASK () {(7<<  &TCIC_ICTL_SS_SHIFT);}' unless defined(&TCIC_ICTL_SS_MASK);
    eval 'sub TCIC_ICTL_AUTOSZ () {0;}' unless defined(&TCIC_ICTL_AUTOSZ);
    eval 'sub TCIC_ICTL_B8 () {(1<< 11);}' unless defined(&TCIC_ICTL_B8);
    eval 'sub TCIC_ICTL_B16 () {(1<< 10);}' unless defined(&TCIC_ICTL_B16);
    eval 'sub TCIC_ICTL_ATA () {(3<< 10);}' unless defined(&TCIC_ICTL_ATA);
    eval 'sub TCIC_ICTL_TINY () {(1<< 9);}' unless defined(&TCIC_ICTL_TINY);
    eval 'sub TCIC_ICTL_ACC () {(1<< 8);}' unless defined(&TCIC_ICTL_ACC);
    eval 'sub TCIC_ICTL_1K () {(1<< 7);}' unless defined(&TCIC_ICTL_1K);
    eval 'sub TCIC_ICTL_QUIET () {(1<< 6);}' unless defined(&TCIC_ICTL_QUIET);
    eval 'sub TCIC_ICTL_PASS16 () {(1<< 5);}' unless defined(&TCIC_ICTL_PASS16);
    eval 'sub TCIC_ICTL_WSCNT_MASK () {0xf;}' unless defined(&TCIC_ICTL_WSCNT_MASK);
    if(0) {
	eval 'sub INVALID_AR_SYSCFG {
	    my($x) = @_;
    	    eval q((((($x)&0x1000)  && ((($x)&0xc00) != 0x200)) || ((((($x)&0x8) == 0) || ((($x)&0x3) == 2))  && (($x) != 0x2))));
	}' unless defined(&INVALID_AR_SYSCFG);
    } else {
	eval 'sub INVALID_AR_SYSCFG {
	    my($x) = @_;
    	    eval q((((($x)&0x800)  && ((($x)&0x600) != 0x100)) || (((((($x)&0x8) == 0)  && ((($x)&0x3) == 2)) || ((($x)&0x3) == 2))  && (($x) != 0x2))));
	}' unless defined(&INVALID_AR_SYSCFG);
    }
    eval 'sub INVALID_AR_ILOCK {
        my($x) = @_;
	    eval q(((($x)&0xc0)==0|| ((($x)&0xc0)==0xc0)));
    }' unless defined(&INVALID_AR_ILOCK);
    eval 'sub INVALID_AR_TEST {
        my($x) = @_;
	    eval q(((($x)&0154) != 0));
    }' unless defined(&INVALID_AR_TEST);
    eval 'sub TCIC_IO_WINS () {2;}' unless defined(&TCIC_IO_WINS);
    eval 'sub TCIC_MAX_MEM_WINS () {5;}' unless defined(&TCIC_MAX_MEM_WINS);
    eval 'sub TCIC_MEM_SHIFT () {12;}' unless defined(&TCIC_MEM_SHIFT);
    eval 'sub TCIC_MEM_PAGESIZE () {(1<< &TCIC_MEM_SHIFT);}' unless defined(&TCIC_MEM_PAGESIZE);
}
1;
