/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.IframeUtil;

public class ThirdPartyCookiesIframeEndpoint {
    private final KeycloakSession session;

    public ThirdPartyCookiesIframeEndpoint(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Path(value="step1.html")
    @Produces(value={"text/html; charset=utf-8"})
    public Response step1(@QueryParam(value="version") String version) {
        return IframeUtil.returnIframeFromResources("3p-cookies-step1.html", version, this.session);
    }

    @GET
    @Path(value="step2.html")
    @Produces(value={"text/html; charset=utf-8"})
    public Response step2(@QueryParam(value="version") String version) {
        return IframeUtil.returnIframeFromResources("3p-cookies-step2.html", version, this.session);
    }
}

