/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.keycloak.Config;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class MicroProfileConfigProvider
implements Config.ConfigProvider {
    public static final String NS_KEYCLOAK = "kc";
    public static final String NS_KEYCLOAK_PREFIX = "kc.";
    public static final String SPI_PREFIX = "kc.spi" + Configuration.OPTION_PART_SEPARATOR;
    public static final String NS_QUARKUS = "quarkus";
    public static final String NS_QUARKUS_PREFIX = "quarkus.";
    private final Config config;

    public MicroProfileConfigProvider() {
        this(ConfigProvider.getConfig());
    }

    public MicroProfileConfigProvider(Config config) {
        this.config = config;
    }

    public String getProvider(String spi) {
        return this.scope(spi).get("provider");
    }

    public String getDefaultProvider(String spi) {
        return this.scope(spi).get("provider-default");
    }

    public Config.Scope scope(String ... scope) {
        return new MicroProfileScope(SPI_PREFIX, scope);
    }

    public class MicroProfileScope
    implements Config.Scope {
        private final String prefix;
        private final String separatorPrefix;

        public MicroProfileScope(String prefix, String ... scopes) {
            StringBuilder prefixBuilder = new StringBuilder(prefix);
            for (String scope : scopes) {
                prefixBuilder.append(Configuration.toDashCase(scope)).append(Configuration.OPTION_PART_SEPARATOR + Configuration.OPTION_PART_SEPARATOR);
            }
            this.separatorPrefix = prefixBuilder.toString();
            this.prefix = this.separatorPrefix.replace(Configuration.OPTION_PART_SEPARATOR + Configuration.OPTION_PART_SEPARATOR, Configuration.OPTION_PART_SEPARATOR);
        }

        public String get(String key) {
            return this.getValue(key, String.class, null);
        }

        public String get(String key, String defaultValue) {
            return this.getValue(key, String.class, defaultValue);
        }

        public String[] getArray(String key) {
            return this.getValue(key, String[].class, null);
        }

        public Integer getInt(String key) {
            return this.getValue(key, Integer.class, null);
        }

        public Integer getInt(String key, Integer defaultValue) {
            return this.getValue(key, Integer.class, defaultValue);
        }

        public Long getLong(String key) {
            return this.getValue(key, Long.class, null);
        }

        public Long getLong(String key, Long defaultValue) {
            return this.getValue(key, Long.class, defaultValue);
        }

        public Boolean getBoolean(String key) {
            return this.getValue(key, Boolean.class, null);
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            return this.getValue(key, Boolean.class, defaultValue);
        }

        public Config.Scope scope(String ... scope) {
            return new MicroProfileScope(this.prefix, scope);
        }

        public Set<String> getPropertyNames() {
            return StreamSupport.stream(MicroProfileConfigProvider.this.config.getPropertyNames().spliterator(), false).filter(key -> key.startsWith(this.separatorPrefix)).collect(Collectors.toSet());
        }

        private <T> T getValue(String key, Class<T> clazz, T defaultValue) {
            String dashCase = Configuration.toDashCase(key);
            return MicroProfileConfigProvider.this.config.getOptionalValue(this.separatorPrefix.concat(dashCase), clazz).or(() -> MicroProfileConfigProvider.this.config.getOptionalValue(this.prefix.concat(dashCase), clazz)).orElse(defaultValue);
        }
    }
}

