/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.opentelemetry.api.trace.Span;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.UserSessionUtil;
import org.keycloak.tracing.TracingAttributes;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.util.JsonSerialization;

public class AccessTokenIntrospectionProvider<T extends AccessToken>
implements TokenIntrospectionProvider {
    protected final KeycloakSession session;
    protected final TokenManager tokenManager;
    protected final RealmModel realm;
    private static final Logger logger = Logger.getLogger(AccessTokenIntrospectionProvider.class);
    protected EventBuilder eventBuilder;
    protected T token;
    protected ClientModel client;
    protected UserSessionModel userSession;
    protected UserModel user;

    public AccessTokenIntrospectionProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
    }

    public Response introspect(String tokenStr, EventBuilder eventBuilder) {
        this.eventBuilder = eventBuilder;
        AccessToken accessToken = null;
        try {
            boolean isJwtRequest;
            ObjectNode tokenMetadata;
            ClientModel authenticatedClient = this.session.getContext().getClient();
            if (this.introspectionChecks(tokenStr)) {
                String actor;
                accessToken = this.transformAccessToken((AccessToken)this.token, this.userSession);
                tokenMetadata = JsonSerialization.createObjectNode((Object)accessToken);
                tokenMetadata.put("client_id", accessToken.getIssuedFor());
                String scope = accessToken.getScope();
                if (scope != null && scope.trim().isEmpty()) {
                    tokenMetadata.remove("scope");
                }
                if (!tokenMetadata.has("username")) {
                    if (accessToken.getPreferredUsername() != null) {
                        tokenMetadata.put("username", accessToken.getPreferredUsername());
                    } else {
                        UserModel userModel = this.userSession.getUser();
                        if (userModel != null) {
                            tokenMetadata.put("username", userModel.getUsername());
                            eventBuilder.user(userModel);
                        }
                    }
                }
                if ((actor = this.userSession.getNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString())) != null) {
                    tokenMetadata.putObject("act").put("sub", actor);
                }
                tokenMetadata.put("token_type", accessToken.getType());
                tokenMetadata.put("active", true);
                eventBuilder.success();
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
                logger.debug((Object)"Keycloak token introspection return false");
                tokenMetadata.put("active", false);
            }
            if (accessToken != null && (isJwtRequest = "application/jwt".equals(this.session.getContext().getRequestHeaders().getHeaderString("Accept"))) && Boolean.parseBoolean(authenticatedClient.getAttribute("client.introspection.response.allow.jwt.claim.enabled"))) {
                tokenMetadata.put("jwt", this.session.tokens().encode((Token)accessToken));
            }
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            String clientId = accessToken != null ? accessToken.getIssuedFor() : "unknown";
            logger.debugf((Throwable)e, "Exception during Keycloak introspection for %s client in realm %s", (Object)clientId, (Object)this.realm.getName());
            eventBuilder.detail("reason", e.getMessage());
            eventBuilder.error("token_introspection_failed");
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    public AccessToken transformAccessToken(AccessToken token, UserSessionModel userSession) {
        ClientModel client = this.realm.getClientByClientId(token.getIssuedFor());
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (clientSession == null) {
            return token;
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, token.getScope(), this.session);
        AccessToken smallToken = this.getAccessTokenFromStoredData(token);
        return this.tokenManager.transformIntrospectionAccessToken(this.session, smallToken, userSession, clientSessionCtx);
    }

    private AccessToken getAccessTokenFromStoredData(AccessToken token) {
        AccessToken newToken = new AccessToken();
        newToken.id(token.getId());
        newToken.type(token.getType());
        newToken.subject(token.getSubject());
        newToken.iat(token.getIat());
        newToken.exp(token.getExp());
        newToken.issuedFor(token.getIssuedFor());
        newToken.issuer(token.getIssuer());
        newToken.setNonce(token.getNonce());
        newToken.setScope(token.getScope());
        newToken.setSessionId(token.getSessionId());
        newToken.audience(token.getAudience());
        newToken.setConfirmation(token.getConfirmation());
        return newToken;
    }

    protected boolean introspectionChecks(String tokenStr) {
        if (!this.verifyToken(tokenStr)) {
            return false;
        }
        if (!this.verifyClient()) {
            return false;
        }
        this.eventBuilder.session(this.token.getSessionId());
        UserSessionUtil.UserSessionValidationResult result = this.verifyUserSession();
        if (result.getError() != null) {
            logger.debugf("Introspection access token for " + this.token.getIssuedFor() + " client: " + result.getError(), new Object[0]);
            this.eventBuilder.detail("reason", "Introspection access token for " + this.token.getIssuedFor() + " client: " + result.getError());
            this.eventBuilder.error(result.getError());
            return false;
        }
        this.userSession = result.getUserSession();
        this.user = this.userSession.getUser();
        this.eventBuilder.user(this.user);
        if (!TokenManager.isUserValid(this.session, this.realm, this.token, this.userSession.getUser())) {
            logger.debugf("Could not find valid user from user session " + this.userSession.getId(), new Object[0]);
            this.eventBuilder.detail("reason", "Could not find valid user from user session " + this.userSession.getId());
            this.eventBuilder.error(this.user == null ? "user_not_found" : "user_disabled");
            return false;
        }
        return this.verifyTokenReuse();
    }

    protected boolean verifyToken(String tokenStr) {
        try {
            TokenVerifier verifier = TokenVerifier.create((String)tokenStr, this.getTokenClass()).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            this.token = (AccessToken)verifier.verify().getToken();
            this.eventBuilder.detail("token_id", this.token.getId());
            this.eventBuilder.detail("token_type", this.token.getType());
            TracingProvider tracing = (TracingProvider)this.session.getProvider(TracingProvider.class);
            Span span = tracing.getCurrentSpan();
            if (span.isRecording()) {
                span.setAttribute(TracingAttributes.TOKEN_ISSUER, (Object)this.token.getIssuer());
                span.setAttribute(TracingAttributes.TOKEN_SID, (Object)this.token.getSessionId());
                span.setAttribute(TracingAttributes.TOKEN_ID, (Object)this.token.getId());
            }
            return true;
        }
        catch (VerificationException e) {
            logger.debugf("Introspection access token : JWT check failed: %s", (Object)e.getMessage());
            this.eventBuilder.detail("reason", "Access token JWT check failed");
            this.eventBuilder.error("invalid_token");
            return false;
        }
    }

    protected Class<T> getTokenClass() {
        return AccessToken.class;
    }

    protected boolean verifyClient() {
        this.eventBuilder.detail("token_issued_for", this.token.getIssuedFor());
        ClientModel client = this.realm.getClientByClientId(this.token.getIssuedFor());
        if (client == null) {
            logger.debugf("Introspection access token : client with clientId %s does not exist", (Object)this.token.getIssuedFor());
            this.eventBuilder.detail("reason", String.format("Could not find client for %s", this.token.getIssuedFor()));
            this.eventBuilder.error("client_not_found");
            return false;
        }
        if (!client.isEnabled()) {
            logger.debugf("Introspection access token : client with clientId %s is disabled", (Object)this.token.getIssuedFor());
            this.eventBuilder.detail("reason", String.format("Client with clientId %s is disabled", this.token.getIssuedFor()));
            this.eventBuilder.error("client_disabled");
            return false;
        }
        try {
            TokenVerifier.createWithoutSignature(this.token).withChecks(new TokenVerifier.Predicate[]{TokenManager.NotBeforeCheck.forModel(client), TokenVerifier.IS_ACTIVE, new TokenManager.TokenRevocationCheck(this.session)}).verify();
            this.client = client;
            return true;
        }
        catch (VerificationException e) {
            logger.debugf("Introspection access token for %s client: JWT check failed: %s", (Object)this.token.getIssuedFor(), (Object)e.getMessage());
            this.eventBuilder.detail("reason", "Introspection access token for " + this.token.getIssuedFor() + " client: JWT check failed");
            this.eventBuilder.error("invalid_token");
            return false;
        }
    }

    protected UserSessionUtil.UserSessionValidationResult verifyUserSession() {
        return UserSessionUtil.findValidSessionForAccessToken(this.session, this.realm, this.token, this.client, invalidUserSession -> {});
    }

    protected boolean verifyTokenReuse() {
        return true;
    }

    public void close() {
    }
}

