/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.BasicConsole;
import io.quarkus.dev.console.RedirectPrintStream;
import io.quarkus.dev.console.StatusLine;
import io.quarkus.dev.console.TerminalUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public abstract class QuarkusConsole {
    public static final int TEST_STATUS = 100;
    public static final int TEST_RESULTS = 200;
    public static final int COMPILE_ERROR = 300;
    public static final String FORCE_COLOR_SUPPORT = "io.quarkus.force-color-support";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    public static final boolean IS_MAC = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    public static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("linux");
    public static final boolean IS_CON_EMU_ANSI = IS_WINDOWS && "ON".equals(System.getenv("ConEmuANSI"));
    public static final boolean IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
    public static final boolean IS_MINGW_XTERM = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));
    protected volatile Consumer<int[]> inputHandler;
    public static volatile QuarkusConsole INSTANCE = new BasicConsole(QuarkusConsole.hasColorSupport(), false, System.out::print);
    public static volatile boolean installed;
    protected static final List<BiPredicate<String, Boolean>> outputFilters;
    private volatile boolean started = false;
    static boolean redirectsInstalled;
    public static final PrintStream ORIGINAL_OUT;
    public static final PrintStream ORIGINAL_ERR;
    public static final InputStream ORIGINAL_IN;
    public static PrintStream REDIRECT_OUT;
    public static PrintStream REDIRECT_ERR;
    public static StateChangeInputStream REDIRECT_IN;
    protected volatile boolean userReadInProgress;

    public static synchronized void installRedirects() {
        if (redirectsInstalled) {
            return;
        }
        redirectsInstalled = true;
        INSTANCE.isInputSupported();
        REDIRECT_OUT = new RedirectPrintStream(false);
        REDIRECT_ERR = new RedirectPrintStream(true);
        REDIRECT_IN = new StateChangeInputStream();
        System.setOut(REDIRECT_OUT);
        System.setErr(REDIRECT_ERR);
        System.setIn(REDIRECT_IN);
    }

    public static synchronized void uninstallRedirects() {
        if (!redirectsInstalled) {
            return;
        }
        if (REDIRECT_OUT != null) {
            REDIRECT_OUT.flush();
            REDIRECT_OUT.close();
            REDIRECT_OUT = null;
        }
        if (REDIRECT_ERR != null) {
            REDIRECT_ERR.flush();
            REDIRECT_ERR.close();
            REDIRECT_ERR = null;
        }
        REDIRECT_IN = null;
        System.setOut(ORIGINAL_OUT);
        System.setErr(ORIGINAL_ERR);
        System.setIn(ORIGINAL_IN);
        redirectsInstalled = false;
    }

    private static void checkAndSetJdkConsole() {
        String res = System.getProperty("jdk.console");
        if (res == null) {
            System.setProperty("jdk.console", "java.base");
        }
    }

    public static boolean hasColorSupport() {
        QuarkusConsole.checkAndSetJdkConsole();
        if (Boolean.getBoolean(FORCE_COLOR_SUPPORT)) {
            return true;
        }
        if (IS_WINDOWS) {
            return IS_CON_EMU_ANSI || IS_CYGWIN || IS_MINGW_XTERM;
        }
        return TerminalUtils.isTerminal(System.console());
    }

    public static void start() {
        INSTANCE.startInternal();
    }

    private synchronized void startInternal() {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    public void setInputHandler(Consumer<int[]> inputHandler) {
        this.inputHandler = inputHandler;
    }

    public abstract void doReadLine();

    public abstract StatusLine registerStatusLine(int var1);

    public abstract void setPromptMessage(String var1);

    public abstract void write(boolean var1, String var2);

    public abstract void write(boolean var1, byte[] var2, int var3, int var4);

    public void exitCliMode() {
    }

    public Map<Character, String> singleLetterAliases() {
        return Map.of();
    }

    public void runAlias(char alias) {
    }

    protected String stripAnsiCodes(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "");
        return s;
    }

    public static void addOutputFilter(BiPredicate<String, Boolean> logHandler) {
        outputFilters.add(logHandler);
    }

    public static void removeOutputFilter(BiPredicate<String, Boolean> logHandler) {
        outputFilters.remove(logHandler);
    }

    protected boolean shouldWrite(boolean errorStream, String s) {
        boolean ok = true;
        for (BiPredicate<String, Boolean> i : outputFilters) {
            if (i.test(s, errorStream)) continue;
            ok = false;
        }
        return ok;
    }

    public boolean isInputSupported() {
        return true;
    }

    public boolean isAnsiSupported() {
        return false;
    }

    protected void userReadStart() {
    }

    protected void userReadStop() {
    }

    static {
        outputFilters = new CopyOnWriteArrayList<BiPredicate<String, Boolean>>();
        redirectsInstalled = false;
        ORIGINAL_OUT = System.out;
        ORIGINAL_ERR = System.err;
        ORIGINAL_IN = System.in;
        REDIRECT_OUT = null;
        REDIRECT_ERR = null;
    }

    public static class StateChangeInputStream
    extends InputStream {
        private final LinkedBlockingDeque<Integer> queue = new LinkedBlockingDeque();
        private volatile boolean reading;

        public synchronized boolean acceptInput(int input) {
            if (this.reading) {
                this.queue.add(input);
                this.notifyAll();
                return true;
            }
            return false;
        }

        @Override
        public synchronized int read() throws IOException {
            this.reading = true;
            try {
                while (this.queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
                int n = this.queue.pollFirst();
                return n;
            }
            finally {
                this.reading = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            this.reading = true;
            int read = 0;
            try {
                while (read < len) {
                    while (this.queue.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                    byte byteValue = this.queue.poll().byteValue();
                    b[read++] = byteValue;
                    if (byteValue != 10 && byteValue != 13) continue;
                    int n = read;
                    return n;
                }
                int n = read;
                return n;
            }
            finally {
                this.reading = false;
            }
        }
    }
}

