/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.netty.buffer.ByteBuf;
import io.undertow.UndertowLogger;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.GSSContextCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.FlexBase64;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class GSSAPIAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String NEGOTIATION_PLAIN = "Negotiate".toString();
    private static final String NEGOTIATE_PREFIX = "Negotiate ";
    private static final Oid[] DEFAULT_MECHANISMS;
    private static final String name = "SPNEGO";
    private final IdentityManager identityManager;
    private final GSSAPIServerSubjectFactory subjectFactory;
    private final Oid[] mechanisms;

    public GSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory, IdentityManager identityManager, Oid ... supportedMechanisms) {
        this.subjectFactory = subjectFactory;
        this.identityManager = identityManager;
        this.mechanisms = supportedMechanisms;
    }

    public GSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory, Oid ... supportedMechanisms) {
        this(subjectFactory, (IdentityManager)null, supportedMechanisms);
    }

    public GSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory) {
        this(subjectFactory, DEFAULT_MECHANISMS);
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        List<String> authHeaders;
        NegotiationContext negContext = exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
        if (negContext != null) {
            UndertowLogger.SECURITY_LOGGER.debugf("Existing negotiation context found for %s", exchange);
            exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, negContext);
            if (negContext.isEstablished()) {
                IdentityManager identityManager = this.getIdentityManager(securityContext);
                Account account = identityManager.verify(new GSSContextCredential(negContext.getGssContext()));
                if (account != null) {
                    securityContext.authenticationComplete(account, name, false);
                    UndertowLogger.SECURITY_LOGGER.debugf("Authenticated as user %s with existing GSSAPI negotiation context for %s", account.getPrincipal().getName(), exchange);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                UndertowLogger.SECURITY_LOGGER.debugf("Failed to authenticate with existing GSSAPI negotiation context for %s", exchange);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        if ((authHeaders = exchange.getRequestHeaders("Authorization")) != null) {
            for (String current : authHeaders) {
                if (!current.startsWith(NEGOTIATE_PREFIX)) continue;
                String base64Challenge = current.substring(NEGOTIATE_PREFIX.length());
                try {
                    ByteBuf challenge = FlexBase64.decode(base64Challenge);
                    return this.runGSSAPI(exchange, challenge, securityContext);
                }
                catch (IOException iOException) {
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        NegotiationContext negContext = exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
        Object header = NEGOTIATION_PLAIN;
        if (negContext != null) {
            byte[] responseChallenge = negContext.useResponseToken();
            exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, null);
            if (responseChallenge != null) {
                header = NEGOTIATE_PREFIX + FlexBase64.encodeString(responseChallenge, false);
            }
        } else {
            Subject server = null;
            try {
                server = this.subjectFactory.getSubjectForHost(this.getHostName(exchange));
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (server == null) {
                return AuthenticationMechanism.ChallengeResult.NOT_SENT;
            }
        }
        exchange.addResponseHeader("WWW-Authenticate", (String)header);
        UndertowLogger.SECURITY_LOGGER.debugf("Sending GSSAPI challenge for %s", exchange);
        return new AuthenticationMechanism.ChallengeResult(true, 401);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome runGSSAPI(HttpServerExchange exchange, ByteBuf challenge, SecurityContext securityContext) {
        try {
            Subject server = this.subjectFactory.getSubjectForHost(this.getHostName(exchange));
            return Subject.doAs(server, new AcceptSecurityContext(exchange, challenge, securityContext));
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }

    private String getHostName(HttpServerExchange exchange) {
        String hostName = exchange.getRequestHeader("Host");
        if (hostName != null) {
            if (hostName.startsWith("[") && hostName.contains("]")) {
                hostName = hostName.substring(0, hostName.indexOf(93) + 1);
            } else if (hostName.contains(":")) {
                hostName = hostName.substring(0, hostName.indexOf(":"));
            }
            return hostName;
        }
        return null;
    }

    static {
        try {
            Oid spnego = new Oid("1.3.6.1.5.5.2");
            Oid kerberos = new Oid("1.2.840.113554.1.2.2");
            DEFAULT_MECHANISMS = new Oid[]{spnego, kerberos};
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NegotiationContext {
        static final AttachmentKey<NegotiationContext> ATTACHMENT_KEY = AttachmentKey.create(NegotiationContext.class);
        private GSSContext gssContext;
        private byte[] responseToken;
        private Principal principal;

        private NegotiationContext() {
        }

        GSSContext getGssContext() {
            return this.gssContext;
        }

        void setGssContext(GSSContext gssContext) {
            this.gssContext = gssContext;
        }

        byte[] useResponseToken() {
            try {
                byte[] byArray = this.responseToken;
                return byArray;
            }
            finally {
                this.responseToken = null;
            }
        }

        void setResponseToken(byte[] responseToken) {
            this.responseToken = responseToken;
        }

        boolean isEstablished() {
            return this.gssContext != null ? this.gssContext.isEstablished() : false;
        }

        Principal getPrincipal() {
            if (!this.isEstablished()) {
                throw new IllegalStateException("No established GSSContext to use for the Principal.");
            }
            if (this.principal == null) {
                try {
                    this.principal = new KerberosPrincipal(this.gssContext.getSrcName().toString());
                }
                catch (GSSException e) {
                    throw new IllegalStateException("Unable to create Principal", e);
                }
            }
            return this.principal;
        }
    }

    private class AcceptSecurityContext
    implements PrivilegedExceptionAction<AuthenticationMechanism.AuthenticationMechanismOutcome> {
        private final HttpServerExchange exchange;
        private final ByteBuf challenge;
        private final SecurityContext securityContext;

        private AcceptSecurityContext(HttpServerExchange exchange, ByteBuf challenge, SecurityContext securityContext) {
            this.exchange = exchange;
            this.challenge = challenge;
            this.securityContext = securityContext;
        }

        @Override
        public AuthenticationMechanism.AuthenticationMechanismOutcome run() throws GSSException {
            GSSContext gssContext;
            NegotiationContext negContext = this.exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
            if (negContext == null) {
                negContext = new NegotiationContext();
                this.exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, negContext);
            }
            if ((gssContext = negContext.getGssContext()) == null) {
                GSSManager manager = GSSManager.getInstance();
                GSSCredential credential = manager.createCredential(null, Integer.MAX_VALUE, GSSAPIAuthenticationMechanism.this.mechanisms, 2);
                gssContext = manager.createContext(credential);
                negContext.setGssContext(gssContext);
            }
            byte[] respToken = gssContext.acceptSecContext(this.challenge.array(), this.challenge.arrayOffset(), this.challenge.writerIndex());
            negContext.setResponseToken(respToken);
            if (negContext.isEstablished()) {
                IdentityManager identityManager;
                Account account;
                if (respToken != null) {
                    this.exchange.addResponseHeader("WWW-Authenticate", GSSAPIAuthenticationMechanism.NEGOTIATE_PREFIX + FlexBase64.encodeString(respToken, false));
                }
                if ((account = (identityManager = this.securityContext.getIdentityManager()).verify(new GSSContextCredential(negContext.getGssContext()))) != null) {
                    this.securityContext.authenticationComplete(account, GSSAPIAuthenticationMechanism.name, false);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }
}

