/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.devui.Name;
import io.quarkus.arc.processor.InterceptorInfo;
import jakarta.enterprise.inject.spi.InterceptionType;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;

public class DevInterceptorInfo
implements Comparable<DevInterceptorInfo> {
    private final String id;
    private final Name interceptorClass;
    private final Set<Name> bindings;
    private final int priority;
    private final Set<InterceptionType> intercepts;
    private final boolean isApplicationBean;

    public static DevInterceptorInfo from(InterceptorInfo interceptor, CompletedApplicationClassPredicateBuildItem predicate) {
        boolean isApplicationBean = predicate.test(interceptor.getBeanClass());
        HashSet<Name> bindings = new HashSet<Name>();
        for (AnnotationInstance binding : interceptor.getBindings()) {
            bindings.add(Name.from(binding));
        }
        HashSet<InterceptionType> intercepts = new HashSet<InterceptionType>();
        if (interceptor.intercepts(InterceptionType.AROUND_INVOKE)) {
            intercepts.add(InterceptionType.AROUND_INVOKE);
        }
        if (interceptor.intercepts(InterceptionType.AROUND_CONSTRUCT)) {
            intercepts.add(InterceptionType.AROUND_CONSTRUCT);
        }
        if (interceptor.intercepts(InterceptionType.POST_CONSTRUCT)) {
            intercepts.add(InterceptionType.POST_CONSTRUCT);
        }
        if (interceptor.intercepts(InterceptionType.PRE_DESTROY)) {
            intercepts.add(InterceptionType.PRE_DESTROY);
        }
        return new DevInterceptorInfo(interceptor.getIdentifier(), Name.from(interceptor.getBeanClass()), bindings, interceptor.getPriority(), intercepts, isApplicationBean);
    }

    DevInterceptorInfo(String id, Name interceptorClass, Set<Name> bindings, int priority, Set<InterceptionType> intercepts, boolean isApplicationBean) {
        this.id = id;
        this.interceptorClass = interceptorClass;
        this.bindings = bindings;
        this.priority = priority;
        this.intercepts = intercepts;
        this.isApplicationBean = isApplicationBean;
    }

    public String getId() {
        return this.id;
    }

    public Name getInterceptorClass() {
        return this.interceptorClass;
    }

    public Set<Name> getBindings() {
        return this.bindings;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<InterceptionType> getIntercepts() {
        return this.intercepts;
    }

    @Override
    public int compareTo(DevInterceptorInfo o) {
        if (this.isApplicationBean == o.isApplicationBean) {
            return this.interceptorClass.compareTo(o.interceptorClass);
        }
        return this.isApplicationBean ? -1 : 1;
    }
}

